/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.iterator;

import java.util.Iterator;

public class ChainedIterable<T>
implements Iterable<T> {
    protected Iterable<T>[] iterables = null;

    public ChainedIterable(Iterable<T> ... iterables) {
        this.iterables = iterables;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int iterableIndexPosition = -1;
            private Iterator<T> currentIterator = null;

            public boolean switchToNextIterable() {
                boolean retval = false;
                this.currentIterator = null;
                if (++this.iterableIndexPosition < ChainedIterable.this.iterables.length) {
                    this.currentIterator = ChainedIterable.this.iterables[this.iterableIndexPosition].iterator();
                    retval = true;
                }
                return retval;
            }

            @Override
            public boolean hasNext() {
                boolean retval = false;
                if (this.currentIterator != null || this.switchToNextIterable() && this.currentIterator != null) {
                    while (!this.currentIterator.hasNext() && this.switchToNextIterable() && this.currentIterator != null) {
                    }
                    retval = this.currentIterator != null && this.currentIterator.hasNext();
                }
                return retval;
            }

            @Override
            public T next() {
                Object retval = null;
                if (this.hasNext()) {
                    retval = this.currentIterator.next();
                }
                return retval;
            }

            @Override
            public void remove() {
                if (this.currentIterator != null) {
                    this.currentIterator.remove();
                }
            }
        };
    }
}

