/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.iterator;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.ObjectUtils;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.element.ElementStream;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.element.factory.Factory;
import org.omnaest.utils.structure.iterator.ChainedIterable;
import org.omnaest.utils.structure.iterator.IteratorUtils;

public class IterableUtils {
    public static <FROM, TO> Iterable<TO> adapter(final Iterable<? extends FROM> iterable, final ElementConverter<FROM, TO> elementConverter) {
        return new Iterable<TO>(){

            @Override
            public Iterator<TO> iterator() {
                return IteratorUtils.adapter(iterable.iterator(), elementConverter);
            }
        };
    }

    public static <E> Iterable<E> circular(Iterable<E> iterable) {
        long limit = -1L;
        return IterableUtils.circular(iterable, limit);
    }

    public static <E> Iterable<E> circular(final Iterable<E> iterable, final long limit) {
        Assert.isNotNull(iterable);
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                Factory iteratorFactory = new Factory<Iterator<E>>(){
                    private long counter = 0L;

                    @Override
                    public Iterator<E> newInstance() {
                        return limit < 0L || this.counter++ < limit ? iterable.iterator() : null;
                    }
                };
                return IteratorUtils.factoryBasedIterator(iteratorFactory);
            }
        };
    }

    public static <FROM, TO> Iterable<TO> convert(Iterable<FROM> iterable, ElementConverter<FROM, TO> elementConverter) {
        return ListUtils.convert(ListUtils.valueOf(iterable), elementConverter);
    }

    public static <E> int countEquals(Iterable<E> iterable, E element) {
        int retval = 0;
        if (iterable != null) {
            for (E iElement : iterable) {
                if (!ObjectUtils.equals(element, iElement)) continue;
                ++retval;
            }
        }
        return retval;
    }

    public static <E> E elementAt(Iterable<E> iterable, int indexPosition) {
        Iterator<E> iterator;
        E retval = null;
        if (iterable != null && (iterator = iterable.iterator()) != null) {
            for (int ii = 0; ii <= indexPosition && iterator.hasNext(); ++ii) {
                E nextElement = iterator.next();
                if (ii != indexPosition) continue;
                retval = nextElement;
            }
        }
        return retval;
    }

    public static <E> Iterable<E> empty() {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return IteratorUtils.empty();
            }
        };
    }

    public static boolean equals(Iterable<?> iterable1, Iterable<?> iterable2) {
        boolean retval = false;
        if (!(retval |= iterable1 == iterable2) && iterable1 != null && iterable2 != null) {
            Iterator<?> iterator1 = iterable1.iterator();
            Iterator<?> iterator2 = iterable2.iterator();
            if (iterator1 != null && iterator2 != null) {
                retval = true;
                while (iterator1.hasNext() && iterator2.hasNext() && (retval &= ObjectUtils.equals(iterator1.next(), iterator2.next()))) {
                }
                retval &= !iterator1.hasNext() && !iterator2.hasNext();
            }
        }
        return retval;
    }

    public static <E> Iterable<E> filtered(final Iterable<E> iterable, final BitSet filter) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                if (iterable != null) {
                    return IteratorUtils.filtered(iterable.iterator(), filter);
                }
                return IteratorUtils.empty();
            }
        };
    }

    public static <E> E firstElement(Iterable<E> iterable) {
        boolean indexPosition = false;
        return IterableUtils.elementAt(iterable, 0);
    }

    public static int hashCode(Iterable<?> iterable) {
        int prime = 31;
        int result = 1;
        if (iterable != null) {
            for (Object object : iterable) {
                result = 31 * result + (object == null ? 0 : object.hashCode());
            }
        }
        return result;
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        boolean retval = true;
        if (iterable != null) {
            Iterator<?> iterator = iterable.iterator();
            retval = iterator == null || !iterator.hasNext();
        }
        return retval;
    }

    public static <E> E lastElement(Iterable<E> iterable) {
        Iterator<E> iterator;
        E retval = null;
        if (iterable != null && (iterator = iterable.iterator()) != null) {
            while (iterator.hasNext()) {
                retval = iterator.next();
            }
        }
        return retval;
    }

    public static int size(Iterable<?> iterable) {
        int retval = 0;
        if (iterable != null) {
            Iterator<?> iterator = iterable.iterator();
            retval = IteratorUtils.size(iterator);
        }
        return retval;
    }

    public static <E> Iterable<E> valueOf(ElementStream<E> elementStream) {
        Iterator<E> iterator = IteratorUtils.adapter(elementStream);
        return IterableUtils.valueOf(iterator);
    }

    public static <E> Iterable<E> valueOf(final Factory<Iterator<E>> iteratorFactory) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return iteratorFactory != null ? (Iterator)iteratorFactory.newInstance() : null;
            }
        };
    }

    public static <E> Iterable<E> valueOf(final Iterator<E> iterator) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return iterator;
            }
        };
    }

    public static boolean isIterableType(Class<?> type) {
        boolean retval = false;
        if (type != null) {
            retval = Iterable.class.isAssignableFrom(type);
        }
        return retval;
    }

    public static <E> Iterable<E> valueOf(E ... elements) {
        return IterableUtils.valueOf(IteratorUtils.valueOf(elements));
    }

    public static <E> Map<E, Integer> toCountedElementsMap(Iterable<E> iterable) {
        HashMap<E, Integer> retmap = new HashMap<E, Integer>();
        ArrayList<E> list = new ArrayList<E>();
        if (iterable != null) {
            for (E element : iterable) {
                Integer count = (Integer)retmap.get(element);
                if (count == null) {
                    count = 0;
                    retmap.put(element, count);
                }
                count = count + 1;
                retmap.put(element, count);
                list.add(element);
            }
        }
        class ComparatorUsingMap
        implements Comparator<E> {
            private final Map<E, Integer> map;
            private final List<E> list;

            @Override
            public int compare(E o1, E o2) {
                Integer value2;
                Integer value1 = this.map.get(o1);
                int compareTo = -1 * value1.compareTo(value2 = this.map.get(o2));
                int retval = compareTo;
                if (retval == 0) {
                    retval = Integer.valueOf(this.list.indexOf(o1)).compareTo(this.list.indexOf(o2));
                }
                return retval;
            }

            public ComparatorUsingMap(Map<E, Integer> map, List<E> list) {
                this.map = map;
                this.list = list;
            }
        }
        ComparatorUsingMap comparator = new ComparatorUsingMap(retmap, list);
        TreeMap<E, Integer> retmapSorted = new TreeMap<E, Integer>(comparator);
        retmapSorted.putAll(retmap);
        return new LinkedHashMap(retmapSorted);
    }

    public static <E> boolean contains(Iterable<E> iterable, E value) {
        boolean retval = false;
        if (iterable != null) {
            for (E element : iterable) {
                if (!ObjectUtils.equals(element, value)) continue;
                retval = true;
                break;
            }
        }
        return retval;
    }

    public static <E> IterableReplicator<E> replicate(final Iterable<E> iterable) {
        return new IterableReplicator<E>(){
            private static final long serialVersionUID = -3082211438096618075L;

            @Override
            public IterableReplicator<E> to(Collection<E> collection) {
                Iterator iterator;
                if (collection != null && iterable != null && (iterator = iterable.iterator()) != null) {
                    while (iterator.hasNext()) {
                        collection.add(iterator.next());
                    }
                }
                return this;
            }
        };
    }

    public static <E> Iterable<E> valueOf(final Iterator<E> iterator, boolean replicate) {
        return replicate ? new Iterable<E>(){
            private List<E> list;
            {
                this.list = ImmutableList.copyOf((Iterator)iterator);
            }

            @Override
            public Iterator<E> iterator() {
                return this.list.iterator();
            }
        } : IterableUtils.valueOf(iterator);
    }

    public static <E> IterableReplicator<E> replicate(Iterator<E> iterator) {
        return IterableUtils.replicate(IterableUtils.valueOf(iterator, true));
    }

    public static <E> Iterable<E> chained(Iterable<E> ... iterables) {
        return new ChainedIterable<E>(iterables);
    }

    public static <E> Iterable<E> roundRobin(final Iterable<E> ... iterables) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return IteratorUtils.roundRobin(IteratorUtils.valueOfMultiple(iterables));
            }
        };
    }

    public static interface IterableReplicator<E>
    extends Serializable {
        public IterableReplicator<E> to(Collection<E> var1);
    }
}

