/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.iterator;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.omnaest.utils.structure.collection.list.ListUtils;

public class IteratorDecoratorSwitchable<E>
implements Iterator<E> {
    protected final List<Iterator<E>> iteratorList;
    protected int currentActiveIteratorIndexPosition = 0;

    public IteratorDecoratorSwitchable(Iterable<Iterator<E>> iteratorList) {
        this.iteratorList = ListUtils.valueOf(iteratorList);
    }

    public IteratorDecoratorSwitchable(Iterator<E> ... iterators) {
        this(Arrays.asList(iterators));
    }

    @Override
    public boolean hasNext() {
        Iterator<E> activeIterator = this.getActiveIterator();
        return activeIterator != null && activeIterator.hasNext();
    }

    @Override
    public E next() {
        Iterator<E> activeIterator = this.getActiveIterator();
        if (activeIterator == null) {
            throw new NoSuchElementException();
        }
        return activeIterator.next();
    }

    @Override
    public void remove() {
        Iterator<E> activeIterator = this.getActiveIterator();
        if (activeIterator != null) {
            this.getActiveIterator().remove();
        }
    }

    public Iterator<E> getActiveIterator() {
        return this.currentActiveIteratorIndexPosition >= 0 && this.currentActiveIteratorIndexPosition < this.iteratorList.size() ? this.iteratorList.get(this.currentActiveIteratorIndexPosition) : null;
    }

    public IteratorDecoratorSwitchable<E> switchTo(int iteratorIndexPosition) {
        this.currentActiveIteratorIndexPosition = iteratorIndexPosition;
        return this;
    }

    public IteratorDecoratorSwitchable<E> switchTo(Iterator<E> iterator) {
        int iteratorIndexPosition = this.iteratorList.indexOf(iterator);
        return this.switchTo(iteratorIndexPosition);
    }

    public IteratorDecoratorSwitchable<E> switchToNext() {
        if (this.currentActiveIteratorIndexPosition < this.iteratorList.size()) {
            ++this.currentActiveIteratorIndexPosition;
        }
        return this;
    }

    public IteratorDecoratorSwitchable<E> switchToPrevious() {
        if (this.currentActiveIteratorIndexPosition >= 0) {
            --this.currentActiveIteratorIndexPosition;
        }
        return this;
    }

    public IteratorDecoratorSwitchable<E> switchToNextIteratorWhichHasNext() {
        while (this.hasActiveIterator() && !this.getActiveIterator().hasNext()) {
            this.switchToNext();
        }
        return this;
    }

    public boolean hasActiveIterator() {
        return this.getActiveIterator() != null;
    }

    public List<Iterator<E>> getIteratorList() {
        return this.iteratorList;
    }
}

