/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.iterator;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.collection.set.SetUtils;
import org.omnaest.utils.structure.element.ElementStream;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.element.converter.ElementConverterChain;
import org.omnaest.utils.structure.element.factory.Factory;
import org.omnaest.utils.structure.iterator.ChainedIterator;
import org.omnaest.utils.structure.iterator.ElementStreamToIteratorAdapter;
import org.omnaest.utils.structure.iterator.ThreadLocalCachedIterator;
import org.omnaest.utils.structure.iterator.decorator.IteratorDecorator;
import org.omnaest.utils.structure.iterator.decorator.IteratorToIteratorAdapter;
import org.omnaest.utils.structure.iterator.decorator.LockingIteratorDecorator;

public class IteratorUtils {
    public static int size(Iterator<?> iterator) {
        int retval = 0;
        if (iterator != null) {
            while (iterator.hasNext()) {
                ++retval;
                iterator.next();
            }
        }
        return retval;
    }

    public static <E> Iterator<E> lockedIterator(Iterator<E> iterator, Lock lock) {
        return new LockingIteratorDecorator<E>(iterator, lock);
    }

    public static <E> Iterator<E> threadLocalCachedIterator(Iterator<E> iterator) {
        Assert.isNotNull(iterator, "Iterator must not be null");
        return new ThreadLocalCachedIterator<E>(iterator);
    }

    public static <E> Iterator<E> lockedByReentrantLockIterator(Iterator<E> iterator) {
        ReentrantLock lock = new ReentrantLock();
        return IteratorUtils.lockedIterator(iterator, lock);
    }

    public static <E> Iterator<E> factoryBasedIterator(final Factory<Iterator<E>> iteratorFactory) {
        Assert.isNotNull(iteratorFactory);
        return new Iterator<E>(){
            private Iterator<E> iterator = null;

            private Iterator<E> getOrSwitchIterator() {
                if (this.iterator == null) {
                    this.iterator = (Iterator)iteratorFactory.newInstance();
                }
                while (this.iterator != null && !this.iterator.hasNext()) {
                    this.iterator = (Iterator)iteratorFactory.newInstance();
                }
                return this.iterator;
            }

            @Override
            public boolean hasNext() {
                Iterator iterator = this.getOrSwitchIterator();
                return iterator != null;
            }

            @Override
            public E next() {
                Iterator iterator = this.getOrSwitchIterator();
                return iterator != null ? (Object)iterator.next() : null;
            }

            @Override
            public void remove() {
                Iterator iterator = this.getOrSwitchIterator();
                if (iterator != null) {
                    iterator.remove();
                }
            }
        };
    }

    public static <E> Iterator<E> merge(Iterator<E> ... iterators) {
        ArrayList<E> retlist = new ArrayList<E>();
        for (Iterator<E> iterator : iterators) {
            retlist.addAll(ListUtils.valueOf(iterator));
        }
        return retlist.iterator();
    }

    public static <E> Iterator<E> addToNewIterator(Iterator<E> iterator, E ... elements) {
        return IteratorUtils.merge(iterator, Arrays.asList(elements).iterator());
    }

    public static <E> Iterator<E> chained(Iterator<E> ... iterators) {
        return new ChainedIterator<E>(iterators);
    }

    public static <E> Iterator<E> chained(Collection<? extends Iterator<E>> iterators) {
        return IteratorUtils.chained(iterators.toArray(new Iterator[0]));
    }

    public static <E> Iterator<E> roundRobin(Iterator<E> ... iterators) {
        final Set<Iterator<E>> unemptyIteratorSet = SetUtils.valueOf(iterators);
        ArrayList<Iterator<E>> removableIteratorList = new ArrayList<Iterator<E>>();
        for (Iterator<E> iterator : unemptyIteratorSet) {
            if (iterator.hasNext()) continue;
            removableIteratorList.add(iterator);
        }
        unemptyIteratorSet.removeAll(removableIteratorList);
        return new AbstractIterator<E>(){
            private Queue<Iterator<E>> remainingIteratorQueue = new ArrayDeque();

            protected E computeNext() {
                if (this.remainingIteratorQueue.isEmpty()) {
                    this.remainingIteratorQueue.addAll(unemptyIteratorSet);
                }
                if (this.remainingIteratorQueue.isEmpty()) {
                    return this.endOfData();
                }
                Object retval = null;
                Iterator iterator = this.remainingIteratorQueue.poll();
                retval = iterator.next();
                if (!iterator.hasNext()) {
                    unemptyIteratorSet.remove(iterator);
                }
                return retval;
            }
        };
    }

    public static <E> Iterator<E>[] valueOfMultiple(Iterable<E> ... iterables) {
        ArrayList<Iterator<E>> retlist = new ArrayList<Iterator<E>>();
        if (iterables != null) {
            for (Iterable<E> iterable : iterables) {
                Iterator<E> iterator;
                if (iterable == null || (iterator = iterable.iterator()) == null) continue;
                retlist.add(iterator);
            }
        }
        return retlist.toArray(new Iterator[0]);
    }

    public static <TO, FROM> Iterator<TO> adapter(Iterator<? extends FROM> iterator, ElementConverter<FROM, TO> elementConverter) {
        boolean referencesAreNotNull = iterator != null && elementConverter != null;
        return referencesAreNotNull ? new IteratorToIteratorAdapter<FROM, TO>(iterator, elementConverter) : null;
    }

    public static <TO, FROM, T> Iterator<TO> adapter(Iterator<FROM> iterator, ElementConverter<FROM, ? extends T> elementConverterFirst, ElementConverter<T, ? extends TO> elementConverterSecond) {
        boolean referencesAreNotNull = iterator != null && elementConverterFirst != null && elementConverterSecond != null;
        return referencesAreNotNull ? new IteratorToIteratorAdapter<FROM, TO>(iterator, new ElementConverterChain<FROM, TO>(elementConverterFirst, elementConverterSecond)) : null;
    }

    public static <TO, FROM, T1, T2> Iterator<TO> adapter(Iterator<FROM> iterator, ElementConverter<FROM, ? extends T1> elementConverterFirst, ElementConverter<T1, ? extends T2> elementConverterSecond, ElementConverter<T2, ? extends TO> elementConverterThird) {
        boolean referencesAreNotNull = iterator != null && elementConverterFirst != null && elementConverterSecond != null && elementConverterThird != null;
        return referencesAreNotNull ? new IteratorToIteratorAdapter<FROM, TO>(iterator, new ElementConverterChain<FROM, TO>(elementConverterFirst, elementConverterSecond, elementConverterThird)) : null;
    }

    public static <E> Iterator<E> adapter(ElementStream<E> elementStream) {
        return new ElementStreamToIteratorAdapter<E>(elementStream);
    }

    public static <E> Iterator<E>[] valueOf(Iterable<E> ... iterables) {
        ArrayList<Iterator<E>> retlist = new ArrayList<Iterator<E>>();
        for (Iterable<E> iterable : iterables) {
            Iterator<E> iterator = iterable.iterator();
            if (iterator == null) continue;
            retlist.add(iterator);
        }
        return retlist.toArray(new Iterator[retlist.size()]);
    }

    public static <E> ListIterator<E>[] valueOf(List<E> ... lists) {
        ArrayList<ListIterator<E>> retlist = new ArrayList<ListIterator<E>>();
        for (List<E> list : lists) {
            ListIterator<E> listIterator = list.listIterator();
            if (listIterator == null) continue;
            retlist.add(listIterator);
        }
        return retlist.toArray(new ListIterator[retlist.size()]);
    }

    public static <E> Iterator<E> valueOf(E ... elements) {
        return Arrays.asList(elements).iterator();
    }

    public static <E> void drainTo(Iterator<E> iterator, Collection<E> collection) {
        if (iterator != null && collection != null) {
            while (iterator.hasNext()) {
                E nextElement = iterator.next();
                collection.add(nextElement);
                iterator.remove();
            }
        }
    }

    public static <E> void drainTo(Iterator<E> iterator, Collection<E> collection, int maxNumberOfElements) {
        if (iterator != null && collection != null) {
            for (int ii = 0; ii < maxNumberOfElements && iterator.hasNext(); ++ii) {
                E nextElement = iterator.next();
                collection.add(nextElement);
                iterator.remove();
            }
        }
    }

    public static <E> Iterator<E> limitingIteratorDecorator(Iterator<E> iterator, final int limit) {
        return new IteratorDecorator<E>(iterator){
            private int counter;
            {
                super(x0);
                this.counter = 0;
            }

            @Override
            public boolean hasNext() {
                return this.isWithinLimit() && super.hasNext();
            }

            private boolean isWithinLimit() {
                return this.counter < limit;
            }

            @Override
            public E next() {
                if (!this.isWithinLimit()) {
                    throw new NoSuchElementException();
                }
                ++this.counter;
                return super.next();
            }
        };
    }

    public static <E> Iterator<E> filtered(final Iterator<E> iterator, final BitSet filter) {
        if (iterator == null) {
            return IteratorUtils.empty();
        }
        return new Iterator<E>(){
            private int index = 0;
            private boolean hasNoMoreFilteredElements = false;

            @Override
            public boolean hasNext() {
                this.forwardToNextFilterBit(iterator, filter);
                return !this.hasNoMoreFilteredElements && iterator.hasNext();
            }

            private void forwardToNextFilterBit(Iterator<E> iterator2, BitSet filter2) {
                if (!this.hasNoMoreFilteredElements) {
                    int nextSetBit = -1;
                    while (this.index >= 0 && this.index < (nextSetBit = filter2.nextSetBit(this.index)) && iterator2.hasNext()) {
                        this.fetchElement();
                    }
                    this.hasNoMoreFilteredElements = nextSetBit < 0;
                }
            }

            @Override
            public E next() {
                if (this.hasNext()) {
                    return this.fetchElement();
                }
                throw new NoSuchElementException();
            }

            private E fetchElement() {
                ++this.index;
                return iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public static <E> Iterator<E> empty() {
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public E next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

