/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.iterator;

import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.omnaest.utils.structure.collection.list.ListUtils;

public class ListIteratorDecoratorSwitchable<E>
implements ListIterator<E> {
    protected final List<ListIterator<E>> listIteratorList;
    protected int currentActiveListIteratorIndexPosition = 0;

    public ListIteratorDecoratorSwitchable(Iterable<ListIterator<E>> iteratorList) {
        this.listIteratorList = ListUtils.valueOf(iteratorList);
    }

    public ListIteratorDecoratorSwitchable(ListIterator<E> ... iterators) {
        this(Arrays.asList(iterators));
    }

    @Override
    public boolean hasNext() {
        ListIterator<E> activeIterator = this.getActiveListIterator();
        return activeIterator != null && activeIterator.hasNext();
    }

    @Override
    public E next() {
        ListIterator<E> activeIterator = this.getActiveListIterator();
        return activeIterator != null ? (E)activeIterator.next() : null;
    }

    @Override
    public boolean hasPrevious() {
        ListIterator<E> activeIterator = this.getActiveListIterator();
        return activeIterator != null && activeIterator.hasPrevious();
    }

    @Override
    public E previous() {
        ListIterator<E> activeIterator = this.getActiveListIterator();
        return activeIterator != null ? (E)activeIterator.previous() : null;
    }

    @Override
    public int nextIndex() {
        ListIterator<E> activeIterator = this.getActiveListIterator();
        return activeIterator != null ? activeIterator.nextIndex() : -1;
    }

    @Override
    public int previousIndex() {
        ListIterator<E> activeIterator = this.getActiveListIterator();
        return activeIterator != null ? activeIterator.previousIndex() : -1;
    }

    @Override
    public void remove() {
        ListIterator<E> activeIterator = this.getActiveListIterator();
        if (activeIterator != null) {
            activeIterator.remove();
        }
    }

    @Override
    public void set(E e) {
        ListIterator<E> activeIterator = this.getActiveListIterator();
        if (activeIterator != null) {
            activeIterator.set(e);
        }
    }

    @Override
    public void add(E e) {
        ListIterator<E> activeIterator = this.getActiveListIterator();
        if (activeIterator != null) {
            activeIterator.add(e);
        }
    }

    public ListIterator<E> getActiveListIterator() {
        return this.currentActiveListIteratorIndexPosition >= 0 && this.currentActiveListIteratorIndexPosition < this.listIteratorList.size() ? this.listIteratorList.get(this.currentActiveListIteratorIndexPosition) : null;
    }

    public ListIteratorDecoratorSwitchable<E> switchTo(int listIteratorIndexPosition) {
        this.currentActiveListIteratorIndexPosition = listIteratorIndexPosition;
        return this;
    }

    public ListIteratorDecoratorSwitchable<E> switchTo(ListIterator<E> listIterator) {
        int iteratorIndexPosition = this.listIteratorList.indexOf(listIterator);
        return this.switchTo(iteratorIndexPosition);
    }

    public ListIteratorDecoratorSwitchable<E> switchToNext() {
        if (this.currentActiveListIteratorIndexPosition < this.listIteratorList.size()) {
            ++this.currentActiveListIteratorIndexPosition;
        }
        return this;
    }

    public ListIteratorDecoratorSwitchable<E> switchToPrevious() {
        if (this.currentActiveListIteratorIndexPosition >= 0) {
            --this.currentActiveListIteratorIndexPosition;
        }
        return this;
    }

    public ListIteratorDecoratorSwitchable<E> switchToNextIteratorWhichHasNext() {
        while ((this.hasActiveListIterator() && !this.getActiveListIterator().hasNext() || !this.hasActiveListIterator()) && this.hasNextListIteratorToSwitchTo()) {
            this.switchToNext();
        }
        return this;
    }

    public ListIteratorDecoratorSwitchable<E> switchToPreviousIteratorWhichHasPrevious() {
        while ((this.hasActiveListIterator() && !this.getActiveListIterator().hasPrevious() || !this.hasActiveListIterator()) && this.hasPreviousListIteratorToSwitchTo()) {
            this.switchToPrevious();
        }
        return this;
    }

    public boolean hasPreviousListIteratorToSwitchTo() {
        return this.currentActiveListIteratorIndexPosition > 0;
    }

    public boolean hasNextListIteratorToSwitchTo() {
        return this.currentActiveListIteratorIndexPosition < this.listIteratorList.size() - 1;
    }

    public boolean hasActiveListIterator() {
        return this.getActiveListIterator() != null;
    }

    public List<ListIterator<E>> getListIteratorList() {
        return this.listIteratorList;
    }
}

