/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.iterator;

import java.util.List;
import java.util.ListIterator;

public class ListIteratorIndexBased<E>
implements ListIterator<E> {
    protected int indexPosition = -1;
    protected int indexPositionNext = 0;
    protected int indexPositionPrevious = -1;
    protected boolean isIndexPositionValid = true;
    protected boolean directionForward = true;
    protected ListIteratorIndexBasedSource<E> listIteratorIndexBasedSource = null;

    public ListIteratorIndexBased(ListIteratorIndexBasedSource<E> listIteratorSource) {
        this.listIteratorIndexBasedSource = listIteratorSource;
    }

    public ListIteratorIndexBased(List<E> list) {
        this.listIteratorIndexBasedSource = new ListToListIteratorSourceAdapter<E>(list);
    }

    protected void calculateIndexPositionContext() {
        if (this.directionForward) {
            this.indexPositionNext = this.indexPosition + 1;
            this.indexPositionPrevious = this.indexPosition;
        } else {
            this.indexPositionNext = this.indexPosition;
            this.indexPositionPrevious = this.indexPosition - 1;
        }
        this.isIndexPositionValid = this.isValidIndexPosition(this.indexPosition);
    }

    @Override
    public boolean hasNext() {
        return this.isValidIndexPosition(this.indexPositionNext);
    }

    protected boolean isValidIndexPosition(int indexPosition) {
        return indexPosition >= 0 && indexPosition < this.listIteratorIndexBasedSource.size();
    }

    @Override
    public E next() {
        this.indexPosition = this.indexPositionNext;
        this.directionForward = true;
        this.calculateIndexPositionContext();
        return this.isIndexPositionValid ? (E)this.listIteratorIndexBasedSource.get(this.indexPosition) : null;
    }

    @Override
    public void remove() {
        if (this.isIndexPositionValid) {
            this.listIteratorIndexBasedSource.remove(this.indexPosition);
            this.isIndexPositionValid = false;
            this.indexPositionNext = this.indexPosition;
        }
    }

    @Override
    public boolean hasPrevious() {
        return this.isValidIndexPosition(this.indexPositionPrevious);
    }

    @Override
    public E previous() {
        this.directionForward = false;
        this.indexPosition = this.indexPositionPrevious;
        this.calculateIndexPositionContext();
        return this.isIndexPositionValid ? (E)this.listIteratorIndexBasedSource.get(this.indexPosition) : null;
    }

    @Override
    public int nextIndex() {
        return this.directionForward ? this.indexPositionNext : this.indexPosition;
    }

    @Override
    public int previousIndex() {
        return !this.directionForward ? this.indexPositionPrevious : this.indexPosition;
    }

    @Override
    public void set(E element) {
        if (element != null && this.isIndexPositionValid) {
            this.listIteratorIndexBasedSource.set(this.indexPosition, element);
        }
    }

    @Override
    public void add(E element) {
        if (element != null && this.isIndexPositionValid) {
            this.listIteratorIndexBasedSource.add(this.indexPosition, element);
            ++this.indexPositionNext;
        }
    }

    public static class ListToListIteratorSourceAdapter<E>
    implements ListIteratorIndexBasedSource<E> {
        protected List<E> list = null;

        public ListToListIteratorSourceAdapter(List<E> list) {
            this.list = list;
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public E get(int indexPosition) {
            return this.list.get(indexPosition);
        }

        @Override
        public void remove(int indexPosition) {
            this.list.remove(indexPosition);
        }

        @Override
        public void set(int indexPosition, E element) {
            this.list.set(indexPosition, element);
        }

        @Override
        public void add(int indexPosition, E element) {
            this.list.add(indexPosition, element);
        }
    }

    public static interface ListIteratorIndexBasedSource<E> {
        public int size();

        public E get(int var1);

        public void remove(int var1);

        public void set(int var1, E var2);

        public void add(int var1, E var2);
    }
}

