/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.iterator;

import java.util.Iterator;
import org.omnaest.utils.operation.foreach.Range;
import org.omnaest.utils.structure.element.ElementHolderUnmodifiable;

public class RangedIterable<T>
implements Iterable<T> {
    protected Range range = null;
    protected Iterable<T> iterable = null;

    public RangedIterable(Range range, Iterable<T> iterable) {
        this.range = range;
        this.iterable = iterable;
    }

    @Override
    public Iterator<T> iterator() {
        long nextIndexPosition;
        final Iterator<T> iterator = this.iterable.iterator();
        for (nextIndexPosition = 0L; nextIndexPosition < this.range.getNumberFrom() && iterator.hasNext(); ++nextIndexPosition) {
            iterator.next();
        }
        final ElementHolderUnmodifiable<Long> elementHolderIndexPosition = new ElementHolderUnmodifiable<Long>(nextIndexPosition);
        return new Iterator<T>(){
            private long nextIndexPosition;
            {
                this.nextIndexPosition = (Long)elementHolderIndexPosition.getElement();
            }

            @Override
            public boolean hasNext() {
                return RangedIterable.this.range.isWithinRange(this.nextIndexPosition) && iterator.hasNext();
            }

            @Override
            public T next() {
                Object retval = null;
                if (this.hasNext()) {
                    retval = iterator.next();
                    ++this.nextIndexPosition;
                }
                return retval;
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }
}

