/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.iterator;

import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.omnaest.utils.structure.element.ElementHolderUnmodifiable;
import org.omnaest.utils.structure.element.accessor.AccessorReadable;
import org.omnaest.utils.structure.iterator.IteratorUtils;

public class ThreadLocalCachedIterator<E>
implements Iterator<E> {
    private final Iterator<E> iterator;
    private final ThreadLocal<AccessorReadable<E>> threadLocal = new ThreadLocal();
    private final Lock lock = new ReentrantLock(true);

    public ThreadLocalCachedIterator(Iterator<E> iterator) {
        this.iterator = IteratorUtils.lockedIterator(iterator, this.lock);
    }

    @Override
    public boolean hasNext() {
        return this.getOrResolveNextElement() != null;
    }

    @Override
    public E next() {
        E retval = this.getOrResolveNextElement();
        this.clearCurrentCache();
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E getOrResolveNextElement() {
        Object retval = null;
        AccessorReadable<E> accessorReadable = this.threadLocal.get();
        if (accessorReadable != null) {
            retval = accessorReadable.getElement();
        } else {
            this.lock.lock();
            try {
                if (this.iterator.hasNext()) {
                    retval = this.iterator.next();
                    this.threadLocal.set(new ElementHolderUnmodifiable<Object>(retval));
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return retval;
    }

    private void clearCurrentCache() {
        this.threadLocal.remove();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("ThreadLocalIterator does not support the remove() method, since it cannot guarantee the cursor position in a concurrent environment");
    }
}

