/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.iterator;

import java.util.Iterator;
import java.util.concurrent.locks.ReentrantLock;

public class ThreadSafeIterator<E>
implements Iterator<E> {
    private final Iterator<E> iterator;
    private final ReentrantLock reentrantLock = new ReentrantLock();

    public ThreadSafeIterator(Iterator<E> iterator) {
        this.iterator = iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        boolean retval = false;
        this.reentrantLock.lock();
        try {
            retval = this.iterator != null && this.iterator.hasNext();
        }
        finally {
            this.reentrantLock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E next() {
        E retval = null;
        this.reentrantLock.lock();
        try {
            retval = this.iterator == null ? null : (E)this.iterator.next();
        }
        finally {
            this.reentrantLock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        this.reentrantLock.lock();
        try {
            if (this.iterator != null) {
                this.iterator.remove();
            }
        }
        finally {
            this.reentrantLock.unlock();
        }
    }
}

