/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.iterator.decorator;

import java.util.Iterator;
import org.omnaest.utils.structure.element.converter.ElementConverter;

public class IteratorToIteratorAdapter<FROM, TO>
implements Iterator<TO> {
    private final ElementConverter<FROM, TO> elementConverter;
    private final Iterator<FROM> iterator;
    private final boolean hasIteratorAndElementConverter;

    public IteratorToIteratorAdapter(Iterator<FROM> iterator, ElementConverter<FROM, TO> elementConverter) {
        this.iterator = iterator;
        this.elementConverter = elementConverter;
        this.hasIteratorAndElementConverter = this.iterator != null && this.elementConverter != null;
    }

    @Override
    public boolean hasNext() {
        return this.hasIteratorAndElementConverter && this.iterator.hasNext();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    @Override
    public TO next() {
        TO retval = null;
        if (this.hasIteratorAndElementConverter) {
            FROM nextElement = this.iterator.next();
            retval = this.elementConverter.convert(nextElement);
        }
        return retval;
    }
}

