/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.iterator.decorator;

import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.omnaest.utils.structure.iterator.decorator.IteratorDecorator;

public class LockingIteratorDecorator<E>
extends IteratorDecorator<E> {
    protected final Lock lock;

    public LockingIteratorDecorator(Iterator<E> iterator, Lock lock) {
        super(iterator);
        this.lock = lock;
    }

    public LockingIteratorDecorator(Iterator<E> iterator) {
        super(iterator);
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        boolean retval = false;
        this.lock.lock();
        try {
            retval = super.hasNext();
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E next() {
        E retval = null;
        this.lock.lock();
        try {
            retval = super.next();
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        this.lock.lock();
        try {
            super.remove();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        String retval = null;
        this.lock.lock();
        try {
            retval = super.toString();
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }
}

