/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.map;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.structure.collection.CollectionUtils;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.collection.set.SetUtils;
import org.omnaest.utils.structure.element.converter.ElementBidirectionalConverterSerializable;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.map.MapUtils;

public class AggregatedMap<K, V>
implements Map<K, V> {
    private final Iterable<Map<K, V>> mapIterable;

    public AggregatedMap(Iterable<? extends Map<K, V>> mapIterable) {
        Assert.isNotNull(mapIterable, "mapIterable must not be null");
        this.mapIterable = mapIterable;
    }

    public AggregatedMap(Map<K, V> ... maps) {
        this(Arrays.asList(maps));
    }

    public AggregatedMap(Map<K, V> map) {
        this(Arrays.asList(map));
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        boolean retval = false;
        for (Map<K, V> map : this.mapIterable) {
            if (map != null && (retval = map.containsKey(key))) break;
        }
        return retval;
    }

    @Override
    public boolean containsValue(Object value) {
        boolean retval = false;
        for (Map<K, V> map : this.mapIterable) {
            if (map != null && (retval = map.containsValue(value))) break;
        }
        return retval;
    }

    @Override
    public V get(Object key) {
        V retval = null;
        for (Map<K, V> map : this.mapIterable) {
            if (map != null && map.containsKey(key) && (retval = (V)map.get(key)) != null) break;
        }
        return retval;
    }

    @Override
    public V put(K key, V value) {
        Iterator<Map<K, V>> iterator;
        Map<K, V> map2;
        V retval = null;
        boolean successful = false;
        for (Map<K, V> map2 : this.mapIterable) {
            if (map2 == null || !map2.containsKey(key)) continue;
            retval = map2.put(key, value);
            successful = true;
        }
        if (!successful && (iterator = this.mapIterable.iterator()).hasNext() && (map2 = iterator.next()) != null) {
            retval = map2.put(key, value);
        }
        return retval;
    }

    @Override
    public V remove(Object key) {
        V retval = null;
        for (Map<K, V> map : this.mapIterable) {
            if (map == null || !map.containsKey(key)) continue;
            V removedValue = map.remove(key);
            if (retval != null) continue;
            retval = removedValue;
        }
        return retval;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (m != null) {
            for (K key : m.keySet()) {
                V value = m.get(key);
                this.put(key, value);
            }
        }
    }

    @Override
    public void clear() {
        for (Map<K, V> map : this.mapIterable) {
            if (map == null) continue;
            map.clear();
        }
    }

    @Override
    public Set<K> keySet() {
        return SetUtils.composite(ListUtils.convert(this.mapIterable, new ElementConverter<Map<K, V>, Set<K>>(){

            @Override
            public Set<K> convert(Map<K, V> map) {
                return map != null ? map.keySet() : null;
            }
        }));
    }

    @Override
    public Collection<V> values() {
        ElementBidirectionalConverterSerializable elementBidirectionalConverter = new ElementBidirectionalConverterSerializable<Map.Entry<K, V>, V>(){
            private static final long serialVersionUID = -7294690631488549801L;

            @Override
            public Map.Entry<K, V> convertBackwards(V element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public V convert(Map.Entry<K, V> element) {
                return element.getValue();
            }
        };
        return CollectionUtils.adapter(this.entrySet(), elementBidirectionalConverter);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        ElementBidirectionalConverterSerializable elementBidirectionalConverter = new ElementBidirectionalConverterSerializable<K, Map.Entry<K, V>>(){
            private static final long serialVersionUID = 3353283940310108373L;

            @Override
            public K convertBackwards(Map.Entry<K, V> element) {
                return element != null ? (Object)element.getKey() : null;
            }

            @Override
            public Map.Entry<K, V> convert(final K key) {
                return key != null ? new Map.Entry<K, V>(){

                    @Override
                    public K getKey() {
                        return key;
                    }

                    @Override
                    public V getValue() {
                        return AggregatedMap.this.get(key);
                    }

                    @Override
                    public V setValue(V value) {
                        return AggregatedMap.this.put(key, value);
                    }
                } : null;
            }
        };
        return SetUtils.adapter(this.keySet(), elementBidirectionalConverter);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AggregatedMap " + MapUtils.toString(this));
        return builder.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mapIterable == null ? 0 : ((Object)ListUtils.valueOf(this.mapIterable)).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        return MapUtils.delta(this, other).areEqual();
    }
}

