/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.map;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.omnaest.utils.structure.collection.list.IdentityArrayList;
import org.omnaest.utils.structure.collection.set.IdentityArrayListBasedSet;
import org.omnaest.utils.structure.map.MapAbstract;

public class IdentityLinkedHashMap<K, V>
extends MapAbstract<K, V> {
    protected Map<K, V> map = new IdentityHashMap();
    protected List<K> keyList = new IdentityArrayList<K>();
    protected List<V> valueList = new IdentityArrayList<V>();

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        V retval = this.map.put(key, value);
        if (retval == null) {
            this.keyList.add(key);
            this.valueList.add(value);
        } else {
            int indexOf = this.keyList.indexOf(key);
            this.keyList.set(indexOf, key);
            this.valueList.set(indexOf, value);
        }
        return retval;
    }

    @Override
    public V remove(Object key) {
        V retval = this.map.remove(key);
        int indexOf = this.keyList.indexOf(key);
        if (indexOf >= 0) {
            this.keyList.remove(indexOf);
            this.valueList.remove(indexOf);
        }
        return retval;
    }

    @Override
    public Set<K> keySet() {
        return new IdentityArrayListBasedSet<K>(this.keyList);
    }

    @Override
    public Collection<V> values() {
        return new IdentityArrayList<V>(this.valueList);
    }
}

