/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.map;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.omnaest.utils.structure.collection.set.SetUtils;
import org.omnaest.utils.structure.element.converter.ElementBidirectionalConverter;
import org.omnaest.utils.structure.map.MapUtils;

public abstract class MapAbstract<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = -8854027357614884818L;

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (map != null) {
            for (K key : map.keySet()) {
                this.put(key, map.get(key));
            }
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        ElementBidirectionalConverter elementBidirectionalConverter = new ElementBidirectionalConverter<K, Map.Entry<K, V>>(){

            @Override
            public Map.Entry<K, V> convert(final K key) {
                return new Map.Entry<K, V>(){

                    @Override
                    public K getKey() {
                        return key;
                    }

                    @Override
                    public V getValue() {
                        return MapAbstract.this.get(key);
                    }

                    @Override
                    public V setValue(V value) {
                        return MapAbstract.this.put(key, value);
                    }

                    public String toString() {
                        try {
                            return "[" + String.valueOf(this.getKey()) + ":" + String.valueOf(this.getValue() + "]");
                        }
                        catch (Exception e) {
                            return "";
                        }
                    }
                };
            }

            @Override
            public K convertBackwards(Map.Entry<K, V> entry) {
                return entry.getKey();
            }
        };
        return SetUtils.adapter(this.keySet(), elementBidirectionalConverter);
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public void clear() {
        for (Object key : this.keySet()) {
            this.remove(key);
        }
    }

    public String toString() {
        return MapUtils.toString(this);
    }
}

