/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.map;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.reflection.ReflectionUtils;

public class MapBuilder {
    private MapRootComposer mapRootComposer = new MapRootComposerImpl();

    public <K, V> MapComposer<K, V> put(K key, V value) {
        return this.mapRootComposer.put(key, value);
    }

    public <K, V> MapComposer<K, V> putAll(Map<? extends K, ? extends V> map) {
        return this.mapRootComposer.putAll(map);
    }

    private static class CloseMapComposerImpl<K, V>
    implements ClosedMapComposer<K, V> {
        private final Map<K, V> map;

        private CloseMapComposerImpl(Map<K, V> map) {
            this.map = map;
        }

        @Override
        public SortedMap<K, V> treeMap() {
            return new TreeMap<K, V>(this.map);
        }

        @Override
        public SortedMap<K, V> treeMap(Comparator<? super K> comparator) {
            TreeMap<K, V> retmap = new TreeMap<K, V>(comparator);
            retmap.putAll(this.map);
            return retmap;
        }

        @Override
        public SortedMap<K, V> concurrentSkipListMap() {
            return new ConcurrentSkipListMap<K, V>(this.map);
        }

        @Override
        public SortedMap<K, V> concurrentSkipListMap(Comparator<? super K> comparator) {
            ConcurrentSkipListMap<K, V> retmap = new ConcurrentSkipListMap<K, V>(comparator);
            retmap.putAll(this.map);
            return retmap;
        }

        @Override
        public Map<K, V> hashMap() {
            return new HashMap<K, V>(this.map);
        }

        @Override
        public Map<K, V> linkedHashMap() {
            return new LinkedHashMap<K, V>(this.map);
        }

        @Override
        public Map<K, V> concurrentHashMap() {
            return new ConcurrentHashMap<K, V>(this.map);
        }

        @Override
        public Map<K, V> concurrentHashMap(int initialCapacity) {
            ConcurrentHashMap<K, V> retmap = new ConcurrentHashMap<K, V>(initialCapacity);
            retmap.putAll(this.map);
            return retmap;
        }

        @Override
        public <M extends Map<K, V>> M map(MapFactory<M, K, V> mapFactory) {
            Assert.isNotNull(mapFactory, "MapFactory must not be null");
            M retmap = mapFactory.newInstance();
            if (retmap != null) {
                retmap.putAll(this.map);
            }
            return retmap;
        }

        @Override
        public <M extends Map<K, V>> M map(final Class<M> mapType, final Object ... arguments) {
            Assert.isNotNull(mapType, "mapType must not be null");
            Assert.isTrue(ReflectionUtils.hasConstructorFor(mapType, arguments), "No constructor available for the given arguments.[" + String.valueOf(mapType) + "(" + Arrays.toString(arguments) + ")]");
            MapFactory mapFactory = new MapFactory<M, K, V>(){

                @Override
                public M newInstance() {
                    Map retmap = null;
                    try {
                        retmap = (Map)ReflectionUtils.newInstanceOf(mapType, arguments);
                    }
                    catch (Exception e) {
                        Assert.fails("The map factory failed to create an instance of a map", e);
                    }
                    return retmap;
                }
            };
            return this.map(mapFactory);
        }
    }

    private static class MapComposerImpl<K, V>
    implements MapComposer<K, V> {
        private final Map<K, V> map;

        private MapComposerImpl(K key, V value) {
            this.map = new LinkedHashMap();
            this.map.put(key, value);
        }

        private MapComposerImpl(Map<K, V> map) {
            this.map = map;
        }

        @Override
        public MapComposer<K, V> put(K key, V value) {
            this.map.put(key, value);
            return this;
        }

        @Override
        public MapComposer<K, V> putAll(Map<? extends K, ? extends V> map) {
            if (map != null) {
                this.map.putAll(map);
            }
            return this;
        }

        @Override
        public ClosedMapComposer<K, V> buildAs() {
            return new CloseMapComposerImpl(this.map);
        }
    }

    private static class MapRootComposerImpl
    implements MapRootComposer {
        private MapRootComposerImpl() {
        }

        @Override
        public <K, V> MapComposer<K, V> put(K key, V value) {
            return new MapComposerImpl(key, value);
        }

        @Override
        public <K, V> MapComposer<K, V> putAll(Map<? extends K, ? extends V> map) {
            LinkedHashMap<? extends K, ? extends V> initialMap = map != null ? new LinkedHashMap<K, V>(map) : new LinkedHashMap();
            return new MapComposerImpl(initialMap);
        }
    }

    public static interface ClosedMapComposer<K, V> {
        public SortedMap<K, V> treeMap();

        public SortedMap<K, V> treeMap(Comparator<? super K> var1);

        public SortedMap<K, V> concurrentSkipListMap();

        public SortedMap<K, V> concurrentSkipListMap(Comparator<? super K> var1);

        public Map<K, V> hashMap();

        public Map<K, V> linkedHashMap();

        public Map<K, V> concurrentHashMap();

        public Map<K, V> concurrentHashMap(int var1);

        public <M extends Map<K, V>> M map(MapFactory<M, K, V> var1);

        public <M extends Map<K, V>> M map(Class<M> var1, Object ... var2);
    }

    public static interface MapComposer<K, V> {
        public MapComposer<K, V> put(K var1, V var2);

        public MapComposer<K, V> putAll(Map<? extends K, ? extends V> var1);

        public ClosedMapComposer<K, V> buildAs();
    }

    public static interface MapRootComposer {
        public <K, V> MapComposer<K, V> put(K var1, V var2);

        public <K, V> MapComposer<K, V> putAll(Map<? extends K, ? extends V> var1);
    }

    public static interface MapFactory<M extends Map<K, V>, K, V> {
        public M newInstance();
    }
}

