/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.map;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.omnaest.utils.structure.collection.CollectionUtils;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.collection.set.SetUtils;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.map.MapAbstract;

public class MapComposite<K, V>
extends MapAbstract<K, V> {
    private static final long serialVersionUID = -6795020842815751304L;
    private final List<Map<K, V>> mapList;

    public MapComposite(List<Map<K, V>> mapList) {
        this.mapList = new CopyOnWriteArrayList<Map<K, V>>(mapList);
    }

    public MapComposite(Map<K, V> ... maps) {
        this(Arrays.asList(maps));
    }

    @Override
    public V get(Object key) {
        Map<K, V> map;
        V retval = null;
        Iterator<Map<K, V>> i$ = this.mapList.iterator();
        while (i$.hasNext() && (retval = (V)(map = i$.next()).get(key)) == null) {
        }
        return retval;
    }

    @Override
    public V put(K key, V value) {
        V retval = this.remove(key);
        Map<K, V> currentMap = null;
        int currentMapSize = Integer.MAX_VALUE;
        for (Map<K, V> map : this.mapList) {
            int size = map.size();
            if (size >= currentMapSize) continue;
            currentMap = map;
            currentMapSize = size;
        }
        if (currentMap != null) {
            currentMap.put(key, value);
        }
        return retval;
    }

    @Override
    public V remove(Object key) {
        V retval = null;
        for (Map<K, V> map : this.mapList) {
            V removedValue = map.remove(key);
            if (removedValue == null) continue;
            retval = removedValue;
        }
        return retval;
    }

    @Override
    public Set<K> keySet() {
        ElementConverter elementConverter = new ElementConverter<Map<K, V>, Set<K>>(){

            @Override
            public Set<K> convert(Map<K, V> element) {
                return element == null ? null : element.keySet();
            }
        };
        List keySetList = ListUtils.convert(this.mapList, elementConverter);
        return SetUtils.composite(keySetList);
    }

    @Override
    public Collection<V> values() {
        ElementConverter elementConverter = new ElementConverter<Map<K, V>, Collection<V>>(){

            @Override
            public Collection<V> convert(Map<K, V> element) {
                return element == null ? null : element.values();
            }
        };
        List keySetList = ListUtils.convert(this.mapList, elementConverter);
        return CollectionUtils.composite(keySetList);
    }
}

