/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.map;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.omnaest.utils.structure.collection.set.SetDelta;
import org.omnaest.utils.structure.collection.set.SetUtils;
import org.omnaest.utils.structure.element.ObjectUtils;
import org.omnaest.utils.structure.element.factory.concrete.HashMapFactory;
import org.omnaest.utils.tuple.Tuple2;

public class MapDelta<K, V> {
    private final SetDelta<K> setDelta;
    private final Map<K, Values<V>> retainedKeyToUnequalValuesMap = new LinkedHashMap<K, Values<V>>();
    private final Map<K, V> retainedKeyToEqualValueMap = new LinkedHashMap();

    public MapDelta(Map<K, V> firstMap, Map<K, V> secondMap) {
        firstMap = ObjectUtils.defaultIfNull(firstMap, new HashMapFactory());
        secondMap = ObjectUtils.defaultIfNull(secondMap, new HashMapFactory());
        this.setDelta = SetUtils.delta(firstMap.keySet(), secondMap.keySet());
        Set<K> retainedElementSet = this.setDelta.getRetainedElementSet();
        if (retainedElementSet != null) {
            for (K key : retainedElementSet) {
                V valueSecond;
                V valueFirst = firstMap.get(key);
                if (org.apache.commons.lang3.ObjectUtils.equals(valueFirst, valueSecond = secondMap.get(key))) {
                    this.retainedKeyToEqualValueMap.put(key, valueFirst);
                    continue;
                }
                this.retainedKeyToUnequalValuesMap.put(key, new Values<V>(valueFirst, valueSecond));
            }
        }
    }

    public Map<K, Values<V>> getRetainedKeyToUnequalValuesMap() {
        return Collections.unmodifiableMap(this.retainedKeyToUnequalValuesMap);
    }

    public Map<K, V> getRetainedKeyToEqualValueMap() {
        return Collections.unmodifiableMap(this.retainedKeyToEqualValueMap);
    }

    public SetDelta<K> getKeySetDelta() {
        return this.setDelta;
    }

    public boolean areEqual() {
        return this.setDelta.getAddedElementSet().isEmpty() && this.setDelta.getRemovedElementSet().isEmpty() && this.retainedKeyToUnequalValuesMap.isEmpty();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MapDelta [setDelta=");
        builder.append(this.setDelta);
        builder.append(", retainedKeyToUnequalValuesMap=");
        builder.append(this.retainedKeyToUnequalValuesMap);
        builder.append(", retainedKeyToEqualValueMap=");
        builder.append(this.retainedKeyToEqualValueMap);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.retainedKeyToEqualValueMap == null ? 0 : ((Object)this.retainedKeyToEqualValueMap).hashCode());
        result = 31 * result + (this.retainedKeyToUnequalValuesMap == null ? 0 : ((Object)this.retainedKeyToUnequalValuesMap).hashCode());
        result = 31 * result + (this.setDelta == null ? 0 : this.setDelta.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapDelta)) {
            return false;
        }
        MapDelta other = (MapDelta)obj;
        if (this.retainedKeyToEqualValueMap == null ? other.retainedKeyToEqualValueMap != null : !((Object)this.retainedKeyToEqualValueMap).equals(other.retainedKeyToEqualValueMap)) {
            return false;
        }
        if (this.retainedKeyToUnequalValuesMap == null ? other.retainedKeyToUnequalValuesMap != null : !((Object)this.retainedKeyToUnequalValuesMap).equals(other.retainedKeyToUnequalValuesMap)) {
            return false;
        }
        return !(this.setDelta == null ? other.setDelta != null : !this.setDelta.equals(other.setDelta));
    }

    public static class Values<V>
    extends Tuple2<V, V> {
        private static final long serialVersionUID = -468215748811694668L;

        public Values(V valueFirst, V valueSecond) {
            super(valueFirst, valueSecond);
        }
    }
}

