/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.map;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.omnaest.utils.structure.element.KeyExtractor;
import org.omnaest.utils.structure.map.MapUtils;
import org.omnaest.utils.tuple.Tuple2;

public class MapJoiner {
    public <K, VL> From<K, VL> from(Map<K, VL> map) {
        return new MapJoinerImpl<K, VL>(map);
    }

    public <K, VL> From<K, VL> from(KeyExtractor<K, VL> keyExtractor, Iterable<VL> iterable) {
        return new MapJoinerImpl<K, VL>(MapUtils.valueOf(keyExtractor, iterable));
    }

    private static class JoinResultImpl<K, VL, VR>
    extends MapJoinerImpl<K, JoinedValue<VL, VR>>
    implements JoinResult<K, VL, VR> {
        public JoinResultImpl(Map<K, JoinedValue<VL, VR>> map) {
            super(map);
        }

        @Override
        public Map<K, JoinedValue<VL, VR>> getResultMap() {
            return this.map;
        }

        @Override
        public JoinResult<K, VL, VR> where(Predicate<K, VL, VR> predicate) {
            LinkedHashMap retmap = new LinkedHashMap();
            if (predicate != null) {
                for (Map.Entry entry : this.map.entrySet()) {
                    JoinedValue value;
                    Object key;
                    boolean accept;
                    if (entry == null || !(accept = predicate.accept(key = entry.getKey(), value = (JoinedValue)entry.getValue()))) continue;
                    retmap.put(key, value);
                }
            }
            return new JoinResultImpl(retmap);
        }
    }

    private static class MapJoinerImpl<K, VL>
    implements From<K, VL> {
        protected final Map<K, VL> map;

        public MapJoinerImpl(Map<K, VL> map) {
            this.map = map;
        }

        @Override
        public <VR> JoinResult<K, VL, VR> joinInner(Map<K, ? extends VR> map) {
            LinkedHashMap retmap = new LinkedHashMap();
            if (this.map != null && map != null) {
                LinkedHashSet<K> keySet = new LinkedHashSet<K>(this.map.keySet());
                keySet.retainAll(map.keySet());
                for (Object key : keySet) {
                    VL vl = this.map.get(key);
                    VR vr = map.get(key);
                    retmap.put(key, new JoinedValue<VL, VR>(vl, vr));
                }
            }
            return new JoinResultImpl(retmap);
        }

        @Override
        public <VR> JoinResult<K, VL, VR> joinInner(KeyExtractor<? extends K, VR> keyExtractor, Iterable<? extends VR> iterable) {
            return this.joinInner(MapUtils.valueOf(keyExtractor, iterable));
        }
    }

    public static interface JoinResult<K, VL, VR>
    extends From<K, JoinedValue<VL, VR>> {
        public Map<K, JoinedValue<VL, VR>> getResultMap();

        public JoinResult<K, VL, VR> where(Predicate<K, VL, VR> var1);
    }

    public static class PredicateIncludingKeySet<K, VL, VR>
    implements Predicate<K, VL, VR> {
        private final Set<K> keySet;

        public PredicateIncludingKeySet(Set<K> keySet) {
            this.keySet = keySet;
        }

        @Override
        public boolean accept(K key, JoinedValue<VL, VR> valueTuple) {
            return this.keySet != null && this.keySet.contains(key);
        }
    }

    public static interface Predicate<K, VL, VR> {
        public boolean accept(K var1, JoinedValue<VL, VR> var2);
    }

    public static interface From<K, VL> {
        public <VR> JoinResult<K, VL, VR> joinInner(Map<K, ? extends VR> var1);

        public <VR> JoinResult<K, VL, VR> joinInner(KeyExtractor<? extends K, VR> var1, Iterable<? extends VR> var2);
    }

    public static class JoinedValue<V1, V2>
    extends Tuple2<V1, V2> {
        private static final long serialVersionUID = -4203095271240152615L;

        public JoinedValue() {
        }

        public JoinedValue(Tuple2<V1, V2> tuple2) {
            super(tuple2);
        }

        public JoinedValue(V1 valueFirst, V2 valueSecond) {
            super(valueFirst, valueSecond);
        }
    }
}

