/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.map;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.structure.collection.set.SetUtils;
import org.omnaest.utils.structure.container.ByteArrayContainer;
import org.omnaest.utils.structure.element.KeyExtractor;
import org.omnaest.utils.structure.element.converter.ElementBidirectionalConverter;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.element.converter.ElementConverterElementToMapEntry;
import org.omnaest.utils.structure.element.converter.ElementConverterIdentity;
import org.omnaest.utils.structure.element.factory.Factory;
import org.omnaest.utils.structure.element.factory.FactoryParameterized;
import org.omnaest.utils.structure.element.factory.FactoryParameterizedSerializable;
import org.omnaest.utils.structure.element.factory.FactorySerializable;
import org.omnaest.utils.structure.element.factory.concrete.ArrayListFactory;
import org.omnaest.utils.structure.element.factory.concrete.LinkedHashSetFactory;
import org.omnaest.utils.structure.element.filter.ElementFilter;
import org.omnaest.utils.structure.iterator.IterableUtils;
import org.omnaest.utils.structure.map.AggregatedMap;
import org.omnaest.utils.structure.map.MapBuilder;
import org.omnaest.utils.structure.map.MapComposite;
import org.omnaest.utils.structure.map.MapDelta;
import org.omnaest.utils.structure.map.MapJoiner;
import org.omnaest.utils.structure.map.adapter.MapToMapAdapter;
import org.omnaest.utils.structure.map.adapter.SortedMapToSortedMapAdapter;
import org.omnaest.utils.structure.map.decorator.LockingMapDecorator;
import org.omnaest.utils.structure.map.decorator.MapDecorator;
import org.omnaest.utils.structure.map.decorator.SortedMapDecorator;
import org.omnaest.utils.tuple.Tuple2;

public class MapUtils {
    public static <K, V> Map<K, V> mergeAll(MapElementMergeOperation<K, V> mapElementMergeOperation, Map<? extends K, ? extends V> ... maps) {
        return MapUtils.mergeAll(Arrays.asList(maps), mapElementMergeOperation);
    }

    private MapUtils() {
    }

    public static <K, V> Map<K, V> mergeAll(Collection<Map<? extends K, ? extends V>> mapCollection, MapElementMergeOperation<K, V> mapElementMergeOperation) {
        LinkedHashMap retmap = new LinkedHashMap();
        if (mapCollection != null && mapElementMergeOperation != null) {
            for (Map<K, V> map : mapCollection) {
                if (map == null) continue;
                for (K key : map.keySet()) {
                    V value = map.get(key);
                    mapElementMergeOperation.merge(key, value, retmap);
                }
            }
        }
        return retmap;
    }

    public static <K, V> Map<K, V> mergeAll(Collection<Map<K, V>> mapCollection) {
        LinkedHashMap<K, V> retmap = new LinkedHashMap<K, V>();
        for (Map<K, V> map : mapCollection) {
            retmap.putAll(map);
        }
        return retmap;
    }

    public static <K, V> Map<K, V> mergeAll(Map<K, V> ... maps) {
        return MapUtils.mergeAll(Arrays.asList(maps));
    }

    public static <K, V> Map<K, List<V>> mergeAllValuesIntoList(Map<K, V> ... maps) {
        return MapUtils.mergeAllValuesIntoList(Arrays.asList(maps));
    }

    public static <K, V> Map<K, List<V>> mergeAllValuesIntoList(Collection<Map<K, V>> mapCollection) {
        LinkedHashMap retmap = new LinkedHashMap();
        Map initializedMap = MapUtils.initializedValueListMap(retmap);
        for (Map<K, V> map : mapCollection) {
            for (K key : map.keySet()) {
                initializedMap.get(key).add(map.get(key));
            }
        }
        return retmap;
    }

    public static <K, V> Map<K, List<V>> mergeAllMultiValuesIntoList(Map<K, ? extends Collection<V>> ... maps) {
        return MapUtils.mergeAllMultiValuesIntoList(Arrays.asList(maps));
    }

    public static <K, V> Map<K, Set<V>> mergeAllMultiValuesIntoSet(Map<K, ? extends Collection<V>> ... maps) {
        return MapUtils.mergeAllMultiValuesIntoSet(Arrays.asList(maps));
    }

    public static <K, V> Map<K, List<V>> mergeAllMultiValuesIntoList(Collection<Map<K, ? extends Collection<V>>> mapCollection) {
        LinkedHashMap retmap = new LinkedHashMap();
        Map initializedMap = MapUtils.initializedValueListMap(retmap);
        for (Map<K, Collection<V>> map : mapCollection) {
            for (K key : map.keySet()) {
                initializedMap.get(key).addAll(map.get(key));
            }
        }
        return retmap;
    }

    public static <K, V> Map<K, Set<V>> mergeAllMultiValuesIntoSet(Collection<Map<K, ? extends Collection<V>>> mapCollection) {
        LinkedHashMap retmap = new LinkedHashMap();
        Map initializedMap = MapUtils.initializedValueSetMap(retmap);
        for (Map<K, Collection<V>> map : mapCollection) {
            for (K key : map.keySet()) {
                initializedMap.get(key).addAll(map.get(key));
            }
        }
        return retmap;
    }

    public static <K, V> Map<K, Set<V>> mergeAllValuesIntoSet(Map<K, V> ... maps) {
        return MapUtils.mergeAllValuesIntoSet(Arrays.asList(maps));
    }

    public static <K, V> Map<K, Set<V>> mergeAllValuesIntoSet(Collection<Map<K, V>> mapCollection) {
        LinkedHashMap retmap = new LinkedHashMap();
        Map initializedMap = MapUtils.initializedValueSetMap(retmap);
        for (Map<K, V> map : mapCollection) {
            for (K key : map.keySet()) {
                initializedMap.get(key).add(map.get(key));
            }
        }
        return retmap;
    }

    public static <K, VA, VB> Map<K, Tuple2<VA, VB>> innerJoinMapByKey(Map<K, VA> mapA, Map<K, VB> mapB) {
        LinkedHashMap<K, Tuple2<VA, VB>> retmap = new LinkedHashMap<K, Tuple2<VA, VB>>();
        if (mapA != null && mapB != null) {
            for (K key : mapA.keySet()) {
                if (!mapB.containsKey(key)) continue;
                VA valueA = mapA.get(key);
                VB valueB = mapB.get(key);
                retmap.put(key, new Tuple2<VA, VB>(valueA, valueB));
            }
        }
        return retmap;
    }

    public static MapJoiner joiner() {
        return new MapJoiner();
    }

    public static <KeyFrom, KeyTo, Value> Map<KeyTo, Value> convertMapKey(Map<? extends KeyFrom, ? extends Value> map, ElementConverter<KeyFrom, KeyTo> keyElementConverter) {
        return MapUtils.convertMap(map, keyElementConverter, new ElementConverterIdentity());
    }

    public static <Key, ValueFrom, ValueTo> Map<Key, ValueTo> convertMapValue(Map<? extends Key, ? extends ValueFrom> map, ElementConverter<ValueFrom, ValueTo> valueElementConverter) {
        return MapUtils.convertMap(map, new ElementConverterIdentity(), valueElementConverter);
    }

    public static <KeyFrom, KeyTo, ValueFrom, ValueTo> Map<KeyTo, ValueTo> convertMap(Map<? extends KeyFrom, ? extends ValueFrom> map, ElementConverter<KeyFrom, KeyTo> keyElementConverter, ElementConverter<ValueFrom, ValueTo> valueElementConverter) {
        LinkedHashMap<KeyTo, ValueTo> retmap = null;
        if (map != null && keyElementConverter != null && valueElementConverter != null) {
            retmap = new LinkedHashMap<KeyTo, ValueTo>(map.size());
            for (KeyFrom keyFrom : map.keySet()) {
                KeyTo keyTo = keyElementConverter.convert(keyFrom);
                ValueTo valueTo = valueElementConverter.convert(map.get(keyFrom));
                retmap.put(keyTo, valueTo);
            }
        }
        return retmap;
    }

    public static <KeyFrom, KeyTo, ValueFrom, ValueTo> Map<KeyTo, ValueTo> convertMap(Map<? extends KeyFrom, ? extends ValueFrom> map, ElementConverter<Map.Entry<KeyFrom, ValueFrom>, Map.Entry<KeyTo, ValueTo>> entryElementConverter) {
        LinkedHashMap<KeyTo, ValueTo> retmap = null;
        if (map != null && entryElementConverter != null) {
            retmap = new LinkedHashMap<KeyTo, ValueTo>(map.size());
            for (Map.Entry<KeyFrom, ValueFrom> entry : map.entrySet()) {
                Map.Entry<KeyTo, ValueTo> convertedEntry = entryElementConverter.convert(entry);
                KeyTo keyTo = convertedEntry.getKey();
                ValueTo valueTo = convertedEntry.getValue();
                retmap.put(keyTo, valueTo);
            }
        }
        return retmap;
    }

    public static <K, V> String toStringUsingHierarchy(Map<K, V> map) {
        ByteArrayContainer byteArrayContainer = new ByteArrayContainer();
        PrintStream printStream = byteArrayContainer.getPrintStreamWriter();
        MapUtils.printMapHierarchical(printStream, map);
        return byteArrayContainer.toString();
    }

    public static <K, V> String toString(Map<K, V> map) {
        StringBuilder retval = new StringBuilder();
        if (map != null) {
            retval.append("[\n");
            Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
            while (iterator != null && iterator.hasNext()) {
                try {
                    Map.Entry<K, V> entry = iterator.next();
                    retval.append("  " + entry.toString() + "\n");
                }
                catch (Exception exception) {}
            }
            retval.append("]");
        }
        return retval.toString();
    }

    public static <TO, K, V> List<TO> toList(Map<K, V> map, MapEntryToElementConverter<TO, K, V> mapEntryToElementConverter) {
        ArrayList<TO> retlist = new ArrayList<TO>();
        if (map != null && mapEntryToElementConverter != null) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                retlist.add(mapEntryToElementConverter.convert(entry));
            }
        }
        return retlist;
    }

    public static <K, V> Map<K, V> filteredMap(Map<K, V> map, ElementFilter<K> keyElementFilter) {
        Set<K> filterKeySet = SetUtils.filter(map.keySet(), keyElementFilter);
        return MapUtils.filteredMap(map, filterKeySet);
    }

    public static <K, V> Map<K, V> filteredMap(Map<K, V> map, Iterable<K> filterKeyIterable) {
        LinkedHashMap<K, V> retmap = new LinkedHashMap<K, V>();
        if (map != null && filterKeyIterable != null) {
            for (K key : filterKeyIterable) {
                if (!map.containsKey(key)) continue;
                retmap.put(key, map.get(key));
            }
        }
        return retmap;
    }

    public static <K, V> Map<K, V> filteredMapExcludingNullValues(Map<K, V> map) {
        LinkedHashMap<K, V> retmap = new LinkedHashMap<K, V>();
        if (map != null) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                retmap.put(entry.getKey(), entry.getValue());
            }
        }
        return retmap;
    }

    public static void printMapHierarchical(PrintStream printStream, Map map) {
        class MapPrinter {
            final /* synthetic */ PrintStream val$printStream;

            MapPrinter(PrintStream printStream) {
                this.val$printStream = printStream;
            }

            public void printMap(Map map, int indentation) {
                if (map != null) {
                    String indentationString = StringUtils.repeat((String)" |", (int)(indentation / 2));
                    this.val$printStream.append(indentation == 0 ? indentationString + "-+\n" : "");
                    for (Object key : map.keySet()) {
                        Object value = map.get(key);
                        if (value instanceof Map) {
                            this.val$printStream.append(indentationString + " |-+ " + String.valueOf(key) + "\n");
                            this.printMap((Map)value, indentation + 2);
                            continue;
                        }
                        this.val$printStream.append(indentationString + " |-- " + String.valueOf(key) + "=" + String.valueOf(map.get(key)) + "\n");
                    }
                    this.val$printStream.append(indentationString + "\n");
                }
            }
        }
        new MapPrinter(printStream).printMap(map, 0);
    }

    public static <K, V> Map<K, V> locked(Map<K, V> map, Lock lock) {
        return new LockingMapDecorator<K, V>(map, lock);
    }

    public static <K, V> Map<K, V> lockedByReentrantLock(Map<K, V> map) {
        ReentrantLock lock = new ReentrantLock();
        return MapUtils.locked(map, lock);
    }

    public static <K, V> Map<V, K> invertedBidirectionalMap(Map<? extends K, ? extends V> map) {
        LinkedHashMap<K, V> retmap;
        LinkedHashMap<K, V> linkedHashMap = retmap = map == null ? null : new LinkedHashMap<K, V>();
        if (retmap != null) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                K key = entry.getKey();
                V value = entry.getValue();
                if (retmap.containsKey(value)) continue;
                retmap.put(value, key);
            }
        }
        return retmap;
    }

    public static <K, V> Map<V, Set<K>> invert(Map<? extends K, ? extends V> map) {
        LinkedHashMap retmap;
        LinkedHashMap linkedHashMap = retmap = map == null ? null : new LinkedHashMap();
        if (retmap != null) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                K key = entry.getKey();
                V value = entry.getValue();
                if (!retmap.containsKey(value)) {
                    retmap.put(value, new LinkedHashSet());
                }
                ((Set)retmap.get(value)).add(key);
            }
        }
        return retmap;
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> initializedEnumMap(Class<K> enumType, Factory<V> factory) {
        EnumMap<Enum, Object> retmap;
        EnumMap<Enum, Object> enumMap = retmap = enumType != null ? new EnumMap<Enum, Object>(enumType) : null;
        if (retmap != null) {
            for (Enum key : EnumUtils.getEnumList(enumType)) {
                Object value = factory != null ? (Object)factory.newInstance() : null;
                retmap.put(key, value);
            }
        }
        return retmap;
    }

    public static <K, V> void initializeMap(Map<K, V> map, Iterable<K> keyIterable, Factory<V> valueFactory) {
        boolean overwriteValuesOfExistingKeys = false;
        MapUtils.initializeMap(map, keyIterable, valueFactory, overwriteValuesOfExistingKeys);
    }

    public static <K, V> void initializeMap(Map<K, V> map, Iterable<K> keyIterable, Factory<V> valueFactory, boolean overwriteValuesOfExistingKeys) {
        if (map != null && keyIterable != null && valueFactory != null) {
            Set<K> keySet = SetUtils.valueOf(keyIterable);
            if (!overwriteValuesOfExistingKeys) {
                keySet.removeAll(map.keySet());
            }
            for (K key : keySet) {
                map.put(key, valueFactory.newInstance());
            }
        }
    }

    public static <K, V> Map<K, V> initializedMap(Factory<V> valueFactory) {
        LinkedHashMap map = new LinkedHashMap();
        return MapUtils.initializedMap(map, valueFactory);
    }

    public static <K, V> Map<K, V> initializedMap(FactoryParameterized<V, K> valueFactory) {
        LinkedHashMap map = new LinkedHashMap();
        return MapUtils.initializedMap(map, valueFactory);
    }

    public static <K, V> Map<K, V> initializedMap(Map<K, V> map, final Factory<V> valueFactory) {
        Assert.isNotNull(valueFactory, "Factory must be not null");
        Assert.isNotNull(map, "Map must be not null");
        return new MapDecorator<K, V>(map){
            private static final long serialVersionUID = -2028575193912665021L;

            @Override
            public V get(Object key) {
                Object value = super.get(key);
                if (value == null) {
                    value = valueFactory.newInstance();
                    this.put(key, value);
                }
                return value;
            }
        };
    }

    public static <K, V> Map<K, List<V>> initializedValueListMap() {
        return MapUtils.initializedMap(new ArrayListFactory());
    }

    public static <K, V> Map<K, List<V>> initializedValueListMap(Map<K, List<V>> map) {
        return MapUtils.initializedMap(map, new ArrayListFactory());
    }

    public static <K, V> Map<K, Set<V>> initializedValueSetMap() {
        return MapUtils.initializedMap(new LinkedHashSetFactory());
    }

    public static <K, V> Map<K, Set<V>> initializedValueSetMap(Map<K, Set<V>> map) {
        return MapUtils.initializedMap(map, new LinkedHashSetFactory());
    }

    public static <K, V> Map<K, V> initializedMap(Map<K, V> map, final FactoryParameterized<V, K> valueFactory) {
        Assert.isNotNull(valueFactory, "Factory must be not null");
        Assert.isNotNull(map, "Map must be not null");
        return new MapDecorator<K, V>(map){
            private static final long serialVersionUID = -9085868697374650245L;

            @Override
            public V get(Object keyObject) {
                Object value = super.get(keyObject);
                if (value == null) {
                    Object key = keyObject;
                    value = valueFactory.newInstance(key);
                    this.put(key, value);
                }
                return value;
            }
        };
    }

    public static <K, V> Map<K, V> defaultValueMap(Map<K, V> map, final V defaultValue) {
        return MapUtils.defaultValueMap(map, new FactoryParameterizedSerializable<V, K>(){
            private static final long serialVersionUID = 19870987L;

            @Override
            public V newInstance(K parameterMap) {
                return defaultValue;
            }
        });
    }

    public static <K, V> Map<K, V> defaultValueMap(Map<K, V> map, final FactoryParameterized<V, K> valueFactory) {
        return new MapDecorator<K, V>(map){
            private static final long serialVersionUID = -9083838697374650245L;

            @Override
            public V get(Object keyObject) {
                Object value = super.get(keyObject);
                if (value == null) {
                    Object key = keyObject;
                    value = valueFactory.newInstance(key);
                }
                return value;
            }
        };
    }

    public static <K, V> SortedMap<K, V> initializedSortedMap(SortedMap<K, V> sortedMap, final Factory<V> valueFactory) {
        Assert.isNotNull(valueFactory, "Factory must be not null");
        Assert.isNotNull(sortedMap, "Map must be not null");
        return new SortedMapDecorator<K, V>(sortedMap){

            @Override
            public V get(Object key) {
                Object value = super.get(key);
                if (value == null) {
                    value = valueFactory.newInstance();
                    this.put(key, value);
                }
                return value;
            }
        };
    }

    public static <E> E getValueByRegex(Map<String, ? extends E> map, String regex) {
        E retval = null;
        if (map != null && (retval = (E)map.get(regex)) == null) {
            for (String key : map.keySet()) {
                if (key == null || !key.matches(regex)) continue;
                retval = map.get(key);
                break;
            }
        }
        return retval;
    }

    public static <K, V> Map.Entry<K, V> firstEntry(Map<K, V> map) {
        Map.Entry<K, V> retval = null;
        if (map != null && !map.isEmpty()) {
            retval = IterableUtils.firstElement(map.entrySet());
        }
        return retval;
    }

    public static <K, V> Map.Entry<K, V> lastEntry(Map<K, V> map) {
        Map.Entry<K, V> retval = null;
        if (map != null && !map.isEmpty()) {
            retval = IterableUtils.lastElement(map.entrySet());
        }
        return retval;
    }

    public static <K, V> Map.Entry<K, V> entryAt(Map<K, V> map, int indexPosition) {
        Map.Entry<K, V> retval = map != null ? IterableUtils.elementAt(map.entrySet(), indexPosition) : null;
        return retval;
    }

    public static <K, V> Map<K, V> valueOf(KeyExtractor<? extends K, V> keyExtractor, V ... values) {
        return MapUtils.valueOf(keyExtractor, Arrays.asList(values));
    }

    public static <K, V> Map<K, V> valueOf(KeyExtractor<? extends K, V> keyExtractor, Iterable<? extends V> iterable) {
        LinkedHashMap<K, V> retmap = new LinkedHashMap<K, V>();
        if (keyExtractor != null && iterable != null) {
            for (V element : iterable) {
                K key = keyExtractor.extractKey(element);
                retmap.put(key, element);
            }
        }
        return retmap;
    }

    public static <K, V> Map<K, List<V>> valueOfMultiple(KeyExtractor<? extends K, V> keyExtractor, V ... values) {
        return MapUtils.valueOfMultiple(keyExtractor, Arrays.asList(values));
    }

    public static <K, V> Map<K, List<V>> valueOfMultiple(KeyExtractor<? extends K, V> keyExtractor, Iterable<? extends V> iterable) {
        LinkedHashMap retmap = new LinkedHashMap();
        if (keyExtractor != null && iterable != null) {
            Map initializedRetmap = MapUtils.initializedValueListMap(retmap);
            for (V element : iterable) {
                K key = keyExtractor.extractKey(element);
                initializedRetmap.get(key).add(element);
            }
        }
        return retmap;
    }

    public static <K, V, E> Map<K, V> valueOf(Iterable<E> iterable, ElementConverterElementToMapEntry<E, K, V> elementToMapEntryTransformer) {
        LinkedHashMap<K, V> retmap = new LinkedHashMap<K, V>();
        if (iterable != null && elementToMapEntryTransformer != null) {
            for (E element : iterable) {
                Map.Entry<K, V> entry = elementToMapEntryTransformer.convert(element);
                if (entry == null) continue;
                retmap.put(entry.getKey(), entry.getValue());
            }
        }
        return retmap;
    }

    public static <K, V> Map<K, V> composite(Map<K, V> ... maps) {
        return new MapComposite<K, V>(maps);
    }

    public static <K, V> Map<K, V> composite(List<Map<K, V>> mapList) {
        return new MapComposite<K, V>(mapList);
    }

    public static <KEY_FROM, VALUE_FROM, KEY_TO, VALUE_TO> Map<KEY_TO, VALUE_TO> adapter(Map<KEY_FROM, VALUE_FROM> sourceMap, ElementBidirectionalConverter<KEY_FROM, KEY_TO> elementBidirectionalConverterKey, ElementBidirectionalConverter<VALUE_FROM, VALUE_TO> elementBidirectionalConverterValue) {
        return new MapToMapAdapter<KEY_FROM, VALUE_FROM, KEY_TO, VALUE_TO>(sourceMap, elementBidirectionalConverterKey, elementBidirectionalConverterValue);
    }

    public static <KEY, VALUE_FROM, VALUE_TO> SortedMap<KEY, VALUE_TO> adapter(SortedMap<KEY, VALUE_FROM> sourceMap, ElementBidirectionalConverter<VALUE_FROM, VALUE_TO> elementBidirectionalConverterValue) {
        return new SortedMapToSortedMapAdapter<KEY, VALUE_FROM, VALUE_TO>(sourceMap, elementBidirectionalConverterValue);
    }

    public static Map<String, String> parseString(String content) {
        String entityDelimiterRegEx = null;
        String keyValueDelimiterRegEx = null;
        return MapUtils.parseString(content, entityDelimiterRegEx, keyValueDelimiterRegEx);
    }

    public static Map<String, String> parseString(String content, String entityDelimiterRegEx, String keyValueDelimiterRegEx) {
        LinkedHashMap<String, String> retmap = new LinkedHashMap<String, String>();
        if (content != null) {
            String[] entityTokens;
            entityDelimiterRegEx = StringUtils.defaultString((String)entityDelimiterRegEx, (String)"[;\\|]");
            keyValueDelimiterRegEx = StringUtils.defaultString((String)keyValueDelimiterRegEx, (String)"[=:]");
            for (String entityToken : entityTokens = content.split(entityDelimiterRegEx)) {
                String value;
                String key;
                if (!StringUtils.isNotEmpty((CharSequence)entityToken)) continue;
                String[] keyAndValueTokens = entityToken.split(keyValueDelimiterRegEx);
                if (keyAndValueTokens.length == 1) {
                    key = keyAndValueTokens[0];
                    value = null;
                    retmap.put(key, value);
                    continue;
                }
                if (keyAndValueTokens.length != 2) continue;
                key = keyAndValueTokens[0];
                value = keyAndValueTokens[1];
                retmap.put(key, value);
            }
        }
        return retmap;
    }

    public static boolean isMapType(Class<?> type) {
        boolean retval = false;
        if (type != null) {
            retval = Map.class.isAssignableFrom(type);
        }
        return retval;
    }

    public static boolean isSortedMapType(Class<?> type) {
        boolean retval = false;
        if (type != null) {
            retval = SortedMap.class.isAssignableFrom(type);
        }
        return retval;
    }

    public static MapBuilder builder() {
        return new MapBuilder();
    }

    public static int size(Map<?, ?> map) {
        int retval = 0;
        if (map != null) {
            retval = map.size();
        }
        return retval;
    }

    public static <K, V> V[] filteredValues(Map<K, V> map, Class<V> valueType, K ... keys) {
        Assert.isNotNull(valueType);
        Object[] retvals = (Object[])Array.newInstance(valueType, keys != null ? keys.length : 0);
        if (keys != null && map != null) {
            int ii = 0;
            for (K key : keys) {
                V value = map.get(key);
                retvals[ii++] = value;
            }
        }
        return retvals;
    }

    public static <E> Map<E, AtomicInteger> initializedCounterMap() {
        return MapUtils.initializedMap(new FactorySerializable<AtomicInteger>(){
            private static final long serialVersionUID = 2356741002226308586L;

            @Override
            public AtomicInteger newInstance() {
                return new AtomicInteger();
            }
        });
    }

    public static <K, V> MapDelta<K, V> delta(Map<K, V> mapFirst, Map<K, V> mapSecond) {
        return new MapDelta<K, V>(mapFirst, mapSecond);
    }

    public static <K, V> AggregatedMap<K, V> aggregatedMap(Iterable<? extends Map<K, V>> mapIterable) {
        return new AggregatedMap(mapIterable);
    }

    public static <K, V> boolean putIfAbsent(Map<K, V> map, K key, V value) {
        boolean retval = false;
        if (map != null && !map.containsKey(key)) {
            map.put(key, value);
            retval = true;
        }
        return retval;
    }

    public static <K, V> boolean putIfAbsent(Map<K, V> map, K key, Factory<V> valueFactory) {
        boolean retval = false;
        if (map != null && valueFactory != null && !map.containsKey(key)) {
            V value = valueFactory.newInstance();
            map.put(key, value);
            retval = true;
        }
        return retval;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(Map<K, V> map, Comparator<K> comparator) {
        TreeMap<K, V> treeMap;
        TreeMap<K, V> treeMap2 = treeMap = comparator != null ? new TreeMap<K, V>(comparator) : new TreeMap();
        if (map != null) {
            treeMap.putAll(map);
        }
        return treeMap;
    }

    public static <K, V> void sortKeys(Map<K, V> map, Comparator<? super K> comparator) {
        Set<K> keySet;
        if (map != null && (keySet = map.keySet()) != null) {
            TreeMap treeMap = new TreeMap(comparator);
            treeMap.putAll(map);
            map.clear();
            map.putAll(treeMap);
        }
    }

    public static interface MapEntryToElementConverter<TO, K, V>
    extends ElementConverter<Map.Entry<K, V>, TO> {
        @Override
        public TO convert(Map.Entry<K, V> var1);
    }

    public static interface MapElementMergeOperation<K, V> {
        public void merge(K var1, V var2, Map<K, V> var3);
    }
}

