/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.map;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.omnaest.utils.structure.element.factory.Factory;

public class ThreadLocalMap<K, V>
implements Map<K, V> {
    protected ThreadLocal<Map<K, V>> threadLocalForMap = new ThreadLocal();
    protected Factory<Map<K, V>> mapFactory = new Factory<Map<K, V>>(){

        @Override
        public Map<K, V> newInstance() {
            return new LinkedHashMap();
        }
    };

    @Override
    public void clear() {
        this.getMap().clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getMap().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getMap().containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.getMap().entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.getMap()).equals(o);
    }

    @Override
    public V get(Object key) {
        return this.getMap().get(key);
    }

    public Map<K, V> getMap() {
        Map<K, V> retmap = this.threadLocalForMap.get();
        if (retmap == null) {
            retmap = this.mapFactory.newInstance();
            this.threadLocalForMap.set(retmap);
        }
        return retmap;
    }

    @Override
    public int hashCode() {
        return ((Object)this.getMap()).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.getMap().keySet();
    }

    @Override
    public V put(K key, V value) {
        return this.getMap().put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.getMap().putAll(m);
    }

    @Override
    public V remove(Object key) {
        return this.getMap().remove(key);
    }

    public ThreadLocalMap<K, V> setMap(Map<K, V> map) {
        if (map != null) {
            this.threadLocalForMap.set(map);
        }
        return this;
    }

    public void setMapFactory(Factory<Map<K, V>> mapFactory) {
        this.mapFactory = mapFactory;
    }

    @Override
    public int size() {
        return this.getMap().size();
    }

    @Override
    public Collection<V> values() {
        return this.getMap().values();
    }

    public void remove() {
        this.threadLocalForMap.remove();
    }
}

