/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.map.adapter;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.structure.collection.CollectionUtils;
import org.omnaest.utils.structure.collection.set.SetUtils;
import org.omnaest.utils.structure.element.converter.ElementBidirectionalConverter;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.element.converter.ElementConverterToBidirectionalConverterAdapter;
import org.omnaest.utils.structure.map.MapAbstract;

public class MapToMapAdapter<KEY_FROM, VALUE_FROM, KEY_TO, VALUE_TO>
extends MapAbstract<KEY_TO, VALUE_TO> {
    private static final long serialVersionUID = -1538459740184023592L;
    private Map<KEY_FROM, VALUE_FROM> sourceMap = null;
    private ElementBidirectionalConverter<KEY_FROM, KEY_TO> elementBidirectionalConverterKey;
    private ElementBidirectionalConverter<VALUE_FROM, VALUE_TO> elementBidirectionalConverterValue;

    public MapToMapAdapter(Map<KEY_FROM, VALUE_FROM> sourceMap, ElementConverter<KEY_FROM, KEY_TO> elementConverterKeySourceToAdapter, ElementConverter<KEY_TO, KEY_FROM> elementConverterKeyAdapterToSource, ElementConverter<VALUE_FROM, VALUE_TO> elementConverterValueSourceToAdapter, ElementConverter<VALUE_TO, VALUE_FROM> elementConverterValueAdapterToSource) {
        Assert.isNotNull(sourceMap, elementConverterValueAdapterToSource, elementConverterValueSourceToAdapter, elementConverterKeyAdapterToSource, elementConverterKeySourceToAdapter);
        this.sourceMap = sourceMap;
        this.elementBidirectionalConverterKey = new ElementConverterToBidirectionalConverterAdapter<KEY_FROM, KEY_TO>(elementConverterKeySourceToAdapter, elementConverterKeyAdapterToSource);
        this.elementBidirectionalConverterValue = new ElementConverterToBidirectionalConverterAdapter<VALUE_FROM, VALUE_TO>(elementConverterValueSourceToAdapter, elementConverterValueAdapterToSource);
    }

    public MapToMapAdapter(Map<KEY_FROM, VALUE_FROM> sourceMap, ElementBidirectionalConverter<KEY_FROM, KEY_TO> elementBidirectionalConverterKey, ElementBidirectionalConverter<VALUE_FROM, VALUE_TO> elementBidirectionalConverterValue) {
        Assert.isNotNull(elementBidirectionalConverterKey, elementBidirectionalConverterValue, sourceMap);
        this.sourceMap = sourceMap;
        this.elementBidirectionalConverterKey = elementBidirectionalConverterKey;
        this.elementBidirectionalConverterValue = elementBidirectionalConverterValue;
    }

    protected KEY_TO convertKeyFromToKeyTo(KEY_FROM key_FROM) {
        return (KEY_TO)this.elementBidirectionalConverterKey.convert(key_FROM);
    }

    protected KEY_FROM convertKeyToToKeyFrom(KEY_TO key_TO) {
        return this.elementBidirectionalConverterKey.convertBackwards(key_TO);
    }

    protected VALUE_TO convertValueFromToValueTo(VALUE_FROM value_FROM) {
        return (VALUE_TO)this.elementBidirectionalConverterValue.convert(value_FROM);
    }

    protected VALUE_FROM convertValueToToValueFrom(VALUE_TO value_TO) {
        return this.elementBidirectionalConverterValue.convertBackwards(value_TO);
    }

    @Override
    public VALUE_TO get(Object key) {
        VALUE_TO retval = null;
        if (key != null && this.sourceMap != null) {
            try {
                KEY_FROM convertedKey = this.convertKeyToToKeyFrom(key);
                if (convertedKey != null) {
                    VALUE_FROM value_FROM = this.sourceMap.get(convertedKey);
                    retval = this.convertValueFromToValueTo(value_FROM);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retval;
    }

    @Override
    public VALUE_TO put(KEY_TO key, VALUE_TO value) {
        VALUE_TO retval = null;
        if (key != null && this.sourceMap != null) {
            try {
                KEY_FROM convertedKey = this.convertKeyToToKeyFrom(key);
                VALUE_FROM convertedValue = this.convertValueToToValueFrom(value);
                if (convertedKey != null) {
                    VALUE_FROM value_FROM = this.sourceMap.put(convertedKey, convertedValue);
                    retval = this.convertValueFromToValueTo(value_FROM);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return retval;
    }

    @Override
    public VALUE_TO remove(Object key) {
        VALUE_TO retval = null;
        if (key != null && this.sourceMap != null) {
            try {
                KEY_FROM convertedKey = this.convertKeyToToKeyFrom(key);
                if (convertedKey != null) {
                    VALUE_FROM value_FROM = this.sourceMap.remove(convertedKey);
                    retval = this.convertValueFromToValueTo(value_FROM);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retval;
    }

    @Override
    public Set<KEY_TO> keySet() {
        return SetUtils.adapter(this.sourceMap.keySet(), this.elementBidirectionalConverterKey);
    }

    @Override
    public Collection<VALUE_TO> values() {
        return CollectionUtils.adapter(this.sourceMap.values(), this.elementBidirectionalConverterValue);
    }
}

