/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.map.adapter;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.omnaest.utils.structure.map.dualmap.DualMap;

public class MapWithKeyMappingAdapter<KEY_TO, KEY_FROM, V>
implements Map<KEY_TO, V> {
    private Map<KEY_FROM, V> map = null;
    private DualMap<KEY_FROM, KEY_TO> underlyingMapKeyToAdapterMapKeyMap = null;

    public MapWithKeyMappingAdapter(Map<KEY_FROM, V> map, DualMap<KEY_FROM, KEY_TO> underlyingMapKeyToAdapterMapKeyMap) {
        this.map = map;
        this.underlyingMapKeyToAdapterMapKeyMap = underlyingMapKeyToAdapterMapKeyMap;
    }

    private KEY_FROM translateToUnderlyingMapKey(Object key) {
        Object retval = null;
        try {
            retval = this.underlyingMapKeyToAdapterMapKeyMap.invert().get(key);
            if (retval == null) {
                retval = key;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return (KEY_FROM)retval;
    }

    private KEY_TO translateToNewKey(KEY_FROM key) {
        Object retval = this.underlyingMapKeyToAdapterMapKeyMap.get(key);
        if (retval == null) {
            retval = key;
        }
        return (KEY_TO)retval;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(this.translateToUnderlyingMapKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        V retval = null;
        KEY_FROM translatedKey = this.translateToUnderlyingMapKey(key);
        retval = this.map.get(translatedKey);
        return retval;
    }

    @Override
    public V put(KEY_TO key, V value) {
        return this.map.put(this.translateToUnderlyingMapKey(key), value);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(this.translateToUnderlyingMapKey(key));
    }

    @Override
    public void putAll(Map<? extends KEY_TO, ? extends V> m) {
        this.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<KEY_TO> keySet() {
        LinkedHashSet<KEY_TO> retset = new LinkedHashSet<KEY_TO>();
        for (KEY_FROM key : this.map.keySet()) {
            KEY_TO translatedKey = this.translateToNewKey(key);
            retset.add(translatedKey);
        }
        return retset;
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<KEY_TO, V>> entrySet() {
        LinkedHashSet<Map.Entry<KEY_TO, V>> retset = new LinkedHashSet<Map.Entry<KEY_TO, V>>();
        for (final Map.Entry<KEY_FROM, V> entry : this.map.entrySet()) {
            retset.add(new Map.Entry<KEY_TO, V>(){

                @Override
                public KEY_TO getKey() {
                    return MapWithKeyMappingAdapter.this.translateToNewKey(entry.getKey());
                }

                @Override
                public V getValue() {
                    return entry.getValue();
                }

                @Override
                public V setValue(V value) {
                    return entry.setValue(value);
                }
            });
        }
        return retset;
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.map).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    public String toString() {
        return String.format("MapWithKeyMappingAdapter [map=%s, keyToKeyMap=%s]", this.map, this.underlyingMapKeyToAdapterMapKeyMap);
    }
}

