/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.map.adapter;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.structure.collection.CollectionUtils;
import org.omnaest.utils.structure.collection.set.SetUtils;
import org.omnaest.utils.structure.element.converter.ElementBidirectionalConverter;
import org.omnaest.utils.structure.map.MapUtils;

public class SortedMapToSortedMapAdapter<KEY, VALUE_FROM, VALUE_TO>
implements SortedMap<KEY, VALUE_TO>,
Serializable {
    private static final long serialVersionUID = -1538459740184023592L;
    private SortedMap<KEY, VALUE_FROM> sourceMap = null;
    private ElementBidirectionalConverter<VALUE_FROM, VALUE_TO> elementBidirectionalConverterValue;

    public SortedMapToSortedMapAdapter(SortedMap<KEY, VALUE_FROM> sourceMap, ElementBidirectionalConverter<VALUE_FROM, VALUE_TO> elementBidirectionalConverterValue) {
        Assert.isNotNull(sourceMap, elementBidirectionalConverterValue);
        this.sourceMap = sourceMap;
        this.elementBidirectionalConverterValue = elementBidirectionalConverterValue;
    }

    protected VALUE_TO convertValueFromToValueTo(VALUE_FROM value_FROM) {
        return (VALUE_TO)this.elementBidirectionalConverterValue.convert(value_FROM);
    }

    protected VALUE_FROM convertValueToToValueFrom(VALUE_TO value_TO) {
        return this.elementBidirectionalConverterValue.convertBackwards(value_TO);
    }

    @Override
    public VALUE_TO get(Object key) {
        VALUE_TO retval = null;
        if (key != null && this.sourceMap != null) {
            Object value_FROM = this.sourceMap.get(key);
            retval = this.convertValueFromToValueTo(value_FROM);
        }
        return retval;
    }

    @Override
    public VALUE_TO put(KEY key, VALUE_TO value) {
        VALUE_TO retval = null;
        if (key != null && this.sourceMap != null) {
            VALUE_FROM convertedValue = this.convertValueToToValueFrom(value);
            VALUE_FROM value_FROM = this.sourceMap.put(key, convertedValue);
            retval = this.convertValueFromToValueTo(value_FROM);
        }
        return retval;
    }

    @Override
    public VALUE_TO remove(Object key) {
        VALUE_TO retval = null;
        if (key != null && this.sourceMap != null) {
            Object value_FROM = this.sourceMap.remove(key);
            retval = this.convertValueFromToValueTo(value_FROM);
        }
        return retval;
    }

    @Override
    public Set<KEY> keySet() {
        return this.sourceMap.keySet();
    }

    @Override
    public Collection<VALUE_TO> values() {
        return CollectionUtils.adapter(this.sourceMap.values(), this.elementBidirectionalConverterValue);
    }

    @Override
    public int size() {
        return this.sourceMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.sourceMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.sourceMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        try {
            VALUE_FROM value_FROM = this.convertValueToToValueFrom(value);
            return this.sourceMap.containsValue(value_FROM);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void putAll(Map<? extends KEY, ? extends VALUE_TO> map) {
        Set<Map.Entry<KEY, VALUE_TO>> entrySet;
        if (map != null && (entrySet = map.entrySet()) != null) {
            for (Map.Entry<KEY, VALUE_TO> entry : entrySet) {
                if (entry == null) continue;
                VALUE_TO value = entry.getValue();
                KEY key = entry.getKey();
                this.put(key, value);
            }
        }
    }

    @Override
    public void clear() {
        this.sourceMap.clear();
    }

    @Override
    public Comparator<? super KEY> comparator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedMap<KEY, VALUE_TO> subMap(KEY fromKey, KEY toKey) {
        return MapUtils.adapter(this.sourceMap.subMap(fromKey, toKey), this.elementBidirectionalConverterValue);
    }

    @Override
    public SortedMap<KEY, VALUE_TO> headMap(KEY toKey) {
        return MapUtils.adapter(this.sourceMap.headMap(toKey), this.elementBidirectionalConverterValue);
    }

    @Override
    public SortedMap<KEY, VALUE_TO> tailMap(KEY fromKey) {
        return MapUtils.adapter(this.sourceMap.tailMap(fromKey), this.elementBidirectionalConverterValue);
    }

    @Override
    public KEY firstKey() {
        return this.sourceMap.firstKey();
    }

    @Override
    public KEY lastKey() {
        return this.sourceMap.lastKey();
    }

    @Override
    public Set<Map.Entry<KEY, VALUE_TO>> entrySet() {
        ElementBidirectionalConverter elementBidirectionalConverter = new ElementBidirectionalConverter<Map.Entry<KEY, VALUE_FROM>, Map.Entry<KEY, VALUE_TO>>(){

            @Override
            public Map.Entry<KEY, VALUE_TO> convert(final Map.Entry<KEY, VALUE_FROM> entry) {
                return new Map.Entry<KEY, VALUE_TO>(){

                    @Override
                    public KEY getKey() {
                        return entry.getKey();
                    }

                    @Override
                    public VALUE_TO getValue() {
                        Object value_FROM = entry.getValue();
                        Object value_TO = SortedMapToSortedMapAdapter.this.convertValueFromToValueTo(value_FROM);
                        return value_TO;
                    }

                    @Override
                    public VALUE_TO setValue(VALUE_TO value) {
                        Object value_FROM = SortedMapToSortedMapAdapter.this.convertValueToToValueFrom(value);
                        Object setValue = entry.setValue(value_FROM);
                        return SortedMapToSortedMapAdapter.this.convertValueFromToValueTo(setValue);
                    }

                    public String toString() {
                        return String.valueOf(this.getKey()) + "=" + String.valueOf(this.getValue());
                    }
                };
            }

            @Override
            public Map.Entry<KEY, VALUE_FROM> convertBackwards(Map.Entry<KEY, VALUE_TO> element) {
                throw new UnsupportedOperationException();
            }
        };
        return SetUtils.adapter(this.sourceMap.entrySet(), elementBidirectionalConverter);
    }

    public String toString() {
        return MapUtils.toString(this);
    }
}

