/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.map.decorator;

import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.utils.structure.map.MapUtils;
import org.omnaest.utils.structure.map.decorator.MapDecorator;

public class CaseinsensitiveMapDecorator<V>
extends MapDecorator<String, V> {
    protected final Map<String, String> sourceKeyToTargetKeyTranslationMap;
    protected boolean fastHit = false;

    public CaseinsensitiveMapDecorator(Map<String, V> map, boolean useCacheForKeys) {
        super(map);
        this.sourceKeyToTargetKeyTranslationMap = useCacheForKeys ? MapUtils.lockedByReentrantLock(new WeakHashMap()) : null;
    }

    public CaseinsensitiveMapDecorator(Map<String, V> map) {
        this(map, true);
    }

    public String tryTranslateKeyByCache(String sourceKey) {
        String retval = null;
        if (this.sourceKeyToTargetKeyTranslationMap != null) {
            retval = this.sourceKeyToTargetKeyTranslationMap.get(sourceKey);
        }
        return retval;
    }

    public void addKeyToKeyTranslationToCache(String sourceKey, String targetKey) {
        if (this.sourceKeyToTargetKeyTranslationMap != null) {
            this.sourceKeyToTargetKeyTranslationMap.put(sourceKey, targetKey);
        }
    }

    @Override
    public V get(Object object) {
        V retval = null;
        this.fastHit = true;
        if (super.containsKey(object)) {
            retval = super.get(object);
        } else if (object instanceof String) {
            String key = (String)object;
            String keyModified = null;
            keyModified = key.toLowerCase();
            if (super.containsKey(keyModified)) {
                retval = super.get(keyModified);
            } else {
                keyModified = key.toUpperCase();
                if (super.containsKey(keyModified)) {
                    retval = super.get(keyModified);
                } else {
                    keyModified = StringUtils.capitalize((String)key);
                    if (super.containsKey(keyModified)) {
                        retval = super.get(keyModified);
                    } else {
                        keyModified = this.tryTranslateKeyByCache(key);
                        if (super.containsKey(keyModified)) {
                            retval = super.get(keyModified);
                        } else {
                            for (String iKey : super.keySet()) {
                                if (!StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)iKey)) continue;
                                retval = super.get(iKey);
                                this.addKeyToKeyTranslationToCache(key, iKey);
                                this.fastHit = false;
                                break;
                            }
                        }
                    }
                }
            }
        }
        return retval;
    }

    protected boolean isFastHit() {
        return this.fastHit;
    }
}

