/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.map.decorator;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.omnaest.utils.structure.collection.CollectionUtils;
import org.omnaest.utils.structure.collection.set.SetUtils;
import org.omnaest.utils.structure.map.decorator.MapDecorator;

public class LockingMapDecorator<K, V>
extends MapDecorator<K, V> {
    protected final Lock lock;

    public LockingMapDecorator(Map<K, V> map, Lock lock) {
        super(map);
        this.lock = lock;
    }

    public LockingMapDecorator(Map<K, V> map) {
        super(map);
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int retval = 0;
        this.lock.lock();
        try {
            retval = super.size();
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        boolean retval = false;
        this.lock.lock();
        try {
            retval = super.isEmpty();
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        boolean retval = false;
        this.lock.lock();
        try {
            retval = super.containsKey(key);
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        boolean retval = false;
        this.lock.lock();
        try {
            retval = super.containsValue(value);
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        V retval = null;
        this.lock.lock();
        try {
            retval = super.get(key);
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        V retval = null;
        this.lock.lock();
        try {
            retval = super.put(key, value);
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        V retval = null;
        this.lock.lock();
        try {
            retval = super.remove(key);
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.lock.lock();
        try {
            super.putAll(m);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.lock.lock();
        try {
            super.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Set<K> keySet() {
        return SetUtils.locked(super.keySet(), this.lock);
    }

    @Override
    public Collection<V> values() {
        return CollectionUtils.locked(super.values(), this.lock);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return SetUtils.locked(super.entrySet(), this.lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object obj) {
        boolean retval = false;
        this.lock.lock();
        try {
            retval = super.equals(obj);
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        int retval = 0;
        this.lock.lock();
        try {
            retval = super.hashCode();
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        String retval = null;
        this.lock.lock();
        try {
            retval = super.toString();
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }
}

