/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.map.dualmap;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.omnaest.utils.operation.Operation;
import org.omnaest.utils.operation.foreach.ForEach;
import org.omnaest.utils.operation.special.OperationBooleanResult;
import org.omnaest.utils.structure.collection.decorator.CollectionDecorator;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.collection.set.decorator.SetDecorator;
import org.omnaest.utils.structure.iterator.decorator.IteratorDecorator;
import org.omnaest.utils.structure.map.dualmap.DualMap;

public class LinkedHashDualMap<K, V>
implements DualMap<K, V> {
    protected static final long serialVersionUID = 8985215388337132591L;
    protected final Map<K, V> keyToValueMap;
    protected final Map<V, K> valueToKeyMap;

    public LinkedHashDualMap() {
        this(new LinkedHashMap(), new LinkedHashMap());
    }

    protected LinkedHashDualMap(Map<K, V> keyToValueMap, Map<V, K> valueToKeyMap) {
        this.keyToValueMap = keyToValueMap;
        this.valueToKeyMap = valueToKeyMap;
    }

    @Override
    public void clear() {
        this.keyToValueMap.clear();
        this.valueToKeyMap.clear();
    }

    @Override
    public boolean contains(Object element) {
        return this.keyToValueMap.containsKey(element) || this.valueToKeyMap.containsKey(element);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyToValueMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object key) {
        return this.valueToKeyMap.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.keyToValueMap.isEmpty() && this.valueToKeyMap.isEmpty();
    }

    @Override
    public V put(K key, V value) {
        V retval = null;
        retval = this.keyToValueMap.put(key, value);
        this.valueToKeyMap.put(value, key);
        return retval;
    }

    @Override
    public int size() {
        return this.keyToValueMap.size();
    }

    @Override
    public DualMap<K, V> putAll(DualMap<? extends K, ? extends V> dualMap) {
        if (dualMap != null) {
            this.keyToValueMap.putAll(dualMap);
            this.valueToKeyMap.putAll(dualMap.invert());
        }
        return this;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (map != null) {
            for (K firstElement : map.keySet()) {
                this.put(firstElement, map.get(firstElement));
            }
        }
    }

    @Override
    public DualMap<V, K> invert() {
        return new LinkedHashDualMap<V, K>(this.valueToKeyMap, this.keyToValueMap);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LinkedHashDualMap [keyToValueMap=");
        builder.append(this.keyToValueMap);
        builder.append(", valueToKeyMap=");
        builder.append(this.valueToKeyMap);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public V get(Object key) {
        return this.keyToValueMap.get(key);
    }

    @Override
    public V remove(Object key) {
        V retval = null;
        if (key != null) {
            retval = this.keyToValueMap.remove(key);
            this.valueToKeyMap.remove(retval);
        }
        return retval;
    }

    @Override
    public Set<K> keySet() {
        return new SetDecorator<K>(this.keyToValueMap.keySet()){
            private static final long serialVersionUID = -3831726909173097066L;

            @Override
            public Iterator<K> iterator() {
                return new IteratorDecorator<K>(this.set.iterator()){
                    private K lastReturnedElement;
                    {
                        this.lastReturnedElement = null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public K next() {
                        this.lastReturnedElement = this.iterator.next();
                        return this.lastReturnedElement;
                    }

                    @Override
                    public void remove() {
                        this.iterator.remove();
                        if (this.lastReturnedElement != null) {
                            LinkedHashDualMap.this.valueToKeyMap.remove(this.lastReturnedElement);
                            this.lastReturnedElement = null;
                        }
                    }
                };
            }

            @Override
            public boolean remove(Object o) {
                return LinkedHashDualMap.this.remove(o) != null;
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new CollectionDecorator<V>(this.keyToValueMap.values()){
            private static final long serialVersionUID = -393065672929244447L;

            @Override
            public Iterator<V> iterator() {
                return new IteratorDecorator<V>(this.collection.iterator()){
                    private V lastReturnedElement;
                    {
                        this.lastReturnedElement = null;
                    }

                    @Override
                    public V next() {
                        this.lastReturnedElement = super.next();
                        return this.lastReturnedElement;
                    }

                    @Override
                    public void remove() {
                        if (this.lastReturnedElement != null) {
                            LinkedHashDualMap.this.invert().remove(this.lastReturnedElement);
                            this.lastReturnedElement = null;
                        }
                    }
                };
            }

            @Override
            public boolean remove(Object o) {
                return LinkedHashDualMap.this.invert().remove(o) != null;
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                OperationBooleanResult<Object> operation = new OperationBooleanResult<Object>(){

                    @Override
                    public Boolean execute(Object object) {
                        return this.remove(object);
                    }
                };
                return new ForEach((Iterable<?>)collection).execute((Operation<Boolean, ?>)operation).areAllValuesEqualTo(true);
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                boolean retval = true;
                if (collection != null) {
                    List valueList = ListUtils.valueOf(this);
                    valueList.removeAll(collection);
                    this.removeAll(valueList);
                }
                return retval;
            }

            @Override
            public void clear() {
                LinkedHashDualMap.this.clear();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new SetDecorator<Map.Entry<K, V>>(this.keyToValueMap.entrySet()){
            private static final long serialVersionUID = 7897572238594822950L;

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new IteratorDecorator<Map.Entry<K, V>>(super.iterator()){
                    private Map.Entry<K, V> lastReturnedEntry;
                    {
                        this.lastReturnedEntry = null;
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        this.lastReturnedEntry = (Map.Entry)super.next();
                        return this.lastReturnedEntry;
                    }

                    @Override
                    public void remove() {
                        if (this.lastReturnedEntry != null) {
                            LinkedHashDualMap.this.remove(this.lastReturnedEntry.getKey());
                            LinkedHashDualMap.this.invert().remove(this.lastReturnedEntry.getValue());
                            this.lastReturnedEntry = null;
                        }
                    }
                };
            }

            @Override
            public boolean add(Map.Entry<K, V> entry) {
                if (entry != null) {
                    LinkedHashDualMap.this.put(entry.getKey(), entry.getValue());
                }
                return entry != null;
            }

            @Override
            public boolean remove(Object object) {
                boolean retval = object instanceof Map.Entry;
                if (retval) {
                    Map.Entry entry = (Map.Entry)object;
                    retval &= LinkedHashDualMap.this.remove(entry.getKey()) != null;
                    retval &= LinkedHashDualMap.this.invert().remove(entry.getValue()) != null;
                }
                return retval;
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<K, V>> collection) {
                OperationBooleanResult operation = new OperationBooleanResult<Map.Entry<K, V>>(){

                    @Override
                    public Boolean execute(Map.Entry<K, V> entry) {
                        return this.add(entry);
                    }
                };
                return new ForEach(collection).execute(operation).areAllValuesEqualTo(true);
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                boolean retval = true;
                if (collection != null) {
                    List valueList = ListUtils.valueOf(this);
                    valueList.removeAll(collection);
                    this.removeAll(valueList);
                }
                return retval;
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                OperationBooleanResult<Object> operation = new OperationBooleanResult<Object>(){

                    @Override
                    public Boolean execute(Object object) {
                        return this.remove(object);
                    }
                };
                return new ForEach((Iterable<?>)collection).execute((Operation<Boolean, ?>)operation).areAllValuesEqualTo(true);
            }

            @Override
            public void clear() {
                LinkedHashDualMap.this.clear();
            }
        };
    }
}

