/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.threads;

import java.io.Serializable;
import java.util.concurrent.Callable;
import org.omnaest.utils.assertion.Assert;

public abstract class CallableDecorator<V>
implements Callable<V>,
Serializable {
    private static final long serialVersionUID = 6691986461223970211L;
    protected final Callable<V> callable;

    protected CallableDecorator(Callable<V> callable) {
        this.callable = callable;
        Assert.isNotNull(callable, "callable must not be null to be used by the CallableDecorator");
    }

    @Override
    public V call() throws Exception {
        return this.callable.call();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CallableDecorator [callable=");
        builder.append(this.callable);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.callable == null ? 0 : this.callable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CallableDecorator)) {
            return false;
        }
        CallableDecorator other = (CallableDecorator)obj;
        return !(this.callable == null ? other.callable != null : !this.callable.equals(other.callable));
    }
}

