/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.threads;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.element.ExceptionHandledResult;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.threads.RunnableToCallableAdapter;

public class FutureTaskManager
implements Serializable {
    private static final long serialVersionUID = -8509946186985263573L;
    protected final List<Future<?>> futureList = new ArrayList();
    protected final ExecutorService executorService;

    public FutureTaskManager(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public FutureTaskManager() {
        this.executorService = null;
    }

    public void manageFutureTask(Future<?> future) {
        if (future != null) {
            this.futureList.add(future);
        }
    }

    public void manageFutureTask(Iterable<Future<?>> futureIterable) {
        if (futureIterable != null) {
            for (Future<?> future : futureIterable) {
                this.manageFutureTask(future);
            }
        }
    }

    public void submitAndManage(ExecutorService executorService, Callable<?> callable) {
        this.submitAndManageCallables(executorService, Arrays.asList(callable), 1);
    }

    public void submitAndManage(ExecutorService executorService, Runnable runnable) {
        this.submitAndManageRunnables(executorService, Arrays.asList(runnable), 1);
    }

    public void submitAndManage(Callable<?> callable) {
        boolean submitCount = true;
        this.submitAndManage(callable, 1);
    }

    public void submitAndManage(Callable<?> callable, int submitCount) {
        if (this.executorService == null) {
            throw new UnsupportedOperationException("The " + FutureTaskManager.class + " must be initialied with an instance of an ExecutorService to support this operation");
        }
        this.submitAndManageCallables(this.executorService, Arrays.asList(callable), submitCount);
    }

    public void submitAndManage(Runnable runnable) {
        if (runnable != null) {
            this.submitAndManage(new RunnableToCallableAdapter(runnable));
        }
    }

    public void submitAndManage(Runnable runnable, int submitCount) {
        if (runnable != null) {
            this.submitAndManage(new RunnableToCallableAdapter(runnable), submitCount);
        }
    }

    public void submitAndManage(ExecutorService executorService, Runnable runnable, int submitCount) {
        this.submitAndManage(executorService, new RunnableToCallableAdapter(runnable), submitCount);
    }

    public void submitAndManage(ExecutorService executorService, Callable<?> callable, int submitCount) {
        if (callable != null) {
            this.submitAndManageCallables(executorService, Arrays.asList(callable), submitCount);
        }
    }

    public void submitAndManageRunnables(ExecutorService executorService, Collection<Runnable> runnableCollection, int submitCount) {
        ElementConverter elementConverter = new ElementConverter<Runnable, Callable<?>>(){

            @Override
            public Callable<?> convert(Runnable runnable) {
                return new RunnableToCallableAdapter(runnable);
            }
        };
        List callableCollection = ListUtils.convert(runnableCollection, elementConverter);
        this.submitAndManageCallables(executorService, callableCollection, submitCount);
    }

    public void submitAndManageCallables(ExecutorService executorService, Collection<? extends Callable<?>> callableCollection, int submitCount) {
        if (executorService != null && callableCollection != null) {
            for (Callable<?> callable : callableCollection) {
                for (int ii = 1; ii <= submitCount; ++ii) {
                    Future<?> future = executorService.submit(callable);
                    if (future == null) continue;
                    this.manageFutureTask(future);
                }
            }
        }
    }

    public <V> ExceptionHandledResult<List<V>> waitForAllTasksToFinish() {
        ArrayList<Exception> exceptionCollection = new ArrayList<Exception>();
        ArrayList result = new ArrayList();
        for (Future<?> future : this.futureList) {
            ExceptionHandledResult<?> exceptionHandledResult = FutureTaskManager.waitForTaskToFinish(future);
            result.add(exceptionHandledResult.getResult());
            exceptionCollection.addAll(exceptionHandledResult.getExceptionList());
        }
        return new ExceptionHandledResult<List<V>>(result, exceptionCollection);
    }

    public static <V> ExceptionHandledResult<V> waitForTaskToFinish(Future<V> future) {
        ArrayList<Exception> exceptionCollection = new ArrayList<Exception>();
        Object result = null;
        if (future != null) {
            try {
                boolean waitForTask = true;
                while (waitForTask) {
                    try {
                        result = future.get();
                        waitForTask = false;
                    }
                    catch (InterruptedException e) {}
                }
            }
            catch (Exception e) {
                exceptionCollection.add(e);
            }
        }
        return new ExceptionHandledResult<Object>(result, (Collection<Exception>)exceptionCollection);
    }

    public void clearFinishedTasks() {
        HashSet removeFutureSet = new HashSet();
        for (Future<?> future : this.futureList) {
            if (future != null && !future.isDone()) continue;
            removeFutureSet.add(future);
        }
        this.futureList.removeAll(removeFutureSet);
    }

    public List<Future<?>> getFutureList() {
        return this.futureList;
    }

    public boolean hasExecutorService() {
        return this.executorService != null;
    }

    public boolean areAllTasksFinished() {
        boolean retval = true;
        for (Future<?> future : this.futureList) {
            if (future == null || future.isDone()) continue;
            retval = false;
            break;
        }
        return retval;
    }
}

