/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.threads;

import java.io.Serializable;
import org.omnaest.utils.assertion.Assert;

public abstract class RunnableDecorator
implements Runnable,
Serializable {
    private static final long serialVersionUID = -1445715278932243834L;
    protected final Runnable runnable;

    protected RunnableDecorator(Runnable runnable) {
        this.runnable = runnable;
        Assert.isNotNull((Object)runnable, "runnable must not be null to be used by the RunnableDecorator");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RunnableDecorator [runnable=");
        builder.append(this.runnable);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void run() {
        this.runnable.run();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.runnable == null ? 0 : this.runnable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunnableDecorator)) {
            return false;
        }
        RunnableDecorator other = (RunnableDecorator)obj;
        return !(this.runnable == null ? other.runnable != null : !this.runnable.equals(other.runnable));
    }
}

