/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.threads.submit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.omnaest.utils.structure.collection.list.BooleanList;
import org.omnaest.utils.threads.submit.Reducer;

class ReducerImpl<T>
implements Reducer<T> {
    private final Collection<T> resultCollection;

    ReducerImpl(Collection<T> resultCollection) {
        this.resultCollection = resultCollection;
    }

    @Override
    public List<T> reduceToList() {
        return Collections.unmodifiableList(new ArrayList<T>(this.resultCollection));
    }

    @Override
    public Set<T> reduceToSet() {
        return Collections.unmodifiableSet(new LinkedHashSet<T>(this.resultCollection));
    }

    @Override
    public <R> List<R> reduceToList(Reducer.ValueHandler<T, R> valueHandler) {
        ArrayList<R> retlist = new ArrayList<R>();
        if (valueHandler != null) {
            for (T value : this.resultCollection) {
                R result = valueHandler.reduce(value);
                retlist.add(result);
            }
        }
        return retlist;
    }

    @Override
    public <R> Set<R> reduceToSet(Reducer.ValueHandler<T, R> valueHandler) {
        LinkedHashSet<R> retset = new LinkedHashSet<R>();
        if (valueHandler != null) {
            for (T value : this.resultCollection) {
                R result = valueHandler.reduce(value);
                retset.add(result);
            }
        }
        return retset;
    }

    @Override
    public <R> R reduceToValue(Reducer.ValuesHandler<T, R> valuesHandler) {
        R retval = null;
        if (valuesHandler != null) {
            retval = valuesHandler.reduce(this.resultCollection);
        }
        return retval;
    }

    @Override
    public BooleanList reduceToBooleanValueList(Reducer.BooleanHandler<T> booleanHandler) {
        BooleanList retlist = new BooleanList(this.reduceToList(booleanHandler));
        return retlist;
    }

    @Override
    public Set<Boolean> reduceToBooleanValueSet(Reducer.BooleanHandler<T> booleanHandler) {
        return this.reduceToSet(booleanHandler);
    }

    @Override
    public boolean reduceToBooleanValue(Reducer.BooleansHandler<T> booleansHandler) {
        return booleansHandler != null && BooleanUtils.isTrue((Boolean)((Boolean)booleansHandler.reduce(this.resultCollection)));
    }

    @Override
    public boolean reduceToBooleanValue() {
        Reducer.BooleanHandler booleanHandler = new Reducer.BooleanHandler<T>(){

            @Override
            public Boolean reduce(T value) {
                return value instanceof Boolean && (Boolean)value != false;
            }
        };
        return this.reduceToBooleanValueList(booleanHandler).containsOnlyTrueValues();
    }
}

