/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.threads.submit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.structure.element.ObjectUtils;
import org.omnaest.utils.threads.submit.Reducer;
import org.omnaest.utils.threads.submit.ReducerImpl;
import org.omnaest.utils.threads.submit.SubmitGroup;
import org.omnaest.utils.threads.submit.Waiter;

class SubmitGroupImpl<T>
implements SubmitGroup<T> {
    private static final long serialVersionUID = 1369165651238494278L;
    private List<Future<T>> futureList = new ArrayList<Future<T>>();
    private final ExecutorService executorService;
    private final ExceptionHandler exceptionHandler;
    private final Collection<T> resultCollection;

    SubmitGroupImpl(ExecutorService executorService, ExceptionHandler exceptionHandler) {
        this.executorService = executorService;
        this.exceptionHandler = exceptionHandler;
        this.resultCollection = new ArrayList<T>();
    }

    SubmitGroupImpl(ExecutorService executorService, ExceptionHandler exceptionHandler, Collection<T> resultCollection) {
        this.executorService = executorService;
        this.exceptionHandler = exceptionHandler;
        this.resultCollection = ObjectUtils.defaultIfNull(resultCollection, new ArrayList());
    }

    @Override
    public SubmitGroup<T> submit(Callable<T> callable) {
        Future<T> future = this.executorService.submit(callable);
        this.futureList.add(future);
        return this;
    }

    @Override
    public SubmitGroup<T> submit(Callable<T> callable, int numberOfTimes) {
        for (int ii = 0; ii < numberOfTimes; ++ii) {
            this.submit(callable);
        }
        return this;
    }

    @Override
    public Waiter<T> doWait() {
        final ExceptionHandler exceptionHandler = this.exceptionHandler;
        final List<Future<T>> futureList = this.futureList;
        final Collection<T> resultCollection = this.resultCollection;
        return new Waiter<T>(){
            private static final long serialVersionUID = -7431148600723570701L;
            private final Reducer<T> reducer;
            {
                this.reducer = new ReducerImpl(resultCollection);
            }

            @Override
            public Reducer<T> untilAllTasksAreDone() {
                resultCollection.clear();
                for (Future future : futureList) {
                    this.tryResolveValue(exceptionHandler, future, resultCollection);
                }
                return this.reducer;
            }

            @Override
            public Reducer<T> anAmountOfTime(int amount, TimeUnit timeUnit) {
                try {
                    Thread.sleep(TimeUnit.MILLISECONDS.convert(amount, timeUnit));
                }
                catch (InterruptedException e) {
                    exceptionHandler.handleException(e);
                }
                return this.reducer;
            }

            @Override
            public Reducer<T> untilThePercentageOfTasksAreDone(double ratio) {
                int resultSizeMax = futureList.size();
                resultCollection.clear();
                for (Future future : futureList) {
                    this.tryResolveValue(exceptionHandler, future, resultCollection);
                    int resultSize = resultCollection.size();
                    double currentRatio = (double)resultSize * 1.0 / (double)resultSizeMax;
                    if (!(currentRatio >= ratio)) continue;
                    break;
                }
                return this.reducer;
            }

            @Override
            public Reducer<T> untilTheNumberOfTasksAreDone(int numberOfTasks) {
                resultCollection.clear();
                for (Future future : futureList) {
                    this.tryResolveValue(exceptionHandler, future, resultCollection);
                    int resultSize = resultCollection.size();
                    if (resultSize < numberOfTasks) continue;
                    break;
                }
                return this.reducer;
            }

            private void tryResolveValue(ExceptionHandler exceptionHandler2, Future<T> future, Collection<T> resultCollection2) {
                try {
                    boolean done = false;
                    while (!done) {
                        try {
                            Object result = future.get();
                            resultCollection2.add(result);
                            done = true;
                        }
                        catch (InterruptedException e) {
                            exceptionHandler2.handleException(e);
                        }
                    }
                }
                catch (Exception e) {
                    exceptionHandler2.handleException(e);
                }
            }
        };
    }
}

