/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.omnaest.utils.strings.StringUtils;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.element.converter.ElementConverterObjectToString;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DurationCapture
implements Serializable {
    public static final Object INTERVAL_DEFAULTKEY = "DEFAULT";
    private static final long serialVersionUID = 6433066272269919387L;
    private static final String DEFAULT_LINESEPARATOR = System.getProperty("line.separator");
    protected final Map<Object, Interval> intervalKeyToIntervalMap = new ConcurrentHashMap<Object, Interval>();
    public static Class<? extends DurationCapture> implementationForDurationClass = DurationCapture.class;

    public DurationCapture startTimeMeasurement(Object intervalKey) {
        this.determineInterval(intervalKey).startMeasurement();
        return this;
    }

    protected Interval determineInterval(Object key) {
        Interval retval = null;
        if (key == null) {
            key = this;
        }
        if (!this.intervalKeyToIntervalMap.containsKey(key)) {
            this.intervalKeyToIntervalMap.put(key, new Interval().setKey(key));
        }
        retval = this.intervalKeyToIntervalMap.get(key);
        return retval;
    }

    public DurationCapture startTimeMeasurement() {
        this.determineInterval(INTERVAL_DEFAULTKEY).startMeasurement();
        return this;
    }

    public void resetTimer() {
        this.determineInterval(INTERVAL_DEFAULTKEY).reset();
    }

    public void resetTimers() {
        for (Object intervalKey : this.intervalKeyToIntervalMap.keySet()) {
            Interval interval = this.intervalKeyToIntervalMap.get(intervalKey);
            interval.reset();
        }
    }

    public DurationCapture stopTimeMeasurement() {
        this.determineInterval(INTERVAL_DEFAULTKEY).stopMeasurement();
        return this;
    }

    public DurationCapture stopTimeMeasurement(Object intervalKey) {
        this.determineInterval(intervalKey).stopMeasurement();
        return this;
    }

    protected Map<Object, IntervalStatistic> calculateIntervalStatisticMap() {
        LinkedHashMap<Object, IntervalStatistic> retmap = new LinkedHashMap<Object, IntervalStatistic>();
        long durationInMillisecondsSum = 0L;
        for (Object intervalKey : this.intervalKeyToIntervalMap.keySet()) {
            Interval interval = this.intervalKeyToIntervalMap.get(intervalKey);
            if (interval.getKey() == INTERVAL_DEFAULTKEY) continue;
            long durationInMilliseconds = interval.getDurationInMilliseconds();
            durationInMillisecondsSum += durationInMilliseconds;
        }
        ArrayList<Object> intervalKeyList = new ArrayList<Object>(this.intervalKeyToIntervalMap.keySet());
        Collections.sort(intervalKeyList, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return String.valueOf(o1).compareTo(String.valueOf(o2));
            }
        });
        for (Object e : intervalKeyList) {
            Interval interval = this.intervalKeyToIntervalMap.get(e);
            IntervalStatistic intervalStatistic = new IntervalStatistic();
            long durationInMilliseconds = interval.getDurationInMilliseconds();
            double durationPercentage = (double)durationInMilliseconds * 100.0 / (double)durationInMillisecondsSum;
            intervalStatistic.setDurationPercentage(durationPercentage);
            intervalStatistic.setInterval(interval);
            intervalStatistic.setDurationInMilliseconds(durationInMilliseconds);
            retmap.put(interval.getKey(), intervalStatistic);
        }
        return retmap;
    }

    public long getDurationInMilliseconds() {
        return this.getDurationInMilliseconds(INTERVAL_DEFAULTKEY);
    }

    public long getDuration(TimeUnit timeUnit) {
        if (timeUnit == null) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        return timeUnit.convert(this.getDurationInMilliseconds(), TimeUnit.MILLISECONDS);
    }

    public long getDurationInMilliseconds(Object intervalKey) {
        return this.determineInterval(intervalKey).getDurationInMilliseconds();
    }

    public long getDuration(Object intervalKey, TimeUnit timeUnit) {
        if (timeUnit == null) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        return timeUnit.convert(this.getDurationInMilliseconds(intervalKey), TimeUnit.MILLISECONDS);
    }

    public long getDurationInMilliseconds(Object ... intervalKeys) {
        long retval = 0L;
        if (intervalKeys.length > 0) {
            for (Object intervalKey : intervalKeys) {
                retval += this.getDurationInMilliseconds(intervalKey);
            }
        } else {
            retval = this.getDurationInMilliseconds();
        }
        return retval;
    }

    public long getDuration(TimeUnit timeUnit, Object ... intervalKeys) {
        if (timeUnit == null) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        return timeUnit.convert(this.getDurationInMilliseconds(intervalKeys), TimeUnit.MILLISECONDS);
    }

    public long getInterimTimeInMilliseconds() {
        return this.getInterimTimeInMilliseconds(INTERVAL_DEFAULTKEY);
    }

    public long getInterimTime(TimeUnit timeUnit) {
        if (timeUnit == null) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        return timeUnit.convert(this.getInterimTimeInMilliseconds(), TimeUnit.MILLISECONDS);
    }

    public long getInterimTimeInMilliseconds(Object intervalKey) {
        return this.determineInterval(intervalKey).getInterimTimeInMilliseconds();
    }

    public long getInterimTime(Object intervalKey, TimeUnit timeUnit) {
        if (timeUnit == null) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        return timeUnit.convert(this.getInterimTimeInMilliseconds(intervalKey), TimeUnit.MILLISECONDS);
    }

    public long getInterimTimeInMilliseconds(Object ... intervalKeys) {
        long retval = 0L;
        if (intervalKeys.length > 0) {
            for (Object intervalKey : intervalKeys) {
                retval += this.getInterimTimeInMilliseconds(intervalKey);
            }
        } else {
            retval = this.getInterimTimeInMilliseconds();
        }
        return retval;
    }

    public long getInterimTime(TimeUnit timeUnit, Object ... intervalKeys) {
        if (timeUnit == null) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        return timeUnit.convert(this.getInterimTimeInMilliseconds(intervalKeys), TimeUnit.MILLISECONDS);
    }

    protected boolean hasDefaultInterval() {
        return this.intervalKeyToIntervalMap.containsKey(INTERVAL_DEFAULTKEY);
    }

    public String calculateIntervalStatisticLogMessage() {
        String retval = null;
        Map<Object, IntervalStatistic> intervalStatisticMap = this.calculateIntervalStatisticMap();
        int maximumWidth = Math.max(20, StringUtils.maximumWidth(ListUtils.convert(intervalStatisticMap.keySet(), new ElementConverterObjectToString())));
        String lineSeparator = StringUtils.repeat("-", maximumWidth + 35) + DEFAULT_LINESEPARATOR;
        String ROW_FORMAT_STRING = "%-" + maximumWidth + "s : %5d ms (%6.2f%%) %s %n";
        StringBuffer sb = new StringBuffer();
        if (intervalStatisticMap.containsKey(INTERVAL_DEFAULTKEY)) {
            IntervalStatistic intervalStatistic = intervalStatisticMap.get(INTERVAL_DEFAULTKEY);
            String intervalKeyAsString = intervalStatistic.getIntervalKeyAsString();
            long durationInMilliseconds = intervalStatistic.getDurationInMilliseconds();
            double durationPercentage = intervalStatistic.getDurationPercentage();
            String percentageBar = StringUtils.percentageBar(durationPercentage * 0.01, 12);
            sb.append(lineSeparator);
            sb.append(String.format(ROW_FORMAT_STRING, intervalKeyAsString, durationInMilliseconds, durationPercentage, percentageBar));
            intervalStatisticMap.remove(INTERVAL_DEFAULTKEY);
        }
        long intervalDurationTimeSum = 0L;
        if (intervalStatisticMap.size() > 0) {
            sb.append(lineSeparator);
            for (Object intervalKey : intervalStatisticMap.keySet()) {
                IntervalStatistic intervalStatistic = intervalStatisticMap.get(intervalKey);
                String intervalKeyAsString = intervalStatistic.getIntervalKeyAsString();
                long durationInMilliseconds = intervalStatistic.getDurationInMilliseconds();
                double durationPercentage = intervalStatistic.getDurationPercentage();
                String percentageBar = StringUtils.percentageBar(durationPercentage * 0.01, 12);
                sb.append(String.format(ROW_FORMAT_STRING, intervalKeyAsString, durationInMilliseconds, durationPercentage, percentageBar));
                intervalDurationTimeSum += intervalStatistic.getDurationInMilliseconds();
            }
        }
        if (intervalStatisticMap.size() > 1) {
            sb.append(lineSeparator);
            sb.append("Whole interval key duration time: " + intervalDurationTimeSum + " ms\n");
        }
        sb.append(lineSeparator);
        retval = sb.toString();
        return retval;
    }

    public List<Object> getIntervalKeyList() {
        return new ArrayList<Object>(this.intervalKeyToIntervalMap.keySet());
    }

    public Map<Object, Long> getIntervalKeyToDurationInMillisecondsMap() {
        LinkedHashMap<Object, Long> retmap = new LinkedHashMap<Object, Long>();
        for (Object intervalKey : this.getIntervalKeyList()) {
            retmap.put(intervalKey, this.getDurationInMilliseconds(intervalKey));
        }
        return retmap;
    }

    public Map<Object, Long> getIntervalKeyToDurationMap(TimeUnit timeUnit) {
        LinkedHashMap<Object, Long> retmap = new LinkedHashMap<Object, Long>();
        for (Object intervalKey : this.getIntervalKeyList()) {
            retmap.put(intervalKey, this.getDuration(intervalKey, timeUnit));
        }
        return retmap;
    }

    public static DurationCapture newInstance() {
        DurationCapture result = null;
        try {
            result = implementationForDurationClass.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String toString() {
        return this.calculateIntervalStatisticLogMessage();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    protected static class IntervalStatistic
    implements Serializable {
        private static final long serialVersionUID = -5081536693492826365L;
        protected Interval interval = null;
        protected long durationInMilliseconds = 0L;
        protected double durationPercentage = 0.0;

        protected IntervalStatistic() {
        }

        public Interval getInterval() {
            return this.interval;
        }

        public void setInterval(Interval interval) {
            this.interval = interval;
        }

        public String getIntervalKeyAsString() {
            return String.valueOf(this.interval.getKey());
        }

        public double getDurationPercentage() {
            return this.durationPercentage;
        }

        public void setDurationPercentage(double durationPercentage) {
            this.durationPercentage = durationPercentage;
        }

        public long getDurationInMilliseconds() {
            return this.durationInMilliseconds;
        }

        public void setDurationInMilliseconds(long durationInMilliseconds) {
            this.durationInMilliseconds = durationInMilliseconds;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Interval
    implements Serializable {
        private static final long serialVersionUID = -2883159459488305456L;
        protected Object key = null;
        protected long duration = 0L;
        protected long startTime = 0L;
        protected long stopTime = 0L;

        public long getInterimTimeInMilliseconds() {
            return System.currentTimeMillis() - this.startTime;
        }

        public void startMeasurement() {
            this.startTime = System.currentTimeMillis();
        }

        public void stopMeasurement() {
            this.stopTime = System.currentTimeMillis();
            this.calculateDurationInMilliseconds();
        }

        public void reset() {
            this.duration = 0L;
        }

        protected void calculateDurationInMilliseconds() {
            this.duration += this.stopTime - this.startTime;
        }

        protected Interval setKey(Object key) {
            this.key = key;
            return this;
        }

        public long getDurationInMilliseconds() {
            return this.duration;
        }

        public Object getKey() {
            return this.key;
        }
    }
}

