/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.time;

import java.lang.reflect.Method;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.omnaest.utils.proxy.StubCreator;
import org.omnaest.utils.time.DurationCapture;

public class DurationCaptureTypeFactory {
    public static <E> E newStubInstance(E object) {
        E retval = null;
        if (object != null) {
            Class<?> objectClass = object.getClass();
            MethodInterceptorDurationCapture methodInterceptor = new MethodInterceptorDurationCapture();
            retval = (E)StubCreator.newStubInstance(objectClass, new Class[]{DurationCaptureAware.class}, methodInterceptor);
        }
        return retval;
    }

    protected static class MethodInterceptorDurationCapture
    implements MethodInterceptor {
        protected DurationCapture durationCapture = DurationCapture.newInstance();

        protected MethodInterceptorDurationCapture() {
        }

        public Object intercept(Object object, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            Object retval = null;
            String methodName = method.getName();
            DurationCapture durationCapture = this.durationCapture;
            if ("getDurationCapture".equals(methodName)) {
                retval = durationCapture;
            } else {
                durationCapture.startTimeMeasurement(methodName);
                retval = proxy.invokeSuper(object, args);
                durationCapture.stopTimeMeasurement(methodName);
            }
            return retval;
        }
    }

    public static interface DurationCaptureAware {
        public DurationCapture getDurationCapture();
    }
}

