/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.xml;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.reflection.ReflectionUtils;
import org.omnaest.utils.structure.container.ByteArrayContainer;
import org.omnaest.utils.structure.element.ObjectUtils;
import org.omnaest.utils.xml.exception.MissingXMLRootElementAnnotationException;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class JAXBXMLHelper {
    public static final String DEFAULT_ENCODING = "utf-8";

    public static void storeObjectAsXML(Object object, OutputStream outputStream) {
        String encoding = DEFAULT_ENCODING;
        JAXBXMLHelper.storeObjectAsXML(object, outputStream, encoding);
    }

    public static void storeObjectAsXML(Object object, OutputStream outputStream, ExceptionHandler exceptionHandler) {
        String encoding = DEFAULT_ENCODING;
        JAXBXMLHelper.storeObjectAsXML(object, outputStream, encoding, exceptionHandler);
    }

    public static void storeObjectAsXML(Object object, OutputStream outputStream, String encoding) {
        ExceptionHandler exceptionHandler = null;
        JAXBXMLHelper.storeObjectAsXML(object, outputStream, encoding, exceptionHandler);
    }

    public static void storeObjectAsXML(Object object, OutputStream outputStream, String encoding, ExceptionHandler exceptionHandler) {
        MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
        marshallingConfiguration.setEncoding(encoding);
        marshallingConfiguration.setExceptionHandler(exceptionHandler);
        JAXBXMLHelper.storeObjectAsXML(object, outputStream, marshallingConfiguration);
    }

    public static void storeObjectAsXML(Object object, OutputStream outputStream, MarshallingConfiguration marshallingConfiguration) {
        block3: {
            marshallingConfiguration = MarshallingConfiguration.defaultMarshallingConfiguration(marshallingConfiguration);
            String encoding = marshallingConfiguration.getEncoding();
            ExceptionHandler exceptionHandler = marshallingConfiguration.getExceptionHandler();
            Object[] knownTypes = marshallingConfiguration.getKnownTypes();
            boolean formattingOutput = marshallingConfiguration.isFormattingOutput();
            MarshallingConfiguration.Configurator configurator = ObjectUtils.defaultIfNull(marshallingConfiguration.getConfigurator(), new MarshallingConfiguration.Configurator(){});
            try {
                Class<?> objectType = object.getClass();
                Object[] contextTypes = !(object instanceof JAXBElement) ? (Class[])ArrayUtils.add((Object[])knownTypes, objectType) : (knownTypes != null ? knownTypes : new Class[]{});
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])contextTypes);
                configurator.configure(jaxbContext);
                Marshaller marshaller = jaxbContext.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)formattingOutput);
                if (encoding != null) {
                    marshaller.setProperty("jaxb.encoding", (Object)encoding);
                }
                configurator.configure(marshaller);
                marshaller.marshal(object, outputStream);
                outputStream.flush();
            }
            catch (Exception e) {
                if (exceptionHandler == null) break block3;
                exceptionHandler.handleException(e);
            }
        }
    }

    public static void storeObjectAsXML(Object object, Appendable appendable) {
        String encoding = DEFAULT_ENCODING;
        JAXBXMLHelper.storeObjectAsXML(object, appendable, DEFAULT_ENCODING);
    }

    public static void storeObjectAsXML(Object object, Appendable appendable, String encoding) {
        if (object != null && appendable != null) {
            ByteArrayContainer byteArrayContainer = new ByteArrayContainer();
            JAXBXMLHelper.storeObjectAsXML(object, byteArrayContainer.getOutputStream(), encoding);
            byteArrayContainer.writeTo(appendable, encoding);
        }
    }

    public static String storeObjectAsXML(Object object) {
        return JAXBXMLHelper.storeObjectAsXML(object, DEFAULT_ENCODING);
    }

    public static String storeObjectAsXML(Object object, MarshallingConfiguration marshallingConfiguration) {
        ByteArrayContainer byteArrayContainer;
        String encoding;
        block2: {
            marshallingConfiguration = MarshallingConfiguration.defaultMarshallingConfiguration(marshallingConfiguration);
            ExceptionHandler exceptionHandler = marshallingConfiguration.getExceptionHandler();
            encoding = marshallingConfiguration.getEncoding();
            byteArrayContainer = new ByteArrayContainer();
            OutputStream outputStream = byteArrayContainer.getOutputStream();
            try {
                JAXBXMLHelper.storeObjectAsXML(object, outputStream, marshallingConfiguration);
                outputStream.close();
            }
            catch (Exception e) {
                if (exceptionHandler == null) break block2;
                exceptionHandler.handleException(e);
            }
        }
        return byteArrayContainer.toString(encoding);
    }

    public static String storeObjectAsXML(Object object, ExceptionHandler exceptionHandler) {
        return JAXBXMLHelper.storeObjectAsXML(object, DEFAULT_ENCODING, exceptionHandler);
    }

    public static String storeObjectAsXML(Object object, String encoding) {
        ByteArrayContainer byteArrayContainer = new ByteArrayContainer();
        JAXBXMLHelper.storeObjectAsXML(object, byteArrayContainer.getOutputStream(), encoding);
        return byteArrayContainer.toString(encoding);
    }

    public static String storeObjectAsXML(Object object, String encoding, ExceptionHandler exceptionHandler) {
        ByteArrayContainer byteArrayContainer = new ByteArrayContainer();
        JAXBXMLHelper.storeObjectAsXML(object, byteArrayContainer.getOutputStream(), encoding, exceptionHandler);
        return byteArrayContainer.toString(encoding);
    }

    public static <E> E loadObjectFromXML(InputStream inputStream, Class<E> typeClazz) {
        ExceptionHandler exceptionHandler = null;
        return JAXBXMLHelper.loadObjectFromXML(inputStream, typeClazz, exceptionHandler);
    }

    public static <E> E loadObjectFromXML(InputStream inputStream, Class<E> type, ExceptionHandler exceptionHandler) {
        UnmarshallingConfiguration unmarshallingConfiguration = new UnmarshallingConfiguration();
        unmarshallingConfiguration.setExceptionHandler(exceptionHandler);
        return JAXBXMLHelper.loadObjectFromXML(inputStream, type, unmarshallingConfiguration);
    }

    public static <E> JAXBContextBasedUnmarshaller<E> newJAXBContextBasedUnmarshaller(Class<E> type, UnmarshallingConfiguration unmarshallingConfiguration) {
        JAXBContextBasedUnmarshaller<E> retval;
        block5: {
            retval = null;
            unmarshallingConfiguration = UnmarshallingConfiguration.defaultUnmarshallingConfiguration(unmarshallingConfiguration);
            ExceptionHandler exceptionHandler = unmarshallingConfiguration.getExceptionHandler();
            Object[] knownTypes = unmarshallingConfiguration.getKnownTypes();
            String encoding = unmarshallingConfiguration.getEncoding();
            UnmarshallingConfiguration.Configurator configurator = unmarshallingConfiguration.getConfigurator();
            try {
                Class[] contextTypes = (Class[])ArrayUtils.add((Object[])knownTypes, type);
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])contextTypes);
                if (configurator != null) {
                    configurator.configure(jaxbContext);
                }
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                if (configurator != null) {
                    configurator.configure(unmarshaller);
                }
                SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                saxParserFactory.setNamespaceAware(true);
                if (configurator != null) {
                    configurator.configure(saxParserFactory);
                }
                XMLReader xmlReader = saxParserFactory.newSAXParser().getXMLReader();
                retval = new JAXBContextBasedUnmarshaller<E>(unmarshaller, xmlReader, exceptionHandler, encoding, type);
            }
            catch (Exception e) {
                if (exceptionHandler == null) break block5;
                exceptionHandler.handleException(e);
            }
        }
        return retval;
    }

    public static <E> E loadObjectFromXML(InputStream inputStream, Class<E> type, UnmarshallingConfiguration unmarshallingConfiguration) {
        E retval;
        block2: {
            retval = null;
            try {
                JAXBContextBasedUnmarshaller<E> jaxbContextBasedUnmarshaller = JAXBXMLHelper.newJAXBContextBasedUnmarshaller(type, unmarshallingConfiguration);
                retval = jaxbContextBasedUnmarshaller.unmarshal(inputStream);
            }
            catch (Exception e) {
                ExceptionHandler exceptionHandler = unmarshallingConfiguration.getExceptionHandler();
                if (exceptionHandler == null) break block2;
                exceptionHandler.handleException(e);
            }
        }
        return retval;
    }

    public static <E> E loadObjectFromNode(Node node, Class<E> type) {
        ExceptionHandler exceptionHandler = null;
        return JAXBXMLHelper.loadObjectFromNode(node, type, exceptionHandler);
    }

    public static <E> E loadObjectFromNode(Node node, Class<E> type, ExceptionHandler exceptionHandler) {
        Object retval;
        block2: {
            retval = null;
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{type});
                Unmarshaller um = context.createUnmarshaller();
                retval = um.unmarshal(node);
            }
            catch (Exception e) {
                if (exceptionHandler == null) break block2;
                exceptionHandler.handleException(e);
            }
        }
        return (E)retval;
    }

    public static <E> E loadObjectFromXML(CharSequence charSequence, Class<E> type) {
        ExceptionHandler exceptionHandler = null;
        return JAXBXMLHelper.loadObjectFromXML(charSequence, type, exceptionHandler);
    }

    public static <E> E loadObjectFromXML(CharSequence charSequence, Class<E> type, ExceptionHandler exceptionHandler) {
        ByteArrayContainer byteArrayContainer = new ByteArrayContainer();
        byteArrayContainer.copyFrom(charSequence);
        return JAXBXMLHelper.loadObjectFromXML(byteArrayContainer.getInputStream(), type, exceptionHandler);
    }

    public static <E> E loadObjectFromXML(CharSequence charSequence, Class<E> type, UnmarshallingConfiguration unmarshallingConfiguration) {
        unmarshallingConfiguration = UnmarshallingConfiguration.defaultUnmarshallingConfiguration(unmarshallingConfiguration);
        String encoding = unmarshallingConfiguration.getEncoding();
        ByteArrayContainer byteArrayContainer = new ByteArrayContainer();
        byteArrayContainer.copyFrom(charSequence, encoding);
        return JAXBXMLHelper.loadObjectFromXML(byteArrayContainer.getInputStream(), type, unmarshallingConfiguration);
    }

    public static <E> E loadObjectFromXML(String xmlContent, Class<E> typeClazz) {
        ExceptionHandler exceptionHandler = null;
        return JAXBXMLHelper.loadObjectFromXML(xmlContent, typeClazz, exceptionHandler);
    }

    public static <E> E loadObjectFromXML(String xmlContent, Class<E> type, ExceptionHandler exceptionHandler) {
        ByteArrayContainer byteArrayContainer = new ByteArrayContainer();
        byteArrayContainer.copyFrom(xmlContent);
        return JAXBXMLHelper.loadObjectFromXML(byteArrayContainer.getInputStream(), type, exceptionHandler);
    }

    public static <E> E cloneObject(E object) {
        MarshallingConfiguration marshallingConfiguration = null;
        return JAXBXMLHelper.cloneObject(object, marshallingConfiguration);
    }

    public static <E> E cloneObject(E object, MarshallingConfiguration marshallingConfiguration) {
        E retval;
        block3: {
            retval = null;
            marshallingConfiguration = MarshallingConfiguration.defaultMarshallingConfiguration(marshallingConfiguration);
            ExceptionHandler exceptionHandler = marshallingConfiguration.getExceptionHandler();
            if (object != null) {
                try {
                    ByteArrayContainer byteArrayContainer = new ByteArrayContainer();
                    OutputStream outputStream = byteArrayContainer.getOutputStream();
                    JAXBXMLHelper.storeObjectAsXML(object, outputStream, marshallingConfiguration);
                    outputStream.close();
                    retval = (E)JAXBXMLHelper.loadObjectFromXML(byteArrayContainer.getInputStream(), object.getClass(), marshallingConfiguration.asUnmarshallingConfiguration());
                }
                catch (Exception e) {
                    if (exceptionHandler == null) break block3;
                    exceptionHandler.handleException(e);
                }
            }
        }
        return retval;
    }

    public static QName determineRootName(Class<?> type) {
        String selectingTagName = null;
        String selectingNamespace = null;
        Assert.isNotNull(type, "type must not be null");
        XmlRootElement xmlRootElement = ReflectionUtils.annotation(type, XmlRootElement.class);
        if (xmlRootElement == null) {
            throw new MissingXMLRootElementAnnotationException();
        }
        String tagName = xmlRootElement.name();
        selectingTagName = tagName != null && !StringUtils.equalsIgnoreCase((CharSequence)tagName, (CharSequence)"##default") ? tagName : StringUtils.lowerCase((String)type.getSimpleName());
        String namespace = xmlRootElement.namespace();
        if (StringUtils.equalsIgnoreCase((CharSequence)namespace, (CharSequence)"##default")) {
            namespace = null;
            XmlSchema xmlSchema = ReflectionUtils.annotation(type.getPackage(), XmlSchema.class);
            if (xmlSchema != null) {
                namespace = xmlSchema.namespace();
            }
        }
        selectingNamespace = namespace;
        QName qName = new QName(selectingNamespace, selectingTagName);
        return qName;
    }

    public static class JAXBContextBasedUnmarshaller<E> {
        private final Unmarshaller unmarshaller;
        private final XMLReader xmlReader;
        private final ExceptionHandler exceptionHandler;
        private final String encoding;
        private final Class<E> type;

        public JAXBContextBasedUnmarshaller(Unmarshaller unmarshaller, XMLReader xmlReader, ExceptionHandler exceptionHandler, String encoding, Class<E> type) {
            this.unmarshaller = unmarshaller;
            this.xmlReader = xmlReader;
            this.exceptionHandler = exceptionHandler;
            this.encoding = encoding;
            this.type = type;
        }

        public E unmarshal(InputStream inputStream) {
            Object retval;
            block2: {
                retval = null;
                try {
                    InputStreamReader reader = new InputStreamReader(inputStream, this.encoding);
                    InputSource inputSource = new InputSource(reader);
                    SAXSource saxSource = new SAXSource(this.xmlReader, inputSource);
                    retval = this.unmarshaller.unmarshal((Source)saxSource);
                }
                catch (Exception e) {
                    if (this.exceptionHandler == null) break block2;
                    this.exceptionHandler.handleException(e);
                }
            }
            return (E)retval;
        }

        public JAXBElement<E> unmarshalAsJAXBElement(InputStream inputStream) {
            JAXBElement retval;
            block2: {
                retval = null;
                try {
                    InputStreamReader reader = new InputStreamReader(inputStream, this.encoding);
                    InputSource inputSource = new InputSource(reader);
                    SAXSource saxSource = new SAXSource(this.xmlReader, inputSource);
                    retval = this.unmarshaller.unmarshal((Source)saxSource, this.type);
                }
                catch (Exception e) {
                    if (this.exceptionHandler == null) break block2;
                    this.exceptionHandler.handleException(e);
                }
            }
            return retval;
        }

        public E unmarshal(XMLEventReader xmlEventReader) {
            Object retval;
            block2: {
                retval = null;
                try {
                    retval = this.unmarshaller.unmarshal(xmlEventReader);
                }
                catch (Exception e) {
                    if (this.exceptionHandler == null) break block2;
                    this.exceptionHandler.handleException(e);
                }
            }
            return (E)retval;
        }
    }

    public static class MarshallingConfiguration
    extends MarshallingAndUnmarshallingConfigurationAbstractBase {
        private boolean formattingOutput = true;
        private Configurator configurator = null;

        public boolean isFormattingOutput() {
            return this.formattingOutput;
        }

        public MarshallingConfiguration setFormattingOutput(boolean formattingOutput) {
            this.formattingOutput = formattingOutput;
            return this;
        }

        public static MarshallingConfiguration defaultMarshallingConfiguration(MarshallingConfiguration marshallingConfiguration) {
            return marshallingConfiguration == null ? new MarshallingConfiguration() : marshallingConfiguration;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MarshallingConfiguration [formattingOutput=");
            builder.append(this.formattingOutput);
            builder.append(", encoding=");
            builder.append(this.encoding);
            builder.append(", exceptionHandler=");
            builder.append(this.exceptionHandler);
            builder.append(", knownTypes=");
            builder.append(Arrays.toString(this.knownTypes));
            builder.append("]");
            return builder.toString();
        }

        public UnmarshallingConfiguration asUnmarshallingConfiguration() {
            return new UnmarshallingConfiguration(this.encoding, this.exceptionHandler, this.knownTypes);
        }

        @Override
        public MarshallingConfiguration setEncoding(String encoding) {
            super.setEncoding(encoding);
            return this;
        }

        @Override
        public MarshallingConfiguration setExceptionHandler(ExceptionHandler exceptionHandler) {
            super.setExceptionHandler(exceptionHandler);
            return this;
        }

        @Override
        public MarshallingConfiguration setKnownTypes(Class<?> ... knownTypes) {
            super.setKnownTypes(knownTypes);
            return this;
        }

        public Configurator getConfigurator() {
            return this.configurator;
        }

        public MarshallingConfiguration setConfigurator(Configurator configurator) {
            this.configurator = configurator;
            return this;
        }

        public static abstract class Configurator {
            public void configure(Marshaller marshaller) throws Exception {
            }

            public void configure(JAXBContext jaxbContext) throws Exception {
            }
        }
    }

    public static class UnmarshallingConfiguration
    extends MarshallingAndUnmarshallingConfigurationAbstractBase {
        private Configurator configurator = null;

        public UnmarshallingConfiguration() {
        }

        public UnmarshallingConfiguration(String encoding, ExceptionHandler exceptionHandler, Class<?>[] knownTypes) {
            super(encoding, exceptionHandler, knownTypes);
        }

        public static UnmarshallingConfiguration defaultUnmarshallingConfiguration(UnmarshallingConfiguration unmarshallingConfiguration) {
            return unmarshallingConfiguration == null ? new UnmarshallingConfiguration() : unmarshallingConfiguration;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("UnmarshallingConfiguration [configurator=");
            builder.append(this.configurator);
            builder.append(", encoding=");
            builder.append(this.encoding);
            builder.append(", exceptionHandler=");
            builder.append(this.exceptionHandler);
            builder.append(", knownTypes=");
            builder.append(Arrays.toString(this.knownTypes));
            builder.append("]");
            return builder.toString();
        }

        @Override
        public UnmarshallingConfiguration setEncoding(String encoding) {
            super.setEncoding(encoding);
            return this;
        }

        @Override
        public UnmarshallingConfiguration setExceptionHandler(ExceptionHandler exceptionHandler) {
            super.setExceptionHandler(exceptionHandler);
            return this;
        }

        @Override
        public UnmarshallingConfiguration setKnownTypes(Class<?> ... knownTypes) {
            super.setKnownTypes(knownTypes);
            return this;
        }

        public UnmarshallingConfiguration setConfigurator(Configurator configurator) {
            this.configurator = configurator;
            return this;
        }

        public Configurator getConfigurator() {
            return this.configurator;
        }

        public static abstract class Configurator {
            public void configure(SAXParserFactory saxParserFactory) throws Exception {
            }

            public void configure(Unmarshaller unmarshaller) throws Exception {
            }

            public void configure(JAXBContext jaxbContext) throws Exception {
            }
        }
    }

    protected static abstract class MarshallingAndUnmarshallingConfigurationAbstractBase {
        protected String encoding = "utf-8";
        protected ExceptionHandler exceptionHandler = null;
        protected Class<?>[] knownTypes = null;

        public String getEncoding() {
            return this.encoding;
        }

        protected MarshallingAndUnmarshallingConfigurationAbstractBase() {
        }

        protected MarshallingAndUnmarshallingConfigurationAbstractBase(String encoding, ExceptionHandler exceptionHandler, Class<?>[] knownTypes) {
            this.encoding = encoding;
            this.exceptionHandler = exceptionHandler;
            this.knownTypes = knownTypes;
        }

        public MarshallingAndUnmarshallingConfigurationAbstractBase setEncoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public ExceptionHandler getExceptionHandler() {
            return this.exceptionHandler;
        }

        public MarshallingAndUnmarshallingConfigurationAbstractBase setExceptionHandler(ExceptionHandler exceptionHandler) {
            this.exceptionHandler = exceptionHandler;
            return this;
        }

        public Class<?>[] getKnownTypes() {
            return this.knownTypes;
        }

        public MarshallingAndUnmarshallingConfigurationAbstractBase setKnownTypes(Class<?> ... knownTypes) {
            this.knownTypes = knownTypes;
            return this;
        }
    }
}

