/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.xml;

import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.xml.XMLNestedMapConverter;
import org.w3c.dom.Node;

public class XMLHelper {
    public static Node select(String xPathExpression, Node node) {
        ExceptionHandler exceptionHandler = null;
        return XMLHelper.select(xPathExpression, node, exceptionHandler);
    }

    public static Node select(String xPathExpression, Node node, ExceptionHandler exceptionHandler) {
        Node retval;
        block2: {
            retval = null;
            XPath xPath = XPathFactory.newInstance().newXPath();
            try {
                retval = (Node)xPath.evaluate(xPathExpression, node, XPathConstants.NODE);
            }
            catch (XPathExpressionException e) {
                if (exceptionHandler == null) break block2;
                exceptionHandler.handleException(e);
            }
        }
        return retval;
    }

    public static Map<String, Object> newMapFromXML(CharSequence xmlContent) {
        return new XMLNestedMapConverter().newMapFromXML(xmlContent);
    }

    public static void transform(StreamSource xslt, StreamSource xml, StreamResult result, ExceptionHandler exceptionHandler, XSLTransformerConfiguration xslTransformerConfiguration) {
        block9: {
            try {
                Map<String, Object> attributeMap;
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                if (xslTransformerConfiguration != null && (attributeMap = xslTransformerConfiguration.getAttributeMap()) != null) {
                    for (String name : attributeMap.keySet()) {
                        Object value = attributeMap.get(name);
                        transformerFactory.setAttribute(name, value);
                    }
                }
                Transformer transformer = transformerFactory.newTransformer(xslt);
                if (xslTransformerConfiguration != null) {
                    Map<String, Object> parameterMap;
                    Map<String, String> outputPropertyMap = xslTransformerConfiguration.getOutputPropertyMap();
                    if (outputPropertyMap != null) {
                        for (String name : outputPropertyMap.keySet()) {
                            String value = outputPropertyMap.get(name);
                            transformer.setOutputProperty(name, value);
                        }
                    }
                    if ((parameterMap = xslTransformerConfiguration.getParameterMap()) != null) {
                        for (String name : parameterMap.keySet()) {
                            Object value = parameterMap.get(name);
                            transformer.setParameter(name, value);
                        }
                    }
                }
                transformer.transform(xml, result);
            }
            catch (Exception e) {
                if (exceptionHandler == null) break block9;
                exceptionHandler.handleException(e);
            }
        }
    }

    public static class XSLTransformerConfiguration {
        private final Map<String, Object> attributeMap = new HashMap<String, Object>();
        private final Map<String, String> outputPropertyMap = new HashMap<String, String>();
        private final Map<String, Object> parameterMap = new HashMap<String, Object>();

        public XSLTransformerConfiguration addAttribute(String key, Object value) {
            this.attributeMap.put(key, value);
            return this;
        }

        public XSLTransformerConfiguration addParameter(String key, Object value) {
            this.parameterMap.put(key, value);
            return this;
        }

        public XSLTransformerConfiguration addOutputProperty(String key, String value) {
            this.outputPropertyMap.put(key, value);
            return this;
        }

        protected Map<String, Object> getAttributeMap() {
            return this.attributeMap;
        }

        protected Map<String, String> getOutputPropertyMap() {
            return this.outputPropertyMap;
        }

        protected Map<String, Object> getParameterMap() {
            return this.parameterMap;
        }
    }
}

