/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.xml;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.events.exception.basic.ExceptionHandlerIgnoring;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.container.ByteArrayContainer;
import org.omnaest.utils.structure.element.ElementHolder;
import org.omnaest.utils.structure.element.accessor.Accessor;
import org.omnaest.utils.structure.element.accessor.adapter.ThreadLocalToAccessorAdapter;
import org.omnaest.utils.structure.element.cached.CachedElement;
import org.omnaest.utils.structure.element.cached.ThreadLocalCachedElement;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.element.converter.ElementConverterIdentitiyCast;
import org.omnaest.utils.structure.element.factory.Factory;
import org.omnaest.utils.structure.iterator.IterableUtils;
import org.omnaest.utils.structure.iterator.IteratorUtils;
import org.omnaest.utils.structure.map.MapUtils;
import org.omnaest.utils.xml.JAXBXMLHelper;
import org.omnaest.utils.xml.XMLNestedMapConverter;
import org.omnaest.utils.xml.context.XMLInstanceContextFactory;
import org.omnaest.utils.xml.context.XMLInstanceContextFactoryJavaStaxDefaultImpl;

public class XMLIteratorFactory {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private final Factory<Accessor<String>> SIMPLE_ACCESSOR_FACTORY = new Factory<Accessor<String>>(){

        @Override
        public Accessor<String> newInstance() {
            return new ElementHolder<String>();
        }
    };
    private final Factory<Accessor<String>> THREADLOCAL_BASED_ACCESSOR_FACTORY = new Factory<Accessor<String>>(){

        @Override
        public Accessor<String> newInstance() {
            return new ThreadLocalToAccessorAdapter<String>();
        }
    };
    public static final XMLInstanceContextFactory XML_INSTANCE_CONTEXT_FACTORY_JAVA_STAX_DEFAULT = new XMLInstanceContextFactoryJavaStaxDefaultImpl();
    public static final JAXBTypeContentConverterFactory DEFAULT_JAXB_TYPE_CONTENT_CONVERTER_FACTORY = new JAXBTypeContentConverterFactory(){

        @Override
        public <E> ElementConverter<String, E> newElementConverter(Class<? extends E> type, ExceptionHandler exceptionHandler) {
            return new JAXBTypeContentConverter<E>(type, exceptionHandler);
        }
    };
    private final CachedElement<XMLEventReader> xmlEventReaderCache;
    private final TraversalContextControl traversalContextControl;
    private final List<XMLEventTransformer> xmlEventTransformerList;
    private final List<Scope> scopeList;
    private final List<TouchBarrier> touchBarrierList;
    private XMLInstanceContextFactory xmlInstanceContextFactory;
    private Factory<Accessor<String>> accessorFactory = null;
    private String encoding = "UTF-8";
    private JAXBTypeContentConverterFactory jaxbTypeContentConverterFactory = DEFAULT_JAXB_TYPE_CONTENT_CONVERTER_FACTORY;
    private final ExceptionHandler exceptionHandler;

    public XMLIteratorFactory(InputStream inputStream, ExceptionHandler exceptionHandler) {
        this.xmlEventTransformerList = new ArrayList<XMLEventTransformer>();
        this.exceptionHandler = (ExceptionHandler)ObjectUtils.defaultIfNull((Object)exceptionHandler, (Object)new ExceptionHandlerIgnoring());
        this.xmlInstanceContextFactory = XML_INSTANCE_CONTEXT_FACTORY_JAVA_STAX_DEFAULT;
        this.xmlEventReaderCache = this.newXmlEventReaderCache(inputStream, exceptionHandler);
        this.scopeList = new ArrayList<Scope>();
        this.touchBarrierList = new ArrayList<TouchBarrier>();
        this.traversalContextControl = new TraversalContextControl();
    }

    private CachedElement<XMLEventReader> newXmlEventReaderCache(final InputStream inputStream, final ExceptionHandler exceptionHandler) {
        return new CachedElement<4>(new CachedElement.ValueResolver<XMLEventReader>(){

            @Override
            public XMLEventReader resolveValue() {
                XMLEventReader retval = null;
                try {
                    XMLInputFactory xmlInputFactory = XMLIteratorFactory.this.xmlInstanceContextFactory.newXmlInputFactory();
                    Assert.isNotNull((Object)xmlInputFactory, "xmlInputFactory must not be null");
                    retval = xmlInputFactory.createXMLEventReader(inputStream);
                }
                catch (Exception e) {
                    exceptionHandler.handleException(e);
                }
                return retval;
            }
        });
    }

    public XMLIteratorFactory(InputStream inputStream) {
        this(inputStream, new ExceptionHandlerIgnoring());
    }

    private XMLIteratorFactory(CachedElement<XMLEventReader> xmlEventReaderCache, XMLInstanceContextFactory xmlInstanceContextFactory, List<XMLEventTransformer> xmlTransformerList, ExceptionHandler exceptionHandler, List<Scope> scopeList, List<TouchBarrier> touchBarrierList, TraversalContextControl traversalContextControl, JAXBTypeContentConverterFactory jaxbTypeContentConverterFactory) {
        this.xmlEventReaderCache = xmlEventReaderCache;
        this.xmlEventTransformerList = xmlTransformerList;
        this.exceptionHandler = exceptionHandler;
        this.scopeList = scopeList;
        this.touchBarrierList = touchBarrierList;
        this.traversalContextControl = traversalContextControl;
        this.xmlInstanceContextFactory = xmlInstanceContextFactory;
        this.jaxbTypeContentConverterFactory = jaxbTypeContentConverterFactory;
    }

    public XMLIteratorFactory doLowerCaseXMLTagAndAttributeNames() {
        XMLEventTransformerForTagAndAttributeName.XMLTagAndAttributeNameTransformerLowerCase xmlTagAndAttributeNameTransformer = new XMLEventTransformerForTagAndAttributeName.XMLTagAndAttributeNameTransformerLowerCase();
        XMLEventTransformerForTagAndAttributeName xmlEventTransformer = new XMLEventTransformerForTagAndAttributeName(xmlTagAndAttributeNameTransformer);
        return this.doAddXMLEventTransformer(xmlEventTransformer);
    }

    public XMLIteratorFactory doRemoveNamespacesForXMLTagAndAttributeNames() {
        XMLEventTransformerForTagAndAttributeName.XMLTagAndAttributeNameTransformerRemoveNamespace xmlTagAndAttributeNameTransformer = new XMLEventTransformerForTagAndAttributeName.XMLTagAndAttributeNameTransformerRemoveNamespace();
        XMLEventTransformerForTagAndAttributeName xmlEventTransformer = new XMLEventTransformerForTagAndAttributeName(xmlTagAndAttributeNameTransformer);
        return this.doAddXMLEventTransformer(xmlEventTransformer);
    }

    public XMLIteratorFactory doUpperCaseXMLTagAndAttributeNames() {
        XMLEventTransformerForTagAndAttributeName.XMLTagAndAttributeNameTransformerUpperCase xmlTagAndAttributeNameTransformer = new XMLEventTransformerForTagAndAttributeName.XMLTagAndAttributeNameTransformerUpperCase();
        XMLEventTransformerForTagAndAttributeName xmlEventTransformer = new XMLEventTransformerForTagAndAttributeName(xmlTagAndAttributeNameTransformer);
        return this.doAddXMLEventTransformer(xmlEventTransformer);
    }

    public XMLIteratorFactory doAddXMLEventTransformer(XMLEventTransformer xmlEventTransformer) {
        XMLIteratorFactory retval = this;
        if (xmlEventTransformer != null) {
            retval = new XMLIteratorFactory(this.xmlEventReaderCache, this.xmlInstanceContextFactory, ListUtils.addToNewList(this.xmlEventTransformerList, xmlEventTransformer), this.exceptionHandler, this.scopeList, this.touchBarrierList, this.traversalContextControl, this.jaxbTypeContentConverterFactory);
        }
        return retval;
    }

    public XMLIteratorFactory doAddXMLTagScope(QName tagName) {
        XMLIteratorFactory retval = this;
        if (tagName != null) {
            Scope scope = new Scope(tagName);
            retval = new XMLIteratorFactory(this.xmlEventReaderCache, this.xmlInstanceContextFactory, this.xmlEventTransformerList, this.exceptionHandler, ListUtils.addToNewList(this.scopeList, scope), this.touchBarrierList, this.traversalContextControl, this.jaxbTypeContentConverterFactory);
        }
        return retval;
    }

    public XMLIteratorFactory doAddXMLTagTouchBarrier(QName tagName) {
        XMLIteratorFactory retval = this;
        if (tagName != null) {
            TouchBarrier touchBarrier = new TouchBarrier(tagName);
            retval = new XMLIteratorFactory(this.xmlEventReaderCache, this.xmlInstanceContextFactory, this.xmlEventTransformerList, this.exceptionHandler, this.scopeList, ListUtils.addToNewList(this.touchBarrierList, touchBarrier), this.traversalContextControl, this.jaxbTypeContentConverterFactory);
        }
        return retval;
    }

    public XMLIteratorFactory doCreateThreadsafeIterators(boolean threadsafe) {
        this.accessorFactory = threadsafe ? this.THREADLOCAL_BASED_ACCESSOR_FACTORY : this.SIMPLE_ACCESSOR_FACTORY;
        return this;
    }

    public Iterator<String> newIterator(QName qName) {
        return this.newIterator(qName, new ElementConverterIdentitiyCast());
    }

    public Iterator<Map<String, Object>> newIteratorMapBased(QName qName) {
        ElementConverter<String, Map<String, Object>> elementConverter = new ElementConverter<String, Map<String, Object>>(){

            @Override
            public Map<String, Object> convert(String element) {
                Map<String, Object> mapFromXML = new XMLNestedMapConverter().setExceptionHandler(XMLIteratorFactory.this.exceptionHandler).setXmlInstanceContextFactory(XMLIteratorFactory.this.xmlInstanceContextFactory).newMapFromXML(element);
                Map.Entry<String, Object> firstEntry = MapUtils.firstEntry(mapFromXML);
                Object value = firstEntry != null ? firstEntry.getValue() : null;
                return (Map)(value instanceof Map ? value : null);
            }
        };
        return this.newIterator(qName, elementConverter);
    }

    public <E> Iterator<E> newIterator(QName qName, ElementConverter<String, E> elementConverter) {
        XMLElementSelectorQNameBased xmlElementSelector = new XMLElementSelectorQNameBased(qName);
        return this.newIterator((XMLElementSelector)xmlElementSelector, elementConverter);
    }

    public <E> Iterator<E> newIterator(Class<? extends E> type) {
        QName qName = JAXBXMLHelper.determineRootName(type);
        XMLElementSelectorQNameBased xmlElementSelector = new XMLElementSelectorQNameBased(qName);
        return this.newIterator((XMLElementSelector)xmlElementSelector, type);
    }

    public <E> Iterator<E> newIterator(XMLElementSelector xmlElementSelector, Class<? extends E> type) {
        ElementConverter<String, ? extends E> elementConverter = this.jaxbTypeContentConverterFactory.newElementConverter(type, this.exceptionHandler);
        return this.newIterator(xmlElementSelector, elementConverter);
    }

    public <E> Iterator<E> newIterator(XMLElementSelector xmlElementSelector, ElementConverter<String, E> elementConverter) {
        Iterator<String> iterator = this.newIterator(xmlElementSelector);
        return IteratorUtils.adapter(iterator, elementConverter);
    }

    public Iterator<String> newIterator(XMLElementSelector xmlElementSelector) {
        XMLIterator retval = null;
        XMLEventReader xmlEventReader = this.getXmlEventReader();
        if (xmlEventReader != null && xmlElementSelector != null) {
            try {
                XMLOutputFactory xmlOutputFactory = this.xmlInstanceContextFactory.newXmlOutputFactory();
                XMLEventFactory xmlEventFactory = this.xmlInstanceContextFactory.newXmlEventFactory();
                Assert.isNotNull((Object)xmlOutputFactory, "xmlOutputFactory must not be null");
                Assert.isNotNull((Object)xmlEventFactory, "xmlEventFactory must not be null");
                ScopeControl scopeControl = new ScopeControl(this.scopeList);
                TouchBarrierControl touchBarrierControl = new TouchBarrierControl(this.touchBarrierList, this.exceptionHandler);
                Accessor<String> accessor = this.newAccessor();
                retval = new XMLIterator(accessor, scopeControl, this.exceptionHandler, xmlEventReader, xmlEventFactory, this.encoding, this.traversalContextControl, xmlElementSelector, xmlOutputFactory, touchBarrierControl, this.xmlEventTransformerList);
            }
            catch (Exception e) {
                this.exceptionHandler.handleException(e);
            }
        }
        return retval;
    }

    private Accessor<String> newAccessor() {
        if (this.accessorFactory == null) {
            this.accessorFactory = this.SIMPLE_ACCESSOR_FACTORY;
        }
        return this.accessorFactory.newInstance();
    }

    public XMLIteratorFactory setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public XMLIteratorFactory close() {
        block2: {
            try {
                this.getXmlEventReader().close();
            }
            catch (XMLStreamException e) {
                if (this.exceptionHandler == null) break block2;
                this.exceptionHandler.handleException(e);
            }
        }
        return this;
    }

    private XMLEventReader getXmlEventReader() {
        return this.xmlEventReaderCache.getValue();
    }

    public XMLIteratorFactory setXmlInstanceContextFactory(XMLInstanceContextFactory xmlInstanceContextFactory) {
        this.xmlInstanceContextFactory = xmlInstanceContextFactory;
        return this;
    }

    public XMLIteratorFactory setJAXBTypeContentConverterFactory(JAXBTypeContentConverterFactory jaxbTypeContentConverterFactory) {
        this.jaxbTypeContentConverterFactory = jaxbTypeContentConverterFactory;
        return this;
    }

    private static class TouchBarrierControl {
        private final List<TouchBarrier> touchBarrierList;
        private final ExceptionHandler exceptionHandler;

        public TouchBarrierControl(List<TouchBarrier> touchBarrierList, ExceptionHandler exceptionHandler) {
            this.touchBarrierList = touchBarrierList;
            this.exceptionHandler = exceptionHandler;
        }

        public boolean isAnyBarrierTouched(XMLEvent xmlEventPeek, final List<QName> qNameHierarchy) {
            boolean retval = false;
            if (xmlEventPeek != null && xmlEventPeek.isStartElement() && this.touchBarrierList != null && !this.touchBarrierList.isEmpty()) {
                try {
                    final QName qName = xmlEventPeek.asStartElement().getName();
                    XMLElementSelector.SelectionContext selectionContext = new XMLElementSelector.SelectionContext(){

                        @Override
                        public List<QName> getQNameHierarchy() {
                            return qNameHierarchy;
                        }

                        @Override
                        public QName getQName() {
                            return qName;
                        }
                    };
                    for (TouchBarrier touchBarrier : this.touchBarrierList) {
                        boolean matches;
                        if (touchBarrier == null || !(matches = touchBarrier.matches(selectionContext))) continue;
                        retval = true;
                        break;
                    }
                }
                catch (Exception e) {
                    this.exceptionHandler.handleException(e);
                }
            }
            return retval;
        }
    }

    private static class TouchBarrier {
        private final XMLElementSelector xmlElementSelector;

        public TouchBarrier(XMLElementSelector xmlElementSelector) {
            this.xmlElementSelector = xmlElementSelector;
        }

        public TouchBarrier(QName qName) {
            this.xmlElementSelector = new XMLElementSelectorQNameBased(qName);
        }

        protected boolean matches(XMLElementSelector.SelectionContext selectionContext) {
            return this.xmlElementSelector.selectElement(selectionContext);
        }
    }

    private static class ScopeControl {
        private final List<Scope> scopeList;

        public ScopeControl(List<Scope> scopeList) {
            this.scopeList = scopeList;
            if (scopeList != null) {
                for (Scope scope : scopeList) {
                    scope.resetTraversedState();
                }
            }
        }

        public boolean hasScopes() {
            return this.scopeList != null && !this.scopeList.isEmpty();
        }

        public boolean hasTraversedAnyScope() {
            boolean retval = false;
            if (this.scopeList != null) {
                for (Scope scope : this.scopeList) {
                    if (!scope.isTraversed()) continue;
                    retval = true;
                    break;
                }
            }
            return retval;
        }

        public void visitStartElement(XMLElementSelector.SelectionContext selectionContext) {
            if (this.scopeList != null) {
                for (Scope scope : this.scopeList) {
                    scope.visitStartElement(selectionContext);
                }
            }
        }

        public void visitEndElement(XMLElementSelector.SelectionContext selectionContext) {
            if (this.scopeList != null) {
                for (Scope scope : this.scopeList) {
                    scope.visitEndElement(selectionContext);
                }
            }
        }

        public boolean hasEnteredAnyScope() {
            boolean retval = false;
            if (this.scopeList != null) {
                for (Scope scope : this.scopeList) {
                    if (!scope.hasBeenEntered()) continue;
                    retval = true;
                    break;
                }
            }
            return retval;
        }
    }

    private static class Scope {
        private final XMLElementSelector elementSelector;
        private boolean isTraversed = false;
        private int enclosureCount = 0;

        public void visitStartElement(XMLElementSelector.SelectionContext selectionContext) {
            if (this.elementSelector.selectElement(selectionContext)) {
                ++this.enclosureCount;
            }
        }

        public Scope(QName qName) {
            this.elementSelector = new XMLElementSelectorQNameBased(qName);
        }

        public void visitEndElement(XMLElementSelector.SelectionContext selectionContext) {
            if (this.elementSelector.selectElement(selectionContext)) {
                --this.enclosureCount;
                if (this.enclosureCount == 0) {
                    this.isTraversed = true;
                }
            }
        }

        public boolean isTraversed() {
            return this.isTraversed;
        }

        public void resetTraversedState() {
            this.isTraversed = false;
        }

        public boolean hasBeenEntered() {
            return this.enclosureCount > 0;
        }
    }

    private static class TraversalContextControl {
        private final List<QName> qNameList = new ArrayList<QName>();

        private TraversalContextControl() {
        }

        public XMLElementSelector.SelectionContext getCurrentSelectionContext() {
            return new SelectionContextImpl(this.qNameList);
        }

        public void addQName(QName qName) {
            this.qNameList.add(qName);
        }

        public void reduceLastQName() {
            ListUtils.removeLast(this.qNameList);
        }

        private static class SelectionContextImpl
        implements XMLElementSelector.SelectionContext {
            private final List<QName> qNameList;

            public SelectionContextImpl(List<QName> qNameList) {
                this.qNameList = new ArrayList<QName>(qNameList);
            }

            @Override
            public List<QName> getQNameHierarchy() {
                return this.qNameList;
            }

            @Override
            public QName getQName() {
                return ListUtils.lastElement(this.qNameList);
            }
        }
    }

    private static class NamespaceStack {
        private final List<Map<String, String>> prefixToNamespaceUriMapList = new ArrayList<Map<String, String>>();

        private NamespaceStack() {
        }

        public void addStack(Iterator<Namespace> namespaceIterator) {
            HashMap<String, String> prefixToNamespaceUriMap = new HashMap<String, String>();
            if (namespaceIterator != null) {
                for (Namespace namespace : IterableUtils.valueOf(namespaceIterator)) {
                    if (namespace == null) continue;
                    String prefix = namespace.getPrefix();
                    String namespaceURI = namespace.getNamespaceURI();
                    prefixToNamespaceUriMap.put(prefix, namespaceURI);
                }
            }
            this.prefixToNamespaceUriMapList.add(0, prefixToNamespaceUriMap);
        }

        public void addNamespaceToCurrentNamespaceStack(Namespace namespace) {
            Map<String, String> prefixToNamespaceUriMap = ListUtils.firstElement(this.prefixToNamespaceUriMapList);
            if (prefixToNamespaceUriMap != null) {
                String prefix = namespace.getPrefix();
                String namespaceUri = namespace.getNamespaceURI();
                prefixToNamespaceUriMap.put(prefix, namespaceUri);
            }
        }

        public void removeStack() {
            ListUtils.removeFirst(this.prefixToNamespaceUriMapList);
        }

        public boolean hasDeclaredNamespace(String prefix, String namespaceUri) {
            boolean retval = false;
            for (Map<String, String> prefixToNamespaceUriMap : this.prefixToNamespaceUriMapList) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)namespaceUri, (CharSequence)prefixToNamespaceUriMap.get(prefix))) continue;
                retval = true;
                break;
            }
            return retval;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("NamespaceStack [prefixToNamespaceUriMapList=");
            builder.append(this.prefixToNamespaceUriMapList);
            builder.append("]");
            return builder.toString();
        }
    }

    public static class XMLEventTransformerForTagAndAttributeName
    implements XMLEventTransformer {
        private final XMLTagAndAttributeNameTransformer xmlTagAndAttributeNameTransformer;

        public XMLEventTransformerForTagAndAttributeName(XMLTagAndAttributeNameTransformer xmlTagAndAttributeNameTransformer) {
            this.xmlTagAndAttributeNameTransformer = xmlTagAndAttributeNameTransformer;
        }

        @Override
        public XMLEvent transform(XMLEvent xmlEvent, XMLEventFactory xmlEventFactory) {
            XMLEvent retval = xmlEvent;
            if (xmlEvent.isStartElement()) {
                StartElement startElement = xmlEvent.asStartElement();
                QName name = startElement.getName();
                QName qname = this.xmlTagAndAttributeNameTransformer.transformTagName(name);
                Iterator<Attribute> attributes = startElement.getAttributes();
                Iterator<Namespace> namespaces = startElement.getNamespaces();
                retval = xmlEventFactory.createStartElement(qname, attributes, namespaces);
            } else if (xmlEvent.isEndElement()) {
                EndElement endElement = xmlEvent.asEndElement();
                QName name = endElement.getName();
                QName qname = this.xmlTagAndAttributeNameTransformer.transformTagName(name);
                Iterator<Namespace> namespaces = endElement.getNamespaces();
                retval = xmlEventFactory.createEndElement(qname, namespaces);
            } else if (xmlEvent.isAttribute()) {
                Attribute attribute = (Attribute)xmlEvent;
                QName name = attribute.getName();
                QName qname = this.xmlTagAndAttributeNameTransformer.transformAttributeName(name);
                String value = attribute.getValue();
                retval = xmlEventFactory.createAttribute(qname, value);
            }
            return retval;
        }

        public static class XMLTagAndAttributeNameTransformerRemoveNamespace
        implements XMLTagAndAttributeNameTransformer {
            @Override
            public QName transformTagName(QName tagName) {
                return new QName(null, tagName.getLocalPart());
            }

            @Override
            public QName transformAttributeName(QName attributeName) {
                return new QName(null, attributeName.getLocalPart());
            }
        }

        public static class XMLTagAndAttributeNameTransformerLowerCase
        implements XMLTagAndAttributeNameTransformer {
            @Override
            public QName transformTagName(QName tagName) {
                return new QName(tagName.getNamespaceURI(), StringUtils.lowerCase((String)tagName.getLocalPart()));
            }

            @Override
            public QName transformAttributeName(QName attributeName) {
                return new QName(attributeName.getNamespaceURI(), StringUtils.lowerCase((String)attributeName.getLocalPart()));
            }
        }

        public static class XMLTagAndAttributeNameTransformerUpperCase
        implements XMLTagAndAttributeNameTransformer {
            @Override
            public QName transformTagName(QName tagName) {
                return new QName(tagName.getNamespaceURI(), StringUtils.upperCase((String)tagName.getLocalPart()));
            }

            @Override
            public QName transformAttributeName(QName attributeName) {
                return new QName(attributeName.getNamespaceURI(), StringUtils.upperCase((String)attributeName.getLocalPart()));
            }
        }

        public static interface XMLTagAndAttributeNameTransformer {
            public QName transformTagName(QName var1);

            public QName transformAttributeName(QName var1);
        }
    }

    public static interface XMLEventTransformer {
        public XMLEvent transform(XMLEvent var1, XMLEventFactory var2);
    }

    public static class XMLElementSelectorQNameBased
    implements XMLElementSelector {
        private final String selectingNamespace;
        private final String selectingTagName;

        public XMLElementSelectorQNameBased(QName qName) {
            this.selectingNamespace = qName != null ? qName.getNamespaceURI() : null;
            this.selectingTagName = qName != null ? qName.getLocalPart() : null;
        }

        @Override
        public boolean selectElement(XMLElementSelector.SelectionContext selectionContext) {
            boolean retval = false;
            QName currentQName = selectionContext.getQName();
            boolean matchesNamespace = StringUtils.isBlank((CharSequence)this.selectingNamespace) || currentQName != null && StringUtils.equals((CharSequence)this.selectingNamespace, (CharSequence)currentQName.getNamespaceURI());
            boolean matchesTagName = currentQName != null && StringUtils.equals((CharSequence)this.selectingTagName, (CharSequence)currentQName.getLocalPart());
            retval = matchesNamespace && matchesTagName;
            return retval;
        }
    }

    public static interface XMLElementSelector {
        public boolean selectElement(SelectionContext var1);

        public static interface SelectionContext {
            public QName getQName();

            public List<QName> getQNameHierarchy();
        }
    }

    protected static final class XMLIterator
    implements Iterator<String> {
        private final Accessor<String> nextElementAccessor;
        private final NamespaceStack namespaceStack = new NamespaceStack();
        private final Accessor<String> accessor;
        private final ScopeControl scopeControl;
        private final ExceptionHandler exceptionHandler;
        private final XMLEventReader xmlEventReader;
        private final XMLEventFactory xmlEventFactory;
        private final String encoding;
        private final TraversalContextControl traversalContextControl;
        private final XMLElementSelector xmlElementSelector;
        private final XMLOutputFactory xmlOutputFactory;
        private final TouchBarrierControl touchBarrierControl;
        private final List<XMLEventTransformer> xmlEventTransformerList;

        protected XMLIterator(Accessor<String> accessor, ScopeControl scopeControl, ExceptionHandler exceptionHandler, XMLEventReader xmlEventReader, XMLEventFactory xmlEventFactory, String encoding, TraversalContextControl traversalContextControl, XMLElementSelector xmlElementSelector, XMLOutputFactory xmlOutputFactory, TouchBarrierControl touchBarrierControl, List<XMLEventTransformer> xmlEventTransformerList) {
            this.accessor = accessor;
            this.scopeControl = scopeControl;
            this.exceptionHandler = exceptionHandler;
            this.xmlEventReader = xmlEventReader;
            this.xmlEventFactory = xmlEventFactory;
            this.encoding = encoding;
            this.traversalContextControl = traversalContextControl;
            this.xmlElementSelector = xmlElementSelector;
            this.xmlOutputFactory = xmlOutputFactory;
            this.touchBarrierControl = touchBarrierControl;
            this.xmlEventTransformerList = xmlEventTransformerList;
            this.nextElementAccessor = this.accessor;
        }

        @Override
        public synchronized boolean hasNext() {
            this.resolveNextElementIfUnresolved();
            return this.nextElementAccessor.getElement() != null;
        }

        @Override
        public synchronized String next() {
            String retval = null;
            this.resolveNextElementIfUnresolved();
            retval = (String)this.nextElementAccessor.getElement();
            this.nextElementAccessor.setElement(null);
            if (retval == null) {
                throw new NoSuchElementException();
            }
            return retval;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void resolveNextElementIfUnresolved() {
            if (this.nextElementAccessor.getElement() == null) {
                this.nextElementAccessor.setElement(this.resolveNextElement());
            }
        }

        public String resolveNextElement() {
            String retval = null;
            try {
                XMLEventWriter xmlEventWriter;
                ByteArrayContainer byteArrayContainerOut = new ByteArrayContainer();
                OutputStream outputStream = byteArrayContainerOut.getOutputStream();
                XMLEventWriter xmlEventConsumer = xmlEventWriter = this.xmlOutputFactory.createXMLEventWriter(outputStream, this.encoding);
                boolean read = false;
                boolean done = false;
                boolean touchedBarrier = false;
                boolean hasWrittenAtLeastOneElement = false;
                while (!done && !this.scopeControl.hasTraversedAnyScope() && this.xmlEventReader.hasNext() && (read || !touchedBarrier && !(touchedBarrier = this.touchBarrierControl.isAnyBarrierTouched(this.transformXMLElement(this.xmlEventReader.peek()), this.traversalContextControl.getCurrentSelectionContext().getQNameHierarchy())))) {
                    XMLElementSelector.SelectionContext selectionContext;
                    XMLEvent currentEvent;
                    XMLEvent writableEvent = currentEvent = this.transformXMLElement(this.xmlEventReader.nextEvent());
                    if (currentEvent.isStartElement()) {
                        StartElement startElement = currentEvent.asStartElement();
                        QName name = startElement.getName();
                        this.traversalContextControl.addQName(name);
                        XMLElementSelector.SelectionContext selectionContext2 = this.traversalContextControl.getCurrentSelectionContext();
                        this.scopeControl.visitStartElement(selectionContext2);
                        if (this.xmlElementSelector.selectElement(selectionContext2) && (!this.scopeControl.hasScopes() || this.scopeControl.hasEnteredAnyScope())) {
                            read = true;
                        }
                        if (read) {
                            if (!hasWrittenAtLeastOneElement) {
                                xmlEventWriter.add(this.xmlEventFactory.createStartDocument());
                            }
                            this.namespaceStack.addStack(startElement.getNamespaces());
                            writableEvent = this.transformEventIncludingCurrentNamespaceIfNonDefault(this.xmlEventFactory, startElement, name);
                        }
                    }
                    if (read) {
                        xmlEventConsumer.add(writableEvent);
                        hasWrittenAtLeastOneElement = true;
                    }
                    if (!currentEvent.isEndElement()) continue;
                    if (read) {
                        this.namespaceStack.removeStack();
                    }
                    if (this.xmlElementSelector.selectElement(selectionContext = this.traversalContextControl.getCurrentSelectionContext())) {
                        read = false;
                        done = true;
                        xmlEventWriter.add(this.xmlEventFactory.createEndDocument());
                    }
                    this.traversalContextControl.reduceLastQName();
                    this.scopeControl.visitEndElement(selectionContext);
                }
                if (hasWrittenAtLeastOneElement) {
                    xmlEventWriter.close();
                    outputStream.close();
                    if (byteArrayContainerOut.isNotEmpty()) {
                        retval = byteArrayContainerOut.toString("utf-8");
                    }
                }
                if (!this.xmlEventReader.hasNext()) {
                    this.xmlEventReader.close();
                }
            }
            catch (Exception e) {
                this.exceptionHandler.handleException(e);
            }
            return retval;
        }

        private StartElement transformEventIncludingCurrentNamespaceIfNonDefault(XMLEventFactory xmlEventFactory, StartElement startElement, QName name) {
            StartElement retval = startElement;
            String prefix = name.getPrefix();
            String namespaceUri = name.getNamespaceURI();
            String localName = name.getLocalPart();
            if (StringUtils.isNotBlank((CharSequence)namespaceUri) && !StringUtils.equalsIgnoreCase((CharSequence)namespaceUri, (CharSequence)"##default") && !this.namespaceStack.hasDeclaredNamespace(prefix, namespaceUri)) {
                Namespace namespace = xmlEventFactory.createNamespace(prefix, namespaceUri);
                Iterator<Namespace> namespaces = IteratorUtils.addToNewIterator(startElement.getNamespaces(), namespace);
                Iterator<Attribute> attributes = startElement.getAttributes();
                retval = xmlEventFactory.createStartElement(prefix, namespaceUri, localName, attributes, namespaces);
                this.namespaceStack.addNamespaceToCurrentNamespaceStack(namespace);
            }
            return retval;
        }

        private XMLEvent transformXMLElement(XMLEvent xmlEvent) {
            XMLEvent retval = xmlEvent;
            for (XMLEventTransformer xmlEventTransformer : this.xmlEventTransformerList) {
                retval = xmlEventTransformer.transform(retval, this.xmlEventFactory);
            }
            return retval;
        }
    }

    public static class JAXBTypeContentConverter<E>
    implements ElementConverter<String, E> {
        protected final ThreadLocalCachedElement<JAXBXMLHelper.JAXBContextBasedUnmarshaller<E>> cachedElement;

        public JAXBTypeContentConverter(final Class<? extends E> type, final ExceptionHandler exceptionHandler) {
            this.cachedElement = new ThreadLocalCachedElement(new CachedElement.ValueResolver<JAXBXMLHelper.JAXBContextBasedUnmarshaller<E>>(){

                @Override
                public JAXBXMLHelper.JAXBContextBasedUnmarshaller<E> resolveValue() {
                    return JAXBXMLHelper.newJAXBContextBasedUnmarshaller(type, new JAXBXMLHelper.UnmarshallingConfiguration().setExceptionHandler(exceptionHandler));
                }
            });
        }

        @Override
        public E convert(String element) {
            return ((JAXBXMLHelper.JAXBContextBasedUnmarshaller)this.cachedElement.getValue()).unmarshal(new ByteArrayContainer(element).getInputStream());
        }
    }

    public static interface JAXBTypeContentConverterFactory {
        public <E> ElementConverter<String, E> newElementConverter(Class<? extends E> var1, ExceptionHandler var2);
    }
}

