/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.xml;

import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.input.CharSequenceReader;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.container.ByteArrayContainer;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.element.converter.ElementConverterIdentitiyCast;
import org.omnaest.utils.structure.iterator.IterableUtils;
import org.omnaest.utils.structure.iterator.IteratorUtils;
import org.omnaest.utils.tuple.TupleTwo;
import org.omnaest.utils.xml.context.XMLInstanceContextFactory;
import org.omnaest.utils.xml.context.XMLInstanceContextFactoryJavaStaxDefaultImpl;

public class XMLNestedMapConverter {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final XMLInstanceContextFactory XML_INSTANCE_CONTEXT_FACTORY_JAVA_STAX_DEFAULT = new XMLInstanceContextFactoryJavaStaxDefaultImpl();
    private ExceptionHandler exceptionHandler = null;
    private String encoding = "UTF-8";
    private XMLInstanceContextFactory xmlInstanceContextFactory = XML_INSTANCE_CONTEXT_FACTORY_JAVA_STAX_DEFAULT;

    public Map<QName, Object> newNamespaceAwareMapFromXML(CharSequence xmlContent) {
        ElementConverterIdentitiyCast keyElementConverter = new ElementConverterIdentitiyCast();
        return this.newMapFromXML(xmlContent, keyElementConverter);
    }

    public Map<String, Object> newMapFromXML(CharSequence xmlContent) {
        ElementConverter<QName, String> keyElementConverter = new ElementConverter<QName, String>(){

            @Override
            public String convert(QName element) {
                return element.getLocalPart();
            }
        };
        return this.newMapFromXML(xmlContent, keyElementConverter);
    }

    protected <K> Map<K, Object> newMapFromXML(CharSequence xmlContent, final ElementConverter<QName, K> keyElementConverter) {
        LinkedHashMap<K, Object> retmap;
        block5: {
            retmap = new LinkedHashMap<K, Object>();
            Assert.isNotNull(keyElementConverter, "keyElementConverter must not be null");
            ExceptionHandler exceptionHandler = this.exceptionHandler;
            try {
                XMLEventReader xmlEventReader;
                CharSequenceReader reader;
                block4: {
                    XMLInputFactory xmlInputFactory = this.xmlInstanceContextFactory.newXmlInputFactory();
                    Assert.isNotNull((Object)xmlInputFactory, "xmlInputFactory must not be null");
                    reader = new CharSequenceReader(xmlContent);
                    xmlEventReader = xmlInputFactory.createXMLEventReader((Reader)reader);
                    try {
                        final class Helper {
                            private List<TupleTwo<QName, Object>> stackList = new ArrayList<TupleTwo<QName, Object>>();

                            Helper() {
                            }

                            public TupleTwo<QName, Object> manifest() throws XMLStreamException {
                                TupleTwo<QName, Object> retval = null;
                                while (xmlEventReader.hasNext()) {
                                    Characters characters;
                                    XMLEvent xmlEvent = xmlEventReader.nextEvent();
                                    if (xmlEvent.isStartElement()) {
                                        StartElement startElement = xmlEvent.asStartElement();
                                        QName name = startElement.getName();
                                        this.addNewStackElement().setValueFirst(name);
                                        Iterator<Attribute> attributeIterator = startElement.getAttributes();
                                        if (!attributeIterator.hasNext()) continue;
                                        LinkedHashMap<QName, Object> map = new LinkedHashMap<QName, Object>();
                                        for (Attribute attribute : IterableUtils.valueOf(attributeIterator)) {
                                            map.put(attribute.getName(), attribute.getValue());
                                        }
                                        this.updateCurrentStackValue(map);
                                        continue;
                                    }
                                    if (xmlEvent.isEndElement()) {
                                        retval = this.removeStackElement();
                                        Object manifestation = retval.getValueSecond();
                                        QName tagname = retval.getValueFirst();
                                        this.updateCurrentStackValue(manifestation, tagname);
                                        continue;
                                    }
                                    if (!xmlEvent.isCharacters() || (characters = xmlEvent.asCharacters()).isWhiteSpace()) continue;
                                    TupleTwo<QName, Object> currentStackValue = this.getCurrentStackValue();
                                    currentStackValue.setValueSecond(ObjectUtils.defaultIfNull((Object)currentStackValue.getValueSecond(), (Object)"") + characters.getData());
                                }
                                return retval;
                            }

                            private void updateCurrentStackValue(Object manifestation, QName tagname) {
                                LinkedHashMap<QName, Object> tagNameToManifestationMap = new LinkedHashMap<QName, Object>();
                                tagNameToManifestationMap.put(tagname, manifestation);
                                this.updateCurrentStackValue(tagNameToManifestationMap);
                            }

                            private void updateCurrentStackValue(Map<QName, Object> tagNameToManifestationMap) {
                                TupleTwo<QName, Object> currentStackValue = this.getCurrentStackValue();
                                if (currentStackValue != null) {
                                    LinkedHashMap map = null;
                                    Object valueSecond = currentStackValue.getValueSecond();
                                    if (valueSecond instanceof Map) {
                                        map = (LinkedHashMap)valueSecond;
                                    } else {
                                        map = new LinkedHashMap();
                                        if (valueSecond instanceof String) {
                                            map.put(keyElementConverter.convert(new QName("")), valueSecond);
                                        }
                                    }
                                    for (Map.Entry<QName, Object> tagNameToManifestationEntry : tagNameToManifestationMap.entrySet()) {
                                        ArrayList<Object> list;
                                        Object tagname = keyElementConverter.convert(tagNameToManifestationEntry.getKey());
                                        Object manifestation = tagNameToManifestationEntry.getValue();
                                        if (!map.containsKey(tagname)) {
                                            map.put(tagname, manifestation);
                                            continue;
                                        }
                                        Object object = map.get(tagname);
                                        if (object instanceof List) {
                                            list = (ArrayList<Object>)object;
                                            list.add(manifestation);
                                            continue;
                                        }
                                        list = new ArrayList<Object>();
                                        list.add(object);
                                        list.add(manifestation);
                                        map.put(tagname, list);
                                    }
                                    currentStackValue.setValueSecond(map);
                                }
                            }

                            private TupleTwo<QName, Object> getCurrentStackValue() {
                                return ListUtils.firstElement(this.stackList);
                            }

                            private TupleTwo<QName, Object> removeStackElement() {
                                return ListUtils.removeFirst(this.stackList);
                            }

                            private TupleTwo<QName, Object> addNewStackElement() {
                                TupleTwo<QName, Object> retval = new TupleTwo<QName, Object>();
                                this.stackList.add(0, retval);
                                return retval;
                            }
                        }
                        Helper helper = new Helper();
                        TupleTwo<QName, Object> result = helper.manifest();
                        retmap.put(keyElementConverter.convert(result.getValueFirst()), result.getValueSecond());
                    }
                    catch (Exception e) {
                        if (exceptionHandler == null) break block4;
                        exceptionHandler.handleException(e);
                    }
                }
                xmlEventReader.close();
                reader.close();
            }
            catch (Exception e) {
                if (exceptionHandler == null) break block5;
                exceptionHandler.handleException(e);
            }
        }
        return retmap;
    }

    public String toXML(Map<String, Object> nestedMap) {
        String retval;
        block2: {
            retval = null;
            try {
                ByteArrayContainer byteArrayContainer = new ByteArrayContainer();
                OutputStream outputStream = byteArrayContainer.getOutputStream();
                this.toXML(nestedMap, outputStream);
                retval = byteArrayContainer.toString();
            }
            catch (Exception e) {
                if (this.exceptionHandler == null) break block2;
                this.exceptionHandler.handleException(e);
            }
        }
        return retval;
    }

    public String toNamespaceAwareXML(Map<QName, Object> nestedMap) {
        String retval;
        block2: {
            retval = null;
            try {
                ByteArrayContainer byteArrayContainer = new ByteArrayContainer();
                OutputStream outputStream = byteArrayContainer.getOutputStream();
                this.toNamespaceAwareXML(nestedMap, outputStream);
                retval = byteArrayContainer.toString();
            }
            catch (Exception e) {
                if (this.exceptionHandler == null) break block2;
                this.exceptionHandler.handleException(e);
            }
        }
        return retval;
    }

    public String toXMLDocument(Map<String, Object> nestedMap) {
        String retval;
        block2: {
            retval = null;
            try {
                ByteArrayContainer byteArrayContainer = new ByteArrayContainer();
                OutputStream outputStream = byteArrayContainer.getOutputStream();
                this.toXMLDocument(nestedMap, outputStream);
                retval = byteArrayContainer.toString();
            }
            catch (Exception e) {
                if (this.exceptionHandler == null) break block2;
                this.exceptionHandler.handleException(e);
            }
        }
        return retval;
    }

    public void toXMLDocument(Map<String, Object> nestedMap, OutputStream outputStream) {
        boolean includeDocumentHeader = true;
        this.toXML(nestedMap, outputStream, true);
    }

    public String toNamespaceAwareXMLDocument(Map<QName, Object> nestedMap) {
        String retval;
        block2: {
            retval = null;
            try {
                ByteArrayContainer byteArrayContainer = new ByteArrayContainer();
                OutputStream outputStream = byteArrayContainer.getOutputStream();
                this.toNamespaceAwareXMLDocument(nestedMap, outputStream);
                outputStream.close();
                retval = byteArrayContainer.toString();
            }
            catch (Exception e) {
                if (this.exceptionHandler == null) break block2;
                this.exceptionHandler.handleException(e);
            }
        }
        return retval;
    }

    public void toNamespaceAwareXMLDocument(Map<QName, Object> nestedMap, OutputStream outputStream) {
        boolean includeDocumentHeader = true;
        this.toNamespaceAwareXML(nestedMap, outputStream, true);
    }

    public void toXML(Map<String, Object> nestedMap, OutputStream outputStream) {
        boolean includeDocumentHeader = false;
        this.toXML(nestedMap, outputStream, false);
    }

    private void toXML(Map<String, Object> nestedMap, OutputStream outputStream, boolean includeDocumentHeader) {
        ElementConverter<String, QName> keyElementConverter = new ElementConverter<String, QName>(){

            @Override
            public QName convert(String element) {
                return new QName(element);
            }
        };
        this.toXML(nestedMap, outputStream, keyElementConverter, includeDocumentHeader);
    }

    public void toNamespaceAwareXML(Map<QName, Object> nestedMap, OutputStream outputStream) {
        boolean includeDocumentHeader = false;
        this.toNamespaceAwareXML(nestedMap, outputStream, false);
    }

    private void toNamespaceAwareXML(Map<QName, Object> nestedMap, OutputStream outputStream, boolean includeDocumentHeader) {
        ElementConverterIdentitiyCast keyElementConverter = new ElementConverterIdentitiyCast();
        this.toXML(nestedMap, outputStream, keyElementConverter, includeDocumentHeader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K> void toXML(Map<K, Object> nestedMap, OutputStream outputStream, final ElementConverter<K, QName> keyElementConverter, boolean includeDocumentHeader) {
        block7: {
            if (nestedMap != null && keyElementConverter != null && outputStream != null) {
                try {
                    XMLOutputFactory xmlOutputFactory = this.xmlInstanceContextFactory.newXmlOutputFactory();
                    final XMLEventFactory xmlEventFactory = this.xmlInstanceContextFactory.newXmlEventFactory();
                    Assert.isNotNull((Object)xmlOutputFactory, "xmlOutputFactory must not be null");
                    Assert.isNotNull((Object)xmlEventFactory, "xmlEventFactory must not be null");
                    final XMLEventWriter xmlEventWriter = xmlOutputFactory.createXMLEventWriter(outputStream, this.encoding);
                    final ExceptionHandler exceptionHandler = this.exceptionHandler;
                    try {
                        if (includeDocumentHeader) {
                            xmlEventWriter.add(xmlEventFactory.createStartDocument());
                        }
                        class Helper {
                            private List<String> namespaceStack = new ArrayList<String>();

                            Helper() {
                            }

                            public void write(Map<K, Object> map) {
                                if (map != null) {
                                    for (Object key : map.keySet()) {
                                        QName tagName = (QName)keyElementConverter.convert(key);
                                        Object value = map.get(key);
                                        if (value instanceof String) {
                                            this.writeStartTag(tagName);
                                            String text = (String)value;
                                            this.writeText(text);
                                            this.writeEndTag(tagName);
                                            continue;
                                        }
                                        if (value instanceof Map) {
                                            this.writeStartTag(tagName);
                                            Map subMap = (Map)value;
                                            this.write(subMap);
                                            this.writeEndTag(tagName);
                                            continue;
                                        }
                                        if (!(value instanceof List)) continue;
                                        List valueList = (List)value;
                                        this.write(tagName, valueList);
                                    }
                                }
                            }

                            private void writeStartTag(QName tagName) {
                                try {
                                    String namespaceURI = tagName.getNamespaceURI();
                                    Iterator<? extends Attribute> attributes = null;
                                    Iterator<Namespace> namespaces = StringUtils.isNotBlank((CharSequence)namespaceURI) && !StringUtils.equals((CharSequence)namespaceURI, (CharSequence)ListUtils.lastElement(this.namespaceStack)) ? IteratorUtils.valueOf(xmlEventFactory.createNamespace(namespaceURI)) : null;
                                    StartElement startElement = xmlEventFactory.createStartElement(tagName, attributes, namespaces);
                                    xmlEventWriter.add(startElement);
                                    this.namespaceStack.add(namespaceURI);
                                }
                                catch (Exception e) {
                                    exceptionHandler.handleException(e);
                                }
                            }

                            private void writeEndTag(QName tagName) {
                                try {
                                    Iterator<? extends Namespace> namespaces = null;
                                    EndElement endElement = xmlEventFactory.createEndElement(tagName, namespaces);
                                    xmlEventWriter.add(endElement);
                                    ListUtils.removeLast(this.namespaceStack);
                                }
                                catch (Exception e) {
                                    exceptionHandler.handleException(e);
                                }
                            }

                            private void writeText(String text) {
                                try {
                                    Characters characters = xmlEventFactory.createCharacters(text);
                                    xmlEventWriter.add(characters);
                                }
                                catch (Exception e) {
                                    exceptionHandler.handleException(e);
                                }
                            }

                            private void write(QName tagName, List<Object> valueList) {
                                if (valueList != null) {
                                    for (Object value : valueList) {
                                        if (value == null) continue;
                                        this.writeStartTag(tagName);
                                        if (value instanceof Map) {
                                            Map map = (Map)value;
                                            this.write(map);
                                        } else if (value instanceof String) {
                                            String text = (String)value;
                                            this.writeText(text);
                                        }
                                        this.writeEndTag(tagName);
                                    }
                                }
                            }
                        }
                        new Helper().write(nestedMap);
                        xmlEventWriter.add(xmlEventFactory.createEndDocument());
                    }
                    finally {
                        xmlEventWriter.close();
                        outputStream.flush();
                    }
                }
                catch (Exception e) {
                    if (this.exceptionHandler == null) break block7;
                    this.exceptionHandler.handleException(e);
                }
            }
        }
    }

    public XMLNestedMapConverter setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public XMLNestedMapConverter setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public XMLNestedMapConverter setXmlInstanceContextFactory(XMLInstanceContextFactory xmlInstanceContextFactory) {
        this.xmlInstanceContextFactory = xmlInstanceContextFactory;
        return this;
    }
}

