/*******************************************************************************
 * Copyright 2011 Danny Kunz
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package org.omnaest.utils.threads;

import java.util.concurrent.Callable;

import org.omnaest.utils.assertion.Assert;

/**
 * Adapter to use a {@link Runnable} as {@link Callable}
 * 
 * @author Omnaest
 */
public class RunnableToCallableAdapter implements Callable<Void>
{
  /* ********************************************** Variables ********************************************** */
  protected final Runnable runnable;
  
  /* ********************************************** Methods ********************************************** */
  
  /**
   * @see RunnableToCallableAdapter
   * @param runnable
   */
  public RunnableToCallableAdapter( Runnable runnable )
  {
    super();
    this.runnable = runnable;
    Assert.isNotNull( runnable, "A RunnableToCallableAdapter must have a non null Runnable reference" );
  }
  
  @Override
  public Void call() throws Exception
  {
    //
    this.runnable.run();
    
    //
    return null;
  }
  
}
