/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table;

import java.util.Set;
import java.util.SortedMap;
import java.util.regex.Pattern;
import org.omnaest.utils.table.ImmutableColumn;
import org.omnaest.utils.table.ImmutableTable;
import org.omnaest.utils.table.Row;
import org.omnaest.utils.table.Table;

public interface TableSelect<E> {
    public TableSelect<E> allColumns();

    public TableSelect<E> allColumns(ImmutableTable<E> var1);

    public TableSelect<E> column(int var1);

    public TableSelect<E> column(ImmutableTable<E> var1, int var2);

    public TableSelect<E> columns(int var1, int ... var2);

    public TableSelect<E> column(ImmutableColumn<E> var1);

    public TableJoin<E> join(ImmutableTable<E> var1);

    public TableSelect<E> where(Predicate<E> var1, Predicate<E> ... var2);

    public TableSelect<E> where(Predicate<E> var1);

    public TableSelect<E> whereEqual(ImmutableColumn<E> var1, E var2);

    public TableSelect<E> whereWithin(ImmutableColumn<E> var1, Set<E> var2);

    public TableSelect<E> whereLike(ImmutableColumn<E> var1, Pattern var2);

    public TableSelectExecution<E> as();

    public TableSelect<E> withTableLock(boolean var1);

    public TableSelect<E> skip(int var1);

    public TableSelect<E> top(int var1);

    public static interface TableSelectExecution<E> {
        public Table<E> table();

        public SortedMap<E, Set<Row<E>>> sortedMap();
    }

    public static interface TableJoin<E>
    extends TableSelect<E> {
        @Override
        public TableJoin<E> allColumns();

        @Override
        public TableJoin<E> columns(int var1, int ... var2);

        public TableJoin<E> onEqual(ImmutableColumn<E> var1, ImmutableColumn<E> var2);

        public TableJoin<E> onEqual(ImmutableColumn<E> var1, E var2);

        public TableJoin<E> onWithin(ImmutableColumn<E> var1, Set<E> var2);

        public TableJoin<E> on(Predicate<E> var1);

        public TableJoin<E> onLike(ImmutableColumn<E> var1, Pattern var2);

        @Override
        public TableJoin<E> withTableLock(boolean var1);
    }

    public static interface Predicate<E> {
        public boolean isIncluding(FilterRow<E> var1);

        public static interface FilterRow<E> {
            public E getElement(ImmutableColumn.ColumnIdentity<E> var1);

            public E getElement(ImmutableColumn.ColumnIdentity<E> var1, int var2);

            public E getElement(ImmutableTable<E> var1, int var2);

            public boolean hasColumn(ImmutableColumn.ColumnIdentity<E> var1);
        }
    }
}

