/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.events.exception.ExceptionHandlerSerializable;
import org.omnaest.utils.operation.OperationUtils;
import org.omnaest.utils.operation.special.OperationIntrinsic;
import org.omnaest.utils.operation.special.OperationVoid;
import org.omnaest.utils.structure.array.ArrayUtils;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.collection.set.SetUtils;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.element.converter.ElementConverterObjectToString;
import org.omnaest.utils.structure.element.converter.ElementConverterSerializable;
import org.omnaest.utils.structure.element.factory.Factory;
import org.omnaest.utils.structure.iterator.IterableUtils;
import org.omnaest.utils.structure.iterator.IteratorUtils;
import org.omnaest.utils.table.Cell;
import org.omnaest.utils.table.Column;
import org.omnaest.utils.table.Columns;
import org.omnaest.utils.table.ImmutableColumn;
import org.omnaest.utils.table.ImmutableRow;
import org.omnaest.utils.table.ImmutableStripe;
import org.omnaest.utils.table.ImmutableTable;
import org.omnaest.utils.table.Row;
import org.omnaest.utils.table.StripeTransformerPlugin;
import org.omnaest.utils.table.Table;
import org.omnaest.utils.table.TableAdapterManager;
import org.omnaest.utils.table.TableDataSource;
import org.omnaest.utils.table.TableDataSourceCopier;
import org.omnaest.utils.table.TableEventHandler;
import org.omnaest.utils.table.TableExecution;
import org.omnaest.utils.table.TableIndexManager;
import org.omnaest.utils.table.TablePersistenceRegistration;
import org.omnaest.utils.table.TableSelect;
import org.omnaest.utils.table.TableSorter;
import org.omnaest.utils.table.impl.CellImpl;
import org.omnaest.utils.table.impl.ColumnImpl;
import org.omnaest.utils.table.impl.ColumnsImpl;
import org.omnaest.utils.table.impl.RowImpl;
import org.omnaest.utils.table.impl.StripeTransformerPluginManager;
import org.omnaest.utils.table.impl.StripeTransformerPluginManagerImpl;
import org.omnaest.utils.table.impl.TableAbstract;
import org.omnaest.utils.table.impl.TableDataAccessor;
import org.omnaest.utils.table.impl.TableDataCore;
import org.omnaest.utils.table.impl.TableEventDispatcher;
import org.omnaest.utils.table.impl.TableEventHandlerRegistration;
import org.omnaest.utils.table.impl.TableIndexManagerImpl;
import org.omnaest.utils.table.impl.TableMetaData;
import org.omnaest.utils.table.impl.TablePersistenceRegistrationImpl;
import org.omnaest.utils.table.impl.TableSorterImpl;
import org.omnaest.utils.table.impl.adapter.TableAdapterManagerImpl;
import org.omnaest.utils.table.impl.join.TableSelectImpl;

public class ArrayTable<E>
extends TableAbstract<E> {
    private static final long serialVersionUID = 6360131663629436319L;
    final Class<E> elementType;
    private final TableAdapterManager<E> tableAdapterManager;
    private final TableDataAccessor<E> tableDataAccessor;
    private final TableIndexManager<E, Cell<E>> tableIndexManager;
    private final TablePersistenceRegistration<E> tablePersistenceRegistration;
    private final StripeTransformerPluginManager<E> stripeTransformerPluginManager;

    public ArrayTable(Class<? extends E> elementType) {
        Assert.isNotNull(elementType, (String)"The table element type must not be null");
        this.elementType = elementType;
        TableMetaData tableMetaData = new TableMetaData();
        TableDataCore<? extends E> tableDataCore = new TableDataCore<E>(elementType);
        TableEventDispatcher tableEventDispatcher = new TableEventDispatcher();
        this.tableDataAccessor = new TableDataAccessor<E>(tableDataCore, tableEventDispatcher, tableMetaData).setExceptionHandler((ExceptionHandler)this.exceptionHandler);
        this.tableIndexManager = new TableIndexManagerImpl<E>(this.tableDataAccessor, this, (ExceptionHandler)this.exceptionHandler);
        this.tableAdapterManager = new TableAdapterManagerImpl(this, (ExceptionHandler)this.exceptionHandler);
        this.tablePersistenceRegistration = this.tableDataAccessor.register(new TablePersistenceRegistrationImpl(this, this.tableDataAccessor.getTableLock(), (ExceptionHandlerSerializable)this.exceptionHandler));
        this.stripeTransformerPluginManager = new StripeTransformerPluginManagerImpl();
    }

    public ArrayTable(E[][] elementMatrix) {
        this(ArrayUtils.componentType((Class)ArrayUtils.componentType(elementMatrix.getClass())));
        this.copy().from(elementMatrix);
    }

    @Override
    public Table<E> addColumnElements(E ... elements) {
        int columnIndex = this.columnSize();
        return this.addColumnElements(columnIndex, elements);
    }

    @Override
    public Table<E> addColumnElements(int columnIndex, E ... elements) {
        this.tableDataAccessor.addColumn(columnIndex, elements);
        return this;
    }

    @Override
    public Table<E> addRowElements(E ... elements) {
        this.tableDataAccessor.addRow(elements);
        return this;
    }

    @Override
    public Table<E> addRowElements(int rowIndex, E ... elements) {
        this.tableDataAccessor.addRow(rowIndex, elements);
        return this;
    }

    @Override
    public TableAdapterManager<E> as() {
        return this.tableAdapterManager;
    }

    @Override
    public Cell<E> cell(int rowIndex, int columnIndex) {
        return rowIndex >= 0 && columnIndex >= 0 ? this.tableDataAccessor.register(new CellImpl(rowIndex, columnIndex, this)) : null;
    }

    @Override
    public Iterable<Cell<E>> cells() {
        return new Iterable<Cell<E>>(){

            @Override
            public Iterator<Cell<E>> iterator() {
                final Iterator rowIterator = ArrayTable.this.rows().iterator();
                return IteratorUtils.factoryBasedIterator((Factory)new Factory<Iterator<Cell<E>>>(){

                    public Iterator<Cell<E>> newInstance() {
                        return rowIterator.hasNext() ? ((Row)rowIterator.next()).cells().iterator() : null;
                    }
                });
            }
        };
    }

    @Override
    public Table<E> clear() {
        this.tableDataAccessor.clear();
        return this;
    }

    @Override
    public Table<E> clone() {
        ArrayTable table = new ArrayTable(this.to().array());
        table.setTableName(this.getTableName());
        table.setRowTitles(this.getRowTitleList());
        table.setColumnTitles(this.getColumnTitleList());
        return table;
    }

    @Override
    public Column<E> column(int columnIndex) {
        return columnIndex >= 0 ? this.tableDataAccessor.register(new ColumnImpl(columnIndex, this, false)) : null;
    }

    @Override
    public Column<E> column(String columnTitle) {
        int columnIndex = this.tableDataAccessor.getColumnIndex(columnTitle);
        return this.column(columnIndex);
    }

    @Override
    public Columns<E, Column<E>> columns(Pattern columnTitlePattern) {
        BitSet columnIndexFilter = this.tableDataAccessor.getColumnIndexFilter(columnTitlePattern);
        return new ColumnsImpl(IterableUtils.filtered((Iterable)this.columns(), (BitSet)columnIndexFilter));
    }

    @Override
    public Columns<E, Column<E>> columns(Set<String> columnTitleSet) {
        BitSet columnIndexFilter = this.tableDataAccessor.getColumnIndexFilter(columnTitleSet);
        return new ColumnsImpl(IterableUtils.filtered((Iterable)this.columns(), (BitSet)columnIndexFilter));
    }

    @Override
    public Columns<E, Column<E>> columns(String ... columnTitles) {
        return this.columns(SetUtils.valueOf((Object[])columnTitles));
    }

    @Override
    public int columnSize() {
        return this.tableDataAccessor.columnSize();
    }

    @Override
    public Class<E> elementType() {
        return this.elementType;
    }

    @Override
    public boolean equalsInContent(ImmutableTable<E> table) {
        boolean retval;
        boolean bl = retval = table != null;
        if (table != null) {
            int rowSize = table.rowSize();
            int columnSize = table.columnSize();
            retval &= this.rowSize() == rowSize;
            if (retval &= this.columnSize() == columnSize) {
                Iterator iteratorRowThis = this.rows().iterator();
                Iterator iteratorRowOther = table.rows().iterator();
                while (iteratorRowThis.hasNext() && iteratorRowOther.hasNext()) {
                    ImmutableRow rowOther;
                    ImmutableRow rowThis = (ImmutableRow)iteratorRowThis.next();
                    if (rowThis.equalsInContent(rowOther = (ImmutableRow)iteratorRowOther.next())) continue;
                    retval = false;
                    break;
                }
                retval &= !iteratorRowThis.hasNext() && !iteratorRowOther.hasNext();
            }
        }
        return retval;
    }

    @Override
    public boolean equalsInContentAndMetaData(ImmutableTable<E> table) {
        boolean equalsInContent = this.equalsInContent(table);
        boolean equalsInMetaData = table != null && StringUtils.equals((CharSequence)this.getTableName(), (CharSequence)table.getTableName()) && ObjectUtils.equals(this.getRowTitleList(), table.getRowTitleList()) && ObjectUtils.equals(this.getColumnTitleList(), table.getColumnTitleList());
        return equalsInContent && equalsInMetaData;
    }

    @Override
    public ImmutableTable<E> executeWithReadLock(TableExecution<ImmutableTable<E>, E> tableExecution) {
        OperationUtils.executeWithLocks(tableExecution, (Object)this, (Lock[])new Lock[]{this.tableDataAccessor.getTableLock().readLock()});
        return this;
    }

    @Override
    public Table<E> executeWithReadLock(final TableExecution<ImmutableTable<E>, E> tableExecution, final ImmutableTable<E> ... furtherLockedTables) {
        final int furtherLockedTablesLength = furtherLockedTables.length;
        if (furtherLockedTablesLength > 0) {
            OperationUtils.executeWithLocks((OperationIntrinsic)new OperationIntrinsic(){

                public void execute() {
                    OperationUtils.executeWithLocks((OperationVoid)tableExecution, (Object)ArrayTable.this, (Lock[])new Lock[]{ArrayTable.this.tableDataAccessor.getTableLock().readLock()});
                    ImmutableTable furtherTable = furtherLockedTables[0];
                    furtherTable.executeWithReadLock(tableExecution, Arrays.copyOfRange(furtherLockedTables, 1, furtherLockedTablesLength));
                }
            }, (Lock[])new Lock[]{this.tableDataAccessor.getTableLock().readLock()});
        } else {
            OperationUtils.executeWithLocks(tableExecution, (Object)this, (Lock[])new Lock[]{this.tableDataAccessor.getTableLock().readLock()});
        }
        return this;
    }

    @Override
    public Table<E> executeWithWriteLock(TableExecution<Table<E>, E> tableExecution) {
        OperationUtils.executeWithLocks(tableExecution, (Object)this, (Lock[])new Lock[]{this.tableDataAccessor.getTableLock().writeLock()});
        return this;
    }

    @Override
    public E getElement(int rowIndex, int columnIndex) {
        return this.tableDataAccessor.getElement(rowIndex, columnIndex);
    }

    @Override
    public E getElement(String rowTitle, int columnIndex) {
        int rowIndex = this.tableDataAccessor.getRowIndex(rowTitle);
        return this.tableDataAccessor.getElement(rowIndex, columnIndex);
    }

    @Override
    public E getElement(int rowIndex, String columnTitle) {
        int columnIndex = this.tableDataAccessor.getColumnIndex(columnTitle);
        return this.tableDataAccessor.getElement(rowIndex, columnIndex);
    }

    @Override
    public E getElement(String rowTitle, String columnTitle) {
        int rowIndex = this.tableDataAccessor.getRowIndex(rowTitle);
        int columnIndex = this.tableDataAccessor.getColumnIndex(columnTitle);
        return this.tableDataAccessor.getElement(rowIndex, columnIndex);
    }

    @Override
    public String getColumnTitle(int columnIndex) {
        return this.tableDataAccessor.getColumnTitle(columnIndex);
    }

    @Override
    public List<String> getColumnTitleList() {
        return this.tableDataAccessor.getColumnTitleList();
    }

    @Override
    public String getRowTitle(int rowIndex) {
        return this.tableDataAccessor.getRowTitle(rowIndex);
    }

    @Override
    public List<String> getRowTitleList() {
        return this.tableDataAccessor.getRowTitleList();
    }

    @Override
    public String getTableName() {
        return this.tableDataAccessor.getTableName();
    }

    @Override
    public boolean hasColumnTitles() {
        return this.tableDataAccessor.hasColumnTitles();
    }

    @Override
    public boolean hasRowTitles() {
        return this.tableDataAccessor.hasRowTitles();
    }

    @Override
    public boolean hasTableName() {
        return this.tableDataAccessor.hasTableName();
    }

    @Override
    public TableIndexManager<E, Cell<E>> index() {
        return this.tableIndexManager;
    }

    @Override
    public TablePersistenceRegistration<E> persistence() {
        return this.tablePersistenceRegistration;
    }

    @Override
    public Table<E> removeColumn(int columnIndex) {
        this.tableDataAccessor.removeColumn(columnIndex);
        return this;
    }

    @Override
    public Table<E> removeRow(int rowIndex) {
        this.tableDataAccessor.removeRow(rowIndex);
        return this;
    }

    @Override
    public Row<E> row(int rowIndex) {
        return rowIndex >= 0 ? this.tableDataAccessor.register(new RowImpl(rowIndex, this, false)) : null;
    }

    @Override
    public Row<E> row(String rowTitle) {
        int rowIndex = this.tableDataAccessor.getRowIndex(rowTitle);
        return this.row(rowIndex);
    }

    @Override
    public int rowSize() {
        return this.tableDataAccessor.rowSize();
    }

    @Override
    public TableSelect<E> select() {
        return new TableSelectImpl(this);
    }

    @Override
    public Table<E> setColumnTitle(int columnIndex, String columnTitle) {
        this.tableDataAccessor.setColumnTitle(columnIndex, columnTitle);
        return this;
    }

    @Override
    public Table<E> setColumnTitles(Iterable<String> columnTitleIterable) {
        this.tableDataAccessor.setColumnTitles(columnTitleIterable);
        return this;
    }

    @Override
    public Table<E> setElement(int rowIndex, int columnIndex, E element) {
        this.tableDataAccessor.set(element, rowIndex, columnIndex);
        return this;
    }

    @Override
    public Table<E> setElement(int rowIndex, String columnTitle, E element) {
        int columnIndex = this.tableDataAccessor.getColumnIndex(columnTitle);
        this.setElement(rowIndex, columnIndex, element);
        return this;
    }

    @Override
    public Table<E> setElement(String rowTitle, int columnIndex, E element) {
        int rowIndex = this.tableDataAccessor.getRowIndex(rowTitle);
        this.setElement(rowIndex, columnIndex, element);
        return this;
    }

    @Override
    public Table<E> setElement(String rowTitle, String columnTitle, E element) {
        int columnIndex = this.tableDataAccessor.getColumnIndex(columnTitle);
        int rowIndex = this.tableDataAccessor.getRowIndex(rowTitle);
        this.setElement(rowIndex, columnIndex, element);
        return this;
    }

    @Override
    public Table<E> setRowElements(int rowIndex, E ... elements) {
        this.tableDataAccessor.setRow(rowIndex, elements);
        return this;
    }

    @Override
    public Table<E> setRowTitle(int rowIndex, String rowTitle) {
        this.tableDataAccessor.setRowTitle(rowIndex, rowTitle);
        return this;
    }

    @Override
    public Table<E> setRowTitles(Iterable<String> rowTitleIterable) {
        this.tableDataAccessor.setRowTitles(rowTitleIterable);
        return this;
    }

    @Override
    public Table<E> setTableName(String tableName) {
        this.tableDataAccessor.setTableName(tableName);
        return this;
    }

    @Override
    public TableSorter<E> sort() {
        return new TableSorterImpl(this);
    }

    @Override
    public int getColumnIndex(String columnTitle) {
        return this.tableDataAccessor.getColumnIndex(columnTitle);
    }

    @Override
    public Table<E> register(StripeTransformerPlugin<E, ?> stripeTransformerPlugin) {
        this.stripeTransformerPluginManager.register(stripeTransformerPlugin);
        return this;
    }

    @Override
    public <T> T transformStripeInto(Class<T> type, ImmutableStripe<E> stripe) {
        StripeTransformerPlugin<E, T> stripeTransformerPlugin;
        T retval = null;
        if (stripe != null && (stripeTransformerPlugin = this.stripeTransformerPluginManager.resolveStripeTransformerPluginFor(type)) != null) {
            try {
                retval = stripeTransformerPlugin.transform(stripe);
            }
            catch (Exception e) {
                this.exceptionHandler.handleException(e);
            }
        }
        return retval;
    }

    @Override
    public <T> T transformStripeInto(T instance, ImmutableStripe<E> stripe) {
        Class<?> type;
        StripeTransformerPlugin<E, ?> stripeTransformerPlugin;
        T retval = null;
        if (instance != null && stripe != null && (stripeTransformerPlugin = this.stripeTransformerPluginManager.resolveStripeTransformerPluginFor(type = instance.getClass())) != null) {
            try {
                retval = (T)stripeTransformerPlugin.transform(stripe, instance);
            }
            catch (Exception e) {
                this.exceptionHandler.handleException(e);
            }
        }
        return retval;
    }

    @Override
    public TableDataSourceCopier<E> copy() {
        final ArrayTable table = this;
        return new TableDataSourceCopier<E>(){
            private static final long serialVersionUID = 306474856413841605L;

            @Override
            public Table<E> from(E[][] elementMatrix) {
                if (elementMatrix != null) {
                    for (E[] elements : elementMatrix) {
                        table.addRowElements(elements);
                    }
                }
                return table;
            }

            @Override
            public Table<E> from(TableDataSource<E> tableDataSource) {
                if (tableDataSource != null) {
                    Iterable<E[]> rowElements = tableDataSource.rowElements();
                    if (rowElements != null) {
                        for (E[] elements : rowElements) {
                            table.addRowElements(elements);
                        }
                    }
                    String[] columnTitles = tableDataSource.getColumnTitles();
                    String[] rowTitles = tableDataSource.getRowTitles();
                    String tableName = tableDataSource.getTableName();
                    if (tableName != null) {
                        table.setTableName(tableName);
                    }
                    if (columnTitles != null) {
                        table.setColumnTitles(columnTitles);
                    }
                    if (rowTitles != null) {
                        table.setRowTitles(rowTitles);
                    }
                }
                return table;
            }
        };
    }

    @Override
    public String[] getColumnTitles() {
        return (String[])ArrayUtils.valueOf(this.getColumnTitleList(), String.class);
    }

    @Override
    public TableEventHandlerRegistration<E, Table<E>> tableEventHandlerRegistration() {
        final ArrayTable table = this;
        final TableDataAccessor<E> tableDataAccessor = this.tableDataAccessor;
        return new TableEventHandlerRegistration<E, Table<E>>(){
            private static final long serialVersionUID = -4733568643076274493L;

            @Override
            public Table<E> attach(TableEventHandler<E> tableEventHandler) {
                tableDataAccessor.register(tableEventHandler);
                return table;
            }

            @Override
            public Table<E> detach(TableEventHandler<E> tableEventHandler) {
                tableDataAccessor.unregister(tableEventHandler);
                return table;
            }
        };
    }

    @Override
    public Iterable<E[]> rowElements() {
        ElementConverterSerializable elementConverter = new ElementConverterSerializable<Row<E>, E[]>(){
            private static final long serialVersionUID = -4211554274134868391L;

            public E[] convert(Row<E> row) {
                return row.to().array();
            }
        };
        return IterableUtils.adapter((Iterable)this.rows(), (ElementConverter)elementConverter);
    }

    @Override
    public Row<E> row(int rowIndex, boolean detached) {
        return rowIndex >= 0 ? new RowImpl(rowIndex, this, detached) : null;
    }

    @Override
    public Table<E> setColumnTitlesUsingFirstRow() {
        ImmutableRow row = this.row(0);
        Object[] elements = row.to().array();
        String[] columnTitles = (String[])ArrayUtils.convertArray((Object[])elements, String.class, (ElementConverter)new ElementConverterObjectToString());
        this.setColumnTitles(columnTitles);
        row.remove();
        return this;
    }

    @Override
    public Table<E> setRowTitlesUsingFirstColumn() {
        ImmutableColumn column = this.column(0);
        Object[] elements = column.to().array();
        String[] rowTitles = (String[])ArrayUtils.convertArray((Object[])elements, String.class, (ElementConverter)new ElementConverterObjectToString());
        this.setRowTitles(rowTitles);
        column.remove();
        return this;
    }

    @Override
    public Table<E> addRowElements(Map<String, E> columnToElementMap, boolean createColumnTitleIfDontExists) {
        if (columnToElementMap != null) {
            ArrayList elementList = new ArrayList();
            Set<String> columnTitleSet = columnToElementMap.keySet();
            ArrayList<String> columnTitleList = new ArrayList<String>(this.getColumnTitleList());
            for (String columnTitle : columnTitleSet) {
                int indexOf = columnTitleList.indexOf(columnTitle);
                if (createColumnTitleIfDontExists && indexOf < 0) {
                    indexOf = columnTitleList.size();
                    columnTitleList.add(columnTitle);
                    this.addColumnTitle(columnTitle);
                }
                if (indexOf < 0) continue;
                E element = columnToElementMap.get(columnTitle);
                ListUtils.set(elementList, (int)indexOf, element);
            }
            this.addRowElements(elementList);
        }
        return this;
    }

    @Override
    public Table<E> addRowElements(Iterable<E> elementIterable) {
        if (elementIterable != null) {
            Object[] elements = ArrayUtils.valueOf(elementIterable, this.elementType);
            this.addRowElements(elements);
        }
        return this;
    }
}

