/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl;

import java.util.BitSet;
import org.omnaest.utils.table.Cell;
import org.omnaest.utils.table.Column;
import org.omnaest.utils.table.ImmutableCell;
import org.omnaest.utils.table.Row;
import org.omnaest.utils.table.Table;
import org.omnaest.utils.table.TableEventHandler;

class CellImpl<E>
implements Cell<E>,
TableEventHandler<E> {
    private static final long serialVersionUID = 6804665993728136898L;
    private volatile int columnIndex;
    private volatile boolean isDeleted = false;
    private volatile boolean isModified = false;
    private volatile int rowIndex;
    private final Table<E> table;

    public CellImpl(int rowIndex, int columnIndex, Table<E> table) {
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        this.table = table;
    }

    @Override
    public E clear() {
        E element = this.getElement();
        this.setElement(null);
        return element;
    }

    @Override
    public Column<E> column() {
        return this.table.column(this.columnIndex);
    }

    @Override
    public int columnIndex() {
        return !this.isDeleted ? this.columnIndex : -1;
    }

    @Override
    public E getElement() {
        return this.isDeleted ? null : (E)this.table.getElement(this.rowIndex, this.columnIndex);
    }

    @Override
    public ImmutableCell.Position getPosition() {
        return !this.isDeleted ? new PositionImplementation(this.columnIndex, this.rowIndex) : new PositionImplementation(-1, -1);
    }

    public Row<E> getRow() {
        return !this.isDeleted ? this.table.row(this.rowIndex) : null;
    }

    @Override
    public void handleAddedColumn(int columnIndex, E ... elements) {
        if (!this.isDeleted && this.columnIndex >= columnIndex) {
            ++this.columnIndex;
        }
    }

    @Override
    public void handleAddedRow(int rowIndex, E ... elements) {
        if (!this.isDeleted && this.rowIndex >= rowIndex) {
            ++this.rowIndex;
        }
    }

    @Override
    public void handleClearTable() {
        this.markAsDeleted();
    }

    @Override
    public void handleRemovedColumn(int columnIndex, E[] previousElements, String columnTitle) {
        if (this.columnIndex == columnIndex) {
            this.markAsDeleted();
        }
    }

    @Override
    public void handleRemovedRow(int rowIndex, E[] previousElements, String rowTitle) {
        if (this.rowIndex == rowIndex) {
            this.markAsDeleted();
        }
    }

    @Override
    public void handleUpdatedCell(int rowIndex, int columnIndex, E element, E previousElement) {
        if (this.rowIndex == rowIndex && this.columnIndex == columnIndex) {
            this.isModified = true;
        }
    }

    @Override
    public void handleUpdatedRow(int rowIndex, E[] elements, E[] previousElements, BitSet modifiedIndices) {
        if (this.rowIndex == rowIndex) {
            this.isModified |= modifiedIndices.get(this.columnIndex);
        }
    }

    @Override
    public boolean isDeleted() {
        return this.isDeleted;
    }

    @Override
    public boolean isModified() {
        return this.isModified;
    }

    private void markAsDeleted() {
        this.isDeleted = true;
        this.columnIndex = -1;
        this.rowIndex = -1;
    }

    @Override
    public Row<E> row() {
        return this.table.row(this.rowIndex);
    }

    @Override
    public int rowIndex() {
        return !this.isDeleted ? this.rowIndex : -1;
    }

    @Override
    public Cell<E> setElement(E element) {
        if (!this.isDeleted) {
            this.table.setElement(this.rowIndex, this.columnIndex, element);
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CellImpl [rowIndex=");
        builder.append(this.rowIndex);
        builder.append(", columnIndex=");
        builder.append(this.columnIndex);
        builder.append(", isDeleted=");
        builder.append(this.isDeleted);
        builder.append(", isModified=");
        builder.append(this.isModified);
        builder.append(", getElement()=");
        builder.append(this.getElement());
        builder.append("]");
        return builder.toString();
    }

    @Override
    public <T> T getElementAsCast() {
        return (T)this.getElement();
    }

    @Override
    public void handleModifiedColumnTitle(int columnIndex, String columnTitle, String columnTitlePrevious) {
    }

    @Override
    public void handleModifiedRowTitle(int rowIndex, String rowTitle, String rowTitlePrevious) {
    }

    @Override
    public void handleModifiedColumnTitles(String[] columnTitles, String[] columnTitlesPrevious) {
    }

    @Override
    public void handleModifiedRowTitles(String[] rowTitles, String[] rowTitlesPrevious) {
    }

    @Override
    public void handleModifiedTableName(String tableName, String tableNamePrevious) {
    }

    private static final class PositionImplementation
    implements ImmutableCell.Position {
        private final int columnIndex;
        private final int rowIndex;

        public PositionImplementation(int columnIndex, int rowIndex) {
            this.columnIndex = columnIndex;
            this.rowIndex = rowIndex;
        }

        @Override
        public int columnIndex() {
            return this.columnIndex;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PositionImplementation)) {
                return false;
            }
            PositionImplementation other = (PositionImplementation)obj;
            if (this.columnIndex != other.columnIndex) {
                return false;
            }
            return this.rowIndex == other.rowIndex;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.columnIndex;
            result = 31 * result + this.rowIndex;
            return result;
        }

        @Override
        public int rowIndex() {
            return this.rowIndex;
        }
    }
}

