/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl;

import org.omnaest.utils.table.Column;
import org.omnaest.utils.table.ImmutableColumn;
import org.omnaest.utils.table.ImmutableTable;
import org.omnaest.utils.table.Table;

class ColumnIdentityImpl<E>
implements ImmutableColumn.ColumnIdentity<E> {
    private final Table<E> table;
    private final Column<E> column;

    ColumnIdentityImpl(Table<E> table, Column<E> column) {
        this.column = column;
        this.table = table;
    }

    @Override
    public ImmutableTable<E> getTable() {
        return this.table;
    }

    @Override
    public ImmutableColumn<E> column() {
        return this.column;
    }

    @Override
    public int getColumnIndex() {
        return this.column.index();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getColumnIndex();
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnIdentityImpl)) {
            return false;
        }
        ColumnIdentityImpl other = (ColumnIdentityImpl)obj;
        if (this.getColumnIndex() != other.getColumnIndex()) {
            return false;
        }
        return !(this.table == null ? other.table != null : !this.table.equals(other.table));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ColumnIdentityImpl [columnIndex=");
        builder.append(this.getColumnIndex());
        builder.append(", table=");
        builder.append(this.table);
        builder.append("]");
        return builder.toString();
    }
}

