/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.omnaest.utils.structure.array.ArrayUtils;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.collection.set.SetUtils;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.table.Cell;
import org.omnaest.utils.table.ImmutableStripe;
import org.omnaest.utils.table.Stripe;
import org.omnaest.utils.table.StripeEntity;
import org.omnaest.utils.table.StripeTransformer;
import org.omnaest.utils.table.Table;
import org.omnaest.utils.table.TableEventHandler;

abstract class StripeImpl<E>
implements Stripe<E>,
TableEventHandler<E> {
    private static final long serialVersionUID = 3138389285052519615L;
    protected volatile boolean isDeleted = false;
    protected volatile boolean isModified = false;
    protected volatile boolean isDetached = false;
    protected final Table<E> table;

    StripeImpl(Table<E> table, boolean isDetached) {
        this.table = table;
        this.isDetached = isDetached;
    }

    @Override
    public Iterator<E> iterator() {
        final int indexMax = this.size() - 1;
        return new Iterator<E>(){
            private int index = -1;

            @Override
            public boolean hasNext() {
                return this.index + 1 <= indexMax;
            }

            @Override
            public E next() {
                return StripeImpl.this.getElement(++this.index);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isDeleted() {
        return this.isDeleted;
    }

    @Override
    public boolean isModified() {
        return this.isModified;
    }

    @Override
    public Iterable<Cell<E>> cells() {
        ArrayList retlist = new ArrayList();
        int size = this.size();
        for (int ii = 0; ii < size; ++ii) {
            retlist.add(this.cell(ii));
        }
        return retlist;
    }

    @Override
    public Table<E> table() {
        return this.table;
    }

    @Override
    public boolean equalsInContent(ImmutableStripe<E> stripe) {
        boolean retval;
        boolean bl = retval = stripe != null;
        if (retval) {
            int sizeOther = stripe.size();
            if (retval &= this.size() == sizeOther) {
                for (int ii = 0; ii < sizeOther; ++ii) {
                    E cellElementOther = stripe.getElement(ii);
                    Object cellElementThis = this.getElement(ii);
                    if (ObjectUtils.equals(cellElementThis, cellElementOther)) continue;
                    retval = false;
                    break;
                }
            }
        }
        return retval;
    }

    @Override
    public StripeTransformer<E> to() {
        final StripeImpl stripe = this;
        final Table<E> table = this.table;
        final String[] orthogonalTitles = this.getOrthogonalTitles();
        return new StripeTransformer<E>(){
            private static final long serialVersionUID = 4473192340081669345L;

            @Override
            public Set<E> set() {
                return SetUtils.valueOf((Iterable)stripe);
            }

            @Override
            public List<E> list() {
                return ListUtils.valueOf((Iterable)stripe);
            }

            @Override
            public E[] array() {
                return ArrayUtils.valueOf((Iterable)stripe, table.elementType());
            }

            @Override
            public Map<String, E> map() {
                LinkedHashMap retmap = new LinkedHashMap();
                for (String title : orthogonalTitles) {
                    Object element = stripe.getElement(title);
                    retmap.put(title, element);
                }
                return retmap;
            }

            @Override
            public StripeEntity<E> entity() {
                String title = StripeImpl.this.getTitle();
                E[] elements = StripeImpl.this.getElements();
                return new StripeEntity(title, elements);
            }

            @Override
            public <T> T instanceOf(Class<T> type) {
                return (T)table.transformStripeInto(type, stripe);
            }

            @Override
            public <T> T instance(T instance) {
                return table.transformStripeInto(instance, StripeImpl.this);
            }

            @Override
            public <T> T[] array(Class<T> type) {
                return ArrayUtils.valueOf((Object[])new Serializable[]{stripe, type});
            }
        };
    }

    @Override
    public E[] getElements() {
        Object[] retvals = (Object[])Array.newInstance(this.table.elementType(), this.size());
        for (int ii = 0; ii < retvals.length; ++ii) {
            retvals[ii] = this.getElement(ii);
        }
        return retvals;
    }

    protected abstract String[] getOrthogonalTitles();

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("StripeImpl [isDeleted=");
        builder.append(this.isDeleted);
        builder.append(", isModified=");
        builder.append(this.isModified);
        builder.append(", elements=");
        builder.append(Arrays.deepToString(this.getElements()));
        builder.append("]");
        return builder.toString();
    }

    @Override
    public boolean isDetached() {
        return this.isDetached;
    }

    @Override
    public Stripe<E> detach() {
        this.table.tableEventHandlerRegistration().detach(this);
        this.isDetached = true;
        return this;
    }

    @Override
    public Stripe<E> apply(ElementConverter<E, E> elementConverter) {
        Object[] elements = this.getElements();
        Object[] convertedElements = ArrayUtils.convertArray((Object[])elements, this.table.elementType(), elementConverter);
        this.setElements(convertedElements);
        return this;
    }
}

