/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl;

import java.util.Map;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.element.converter.ElementConverterSerializable;
import org.omnaest.utils.structure.iterator.IterableUtils;
import org.omnaest.utils.table.Stripe;
import org.omnaest.utils.table.StripesTransformer;

class StripesTransformerImpl<E>
implements StripesTransformer<E> {
    private final Iterable<? extends Stripe<E>> stripeIterable;
    private static final long serialVersionUID = 2110974282111579037L;

    StripesTransformerImpl(Iterable<? extends Stripe<E>> stripeIterable) {
        this.stripeIterable = stripeIterable;
    }

    @Override
    public <T> Iterable<T> instancesOf(final Class<T> type) {
        ElementConverterSerializable elementConverter = new ElementConverterSerializable<Stripe<E>, T>(){
            private static final long serialVersionUID = 9082363234986556312L;

            public T convert(Stripe<E> column) {
                return column.to().instanceOf(type);
            }
        };
        return IterableUtils.adapter(this.stripeIterable, (ElementConverter)elementConverter);
    }

    @Override
    public Iterable<Map<String, E>> maps() {
        ElementConverterSerializable elementConverter = new ElementConverterSerializable<Stripe<E>, Map<String, E>>(){
            private static final long serialVersionUID = -4832586956691329459L;

            public Map<String, E> convert(Stripe<E> stripe) {
                return stripe.to().map();
            }
        };
        return IterableUtils.adapter(this.stripeIterable, (ElementConverter)elementConverter);
    }
}

