/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.events.exception.ExceptionHandlerSerializable;
import org.omnaest.utils.events.exception.basic.ExceptionHandlerDelegate;
import org.omnaest.utils.events.exception.basic.ExceptionHandlerIgnoring;
import org.omnaest.utils.structure.element.ObjectUtils;
import org.omnaest.utils.structure.element.factory.Factory;
import org.omnaest.utils.structure.element.factory.FactorySerializable;
import org.omnaest.utils.structure.iterator.IterableUtils;
import org.omnaest.utils.table.Column;
import org.omnaest.utils.table.Columns;
import org.omnaest.utils.table.ImmutableColumn;
import org.omnaest.utils.table.ImmutableRow;
import org.omnaest.utils.table.Row;
import org.omnaest.utils.table.Rows;
import org.omnaest.utils.table.Table;
import org.omnaest.utils.table.TableSerializer;
import org.omnaest.utils.table.TableTransformer;
import org.omnaest.utils.table.impl.ColumnsImpl;
import org.omnaest.utils.table.impl.RowsImpl;
import org.omnaest.utils.table.impl.serializer.TableSerializerImpl;
import org.omnaest.utils.table.impl.transformer.TableTransformerImpl;

abstract class TableAbstract<E>
implements Table<E> {
    private static final long serialVersionUID = 6651647383929942697L;
    protected ExceptionHandlerDelegate exceptionHandler = new ExceptionHandlerDelegate((ExceptionHandler)new ExceptionHandlerIgnoring());

    TableAbstract() {
    }

    TableAbstract(E[][] elementMatrix) {
        this.copy().from(elementMatrix);
    }

    @Override
    public Table<E> addColumnTitle(String columnTitle) {
        int columnIndex = this.getColumnTitleList().size();
        this.setColumnTitle(columnIndex, columnTitle);
        return this;
    }

    @Override
    public abstract Table<E> clone();

    @Override
    public Columns<E, Column<E>> columns() {
        final TableAbstract table = this;
        return new ColumnsImpl(IterableUtils.valueOf((Factory)new Factory<Iterator<Column<E>>>(){

            public Iterator<Column<E>> newInstance() {
                return new ColumnIterator(table);
            }
        }));
    }

    @Override
    public Iterator<ImmutableRow<E>> iterator() {
        boolean detached = false;
        return new RowIterator(this, false);
    }

    @Override
    public Rows<E, Row<E>> rows(final boolean detached) {
        final TableAbstract table = this;
        return new RowsImpl(IterableUtils.valueOf((Factory)new FactorySerializable<Iterator<Row<E>>>(){
            private static final long serialVersionUID = -8151494883227852607L;

            public Iterator<Row<E>> newInstance() {
                return new RowIterator(table, detached);
            }
        }));
    }

    @Override
    public Rows<E, Row<E>> rows() {
        final TableAbstract table = this;
        return new RowsImpl(IterableUtils.valueOf((Factory)new FactorySerializable<Iterator<Row<E>>>(){
            private static final long serialVersionUID = -8151494883227852607L;

            public Iterator<Row<E>> newInstance() {
                boolean detached = false;
                return new RowIterator(table, false);
            }
        }));
    }

    @Override
    public TableSerializer<E> serializer() {
        return new TableSerializerImpl(this, (ExceptionHandler)this.exceptionHandler);
    }

    @Override
    public Table<E> setExceptionHandler(ExceptionHandlerSerializable exceptionHandler) {
        this.exceptionHandler.setExceptionHandler((ExceptionHandler)ObjectUtils.defaultIfNull((Object)exceptionHandler, (Object)new ExceptionHandlerIgnoring()));
        return this;
    }

    @Override
    public TableTransformer<E> to() {
        return new TableTransformerImpl(this);
    }

    public String toString() {
        return this.to().string();
    }

    @Override
    public Row<E> newRow() {
        int rowIndex = this.rowSize();
        return this.row(rowIndex);
    }

    @Override
    public Row<E> lastRow() {
        return this.row(this.rowSize() - 1);
    }

    @Override
    public Rows<E, Row<E>> rows(int rowIndexFrom, int rowIndexTo) {
        BitSet filter = new BitSet();
        filter.set(rowIndexFrom, rowIndexTo);
        return this.rows(filter);
    }

    @Override
    public Table<E> setColumnTitles(String ... columnTitles) {
        this.setColumnTitles(Arrays.asList(columnTitles));
        return this;
    }

    @Override
    public Rows<E, Row<E>> rows(int rowIndexFrom, int rowIndexTo, boolean detached) {
        BitSet filter = new BitSet();
        filter.set(rowIndexFrom, rowIndexTo);
        return this.rows(filter, detached);
    }

    @Override
    public Rows<E, Row<E>> rows(BitSet filter, boolean detached) {
        return this.rows(detached).filtered(filter);
    }

    @Override
    public Rows<E, Row<E>> rows(BitSet filter) {
        return this.rows().filtered(filter);
    }

    @Override
    public Table<E> setRowTitles(String ... rowTitles) {
        return this.setRowTitles(Arrays.asList(rowTitles));
    }

    @Override
    public String[] getRowTitles() {
        return this.getRowTitleList().toArray(new String[0]);
    }

    @Override
    public Table<E> addRowElements(Map<String, E> columnToElementMap) {
        boolean createColumnTitleIfDontExists = true;
        return this.addRowElements(columnToElementMap, true);
    }

    static final class RowIterator<E, R extends ImmutableRow<E>>
    implements Iterator<R> {
        private int index = -1;
        private final int indexMax;
        private final Table<E> table;

        public RowIterator(Table<E> table, boolean isDetached) {
            this.table = table;
            this.indexMax = table.rowSize() - 1;
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 <= this.indexMax;
        }

        @Override
        public R next() {
            return (R)this.table.row(++this.index);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class ColumnIterator<E, C extends ImmutableColumn<E>>
    implements Iterator<C> {
        private int index = -1;
        private final int indexMax;
        private final Table<E> table;

        public ColumnIterator(Table<E> table) {
            this.table = table;
            this.indexMax = table.columnSize() - 1;
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 <= this.indexMax;
        }

        @Override
        public C next() {
            return (C)this.table.column(++this.index);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

