/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl;

import java.io.Serializable;
import java.util.BitSet;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.operation.OperationUtils;
import org.omnaest.utils.operation.special.OperationIntrinsic;
import org.omnaest.utils.operation.special.OperationWithResult;
import org.omnaest.utils.structure.array.ArrayUtils;
import org.omnaest.utils.table.TableEventHandler;
import org.omnaest.utils.table.impl.TableDataCore;
import org.omnaest.utils.table.impl.TableEventDispatcher;
import org.omnaest.utils.table.impl.TableMetaData;

class TableDataAccessor<E>
implements Serializable {
    private static final long serialVersionUID = -9123078800733926152L;
    private final AtomicLong modificationCounter = new AtomicLong();
    private final TableDataCore<E> tableDataCore;
    private final TableEventDispatcher<E> tableEventDispatcher;
    private final ReadWriteLock tableLock = new ReentrantReadWriteLock(true);
    private final TableMetaData<E> tableMetaData;

    public TableDataAccessor(TableDataCore<E> tableDataCore, TableEventDispatcher<E> tableEventDispatcher, TableMetaData<E> tableMetaData) {
        this.tableDataCore = tableDataCore;
        this.tableEventDispatcher = tableEventDispatcher;
        this.tableMetaData = tableMetaData;
        this.register(tableMetaData);
    }

    public void addColumn(final E ... elements) {
        OperationUtils.executeWithLocks((OperationIntrinsic)new OperationIntrinsic(){

            public void execute() {
                int rowIndex = TableDataAccessor.this.tableDataCore.addRow(elements);
                TableDataAccessor.this.modificationCounter.incrementAndGet();
                TableDataAccessor.this.tableEventDispatcher.handleAddedRow(rowIndex, elements);
            }
        }, (Lock[])new Lock[]{this.tableLock.writeLock()});
    }

    public void addColumn(final int columnIndex, final E ... elements) {
        OperationUtils.executeWithLocks((OperationIntrinsic)new OperationIntrinsic(){

            public void execute() {
                TableDataAccessor.this.tableDataCore.addColumn(columnIndex, elements);
                TableDataAccessor.this.modificationCounter.incrementAndGet();
                TableDataAccessor.this.tableEventDispatcher.handleAddedColumn(columnIndex, elements);
            }
        }, (Lock[])new Lock[]{this.tableLock.writeLock()});
    }

    public void addRow(final E[] elements) {
        OperationUtils.executeWithLocks((OperationIntrinsic)new OperationIntrinsic(){

            public void execute() {
                int rowIndex = TableDataAccessor.this.tableDataCore.addRow(elements);
                TableDataAccessor.this.modificationCounter.incrementAndGet();
                TableDataAccessor.this.tableEventDispatcher.handleAddedRow(rowIndex, elements);
            }
        }, (Lock[])new Lock[]{this.tableLock.writeLock()});
    }

    public void addRow(final int rowIndex, final E ... elements) {
        OperationUtils.executeWithLocks((OperationIntrinsic)new OperationIntrinsic(){

            public void execute() {
                TableDataAccessor.this.tableDataCore.addRow(rowIndex, elements);
                TableDataAccessor.this.modificationCounter.incrementAndGet();
                TableDataAccessor.this.tableEventDispatcher.handleAddedRow(rowIndex, elements);
            }
        }, (Lock[])new Lock[]{this.tableLock.writeLock()});
    }

    public void clear() {
        OperationUtils.executeWithLocks((OperationIntrinsic)new OperationIntrinsic(){

            public void execute() {
                TableDataAccessor.this.tableDataCore.clear();
                TableDataAccessor.this.modificationCounter.incrementAndGet();
                TableDataAccessor.this.tableEventDispatcher.handleClearTable();
            }
        }, (Lock[])new Lock[]{this.tableLock.writeLock()});
    }

    public int columnSize() {
        return (Integer)OperationUtils.executeWithLocks((OperationWithResult)new OperationWithResult<Integer>(){

            public Integer execute() {
                return TableDataAccessor.this.tableDataCore.columnSize();
            }
        }, (Lock[])new Lock[]{this.tableLock.readLock()});
    }

    public int getColumnIndex(final Pattern columnTitlePattern) {
        return (Integer)OperationUtils.executeWithLocks((OperationWithResult)new OperationWithResult<Integer>(){

            public Integer execute() {
                return TableDataAccessor.this.tableMetaData.getColumnIndex(columnTitlePattern);
            }
        }, (Lock[])new Lock[]{this.tableLock.readLock()});
    }

    public int getColumnIndex(final String columnTitle) {
        return (Integer)OperationUtils.executeWithLocks((OperationWithResult)new OperationWithResult<Integer>(){

            public Integer execute() {
                return TableDataAccessor.this.tableMetaData.getColumnIndex(columnTitle);
            }
        }, (Lock[])new Lock[]{this.tableLock.readLock()});
    }

    public BitSet getColumnIndexFilter(final Pattern columnTitlePattern) {
        return (BitSet)OperationUtils.executeWithLocks((OperationWithResult)new OperationWithResult<BitSet>(){

            public BitSet execute() {
                return TableDataAccessor.this.tableMetaData.getColumnIndexFilter(columnTitlePattern);
            }
        }, (Lock[])new Lock[]{this.tableLock.readLock()});
    }

    public BitSet getColumnIndexFilter(final Set<String> columnTitleSet) {
        return (BitSet)OperationUtils.executeWithLocks((OperationWithResult)new OperationWithResult<BitSet>(){

            public BitSet execute() {
                return TableDataAccessor.this.tableMetaData.getColumnIndexFilter(columnTitleSet);
            }
        }, (Lock[])new Lock[]{this.tableLock.readLock()});
    }

    public String getColumnTitle(final int columnIndex) {
        return (String)OperationUtils.executeWithLocks((OperationWithResult)new OperationWithResult<String>(){

            public String execute() {
                return TableDataAccessor.this.tableMetaData.getColumnTitle(columnIndex);
            }
        }, (Lock[])new Lock[]{this.tableLock.readLock()});
    }

    public List<String> getColumnTitleList() {
        return (List)OperationUtils.executeWithLocks((OperationWithResult)new OperationWithResult<List<String>>(){

            public List<String> execute() {
                return TableDataAccessor.this.tableMetaData.getColumnTitleList();
            }
        }, (Lock[])new Lock[]{this.tableLock.readLock()});
    }

    public E getElement(final int rowIndex, final int columnIndex) {
        return (E)OperationUtils.executeWithLocks((OperationWithResult)new OperationWithResult<E>(){

            public E execute() {
                return TableDataAccessor.this.tableDataCore.getElement(rowIndex, columnIndex);
            }
        }, (Lock[])new Lock[]{this.tableLock.readLock()});
    }

    public int getRowIndex(final String rowTitle) {
        return (Integer)OperationUtils.executeWithLocks((OperationWithResult)new OperationWithResult<Integer>(){

            public Integer execute() {
                return TableDataAccessor.this.tableMetaData.getRowIndex(rowTitle);
            }
        }, (Lock[])new Lock[]{this.tableLock.readLock()});
    }

    public String getRowTitle(final int rowIndex) {
        return (String)OperationUtils.executeWithLocks((OperationWithResult)new OperationWithResult<String>(){

            public String execute() {
                return TableDataAccessor.this.tableMetaData.getRowTitle(rowIndex);
            }
        }, (Lock[])new Lock[]{this.tableLock.readLock()});
    }

    public List<String> getRowTitleList() {
        return (List)OperationUtils.executeWithLocks((OperationWithResult)new OperationWithResult<List<String>>(){

            public List<String> execute() {
                return TableDataAccessor.this.tableMetaData.getRowTitleList();
            }
        }, (Lock[])new Lock[]{this.tableLock.readLock()});
    }

    public ReadWriteLock getTableLock() {
        return this.tableLock;
    }

    public String getTableName() {
        return (String)OperationUtils.executeWithLocks((OperationWithResult)new OperationWithResult<String>(){

            public String execute() {
                return TableDataAccessor.this.tableMetaData.getTableName();
            }
        }, (Lock[])new Lock[]{this.tableLock.readLock()});
    }

    public boolean hasColumnTitles() {
        return (Boolean)OperationUtils.executeWithLocks((OperationWithResult)new OperationWithResult<Boolean>(){

            public Boolean execute() {
                return TableDataAccessor.this.tableMetaData.hasColumnTitles();
            }
        }, (Lock[])new Lock[]{this.tableLock.readLock()});
    }

    public boolean hasRowTitles() {
        return (Boolean)OperationUtils.executeWithLocks((OperationWithResult)new OperationWithResult<Boolean>(){

            public Boolean execute() {
                return TableDataAccessor.this.tableMetaData.hasRowTitles();
            }
        }, (Lock[])new Lock[]{this.tableLock.readLock()});
    }

    public boolean hasTableName() {
        return (Boolean)OperationUtils.executeWithLocks((OperationWithResult)new OperationWithResult<Boolean>(){

            public Boolean execute() {
                return TableDataAccessor.this.tableMetaData.hasTableName();
            }
        }, (Lock[])new Lock[]{this.tableLock.readLock()});
    }

    public ModificationValidator newModificationValidator() {
        return new ModificationValidator();
    }

    public <T extends TableEventHandler<E>> T register(T tableEventHandler) {
        this.tableEventDispatcher.add(tableEventHandler);
        return tableEventHandler;
    }

    public <T extends TableEventHandler<E>> T unregister(T tableEventHandler) {
        this.tableEventDispatcher.remove(tableEventHandler);
        return tableEventHandler;
    }

    public void removeColumn(final int columnIndex) {
        OperationUtils.executeWithLocks((OperationIntrinsic)new OperationIntrinsic(){

            public void execute() {
                E[] previousElements = TableDataAccessor.this.tableDataCore.removeColumn(columnIndex);
                String columnTitle = TableDataAccessor.this.getColumnTitle(columnIndex);
                TableDataAccessor.this.modificationCounter.incrementAndGet();
                TableDataAccessor.this.tableEventDispatcher.handleRemovedColumn(columnIndex, previousElements, columnTitle);
            }
        }, (Lock[])new Lock[]{this.tableLock.writeLock()});
    }

    public void removeRow(final int rowIndex) {
        OperationUtils.executeWithLocks((OperationIntrinsic)new OperationIntrinsic(){

            public void execute() {
                E[] previousElements = TableDataAccessor.this.tableDataCore.removeRow(rowIndex);
                String rowTitle = TableDataAccessor.this.getRowTitle(rowIndex);
                TableDataAccessor.this.modificationCounter.incrementAndGet();
                TableDataAccessor.this.tableEventDispatcher.handleRemovedRow(rowIndex, previousElements, rowTitle);
            }
        }, (Lock[])new Lock[]{this.tableLock.writeLock()});
    }

    public int rowSize() {
        return (Integer)OperationUtils.executeWithLocks((OperationWithResult)new OperationWithResult<Integer>(){

            public Integer execute() {
                return TableDataAccessor.this.tableDataCore.rowSize();
            }
        }, (Lock[])new Lock[]{this.tableLock.readLock()});
    }

    public void set(final E element, final int rowIndex, final int columnIndex) {
        OperationUtils.executeWithLocks((OperationIntrinsic)new OperationIntrinsic(){

            public void execute() {
                Object previousElement = TableDataAccessor.this.tableDataCore.set(element, rowIndex, columnIndex);
                TableDataAccessor.this.modificationCounter.incrementAndGet();
                if (!ObjectUtils.equals((Object)element, (Object)previousElement)) {
                    TableDataAccessor.this.tableEventDispatcher.handleUpdatedCell(rowIndex, columnIndex, element, previousElement);
                }
            }
        }, (Lock[])new Lock[]{this.tableLock.writeLock()});
    }

    public void setColumnTitle(final int columnIndex, final String columnTitle) {
        OperationUtils.executeWithLocks((OperationWithResult)new OperationWithResult<Void>(){

            public Void execute() {
                String columnTitlePrevious = TableDataAccessor.this.tableMetaData.setColumnTitle(columnIndex, columnTitle);
                TableDataAccessor.this.tableEventDispatcher.handleModifiedColumnTitle(columnIndex, columnTitle, columnTitlePrevious);
                return null;
            }
        }, (Lock[])new Lock[]{this.tableLock.writeLock()});
    }

    public void setColumnTitles(final Iterable<String> columnTitleIterable) {
        OperationUtils.executeWithLocks((OperationWithResult)new OperationWithResult<Void>(){

            public Void execute() {
                String[] columnTitles = (String[])ArrayUtils.valueOf((Iterable)columnTitleIterable, String.class);
                String[] columnTitlesPrevious = TableDataAccessor.this.tableMetaData.setColumnTitles(columnTitles);
                TableDataAccessor.this.tableEventDispatcher.handleModifiedColumnTitles(columnTitles, columnTitlesPrevious);
                return null;
            }
        }, (Lock[])new Lock[]{this.tableLock.writeLock()});
    }

    public TableDataAccessor<E> setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.tableEventDispatcher.setExceptionHandler(exceptionHandler);
        return this;
    }

    public void setRow(final int rowIndex, final E ... elements) {
        OperationUtils.executeWithLocks((OperationIntrinsic)new OperationIntrinsic(){

            public void execute() {
                Object[] previousElements = TableDataAccessor.this.tableDataCore.setRow(rowIndex, elements);
                TableDataAccessor.this.modificationCounter.incrementAndGet();
                BitSet modifiedIndices = ArrayUtils.differenceBitSet((Object[])elements, (Object[])previousElements);
                if (modifiedIndices.cardinality() > 0) {
                    TableDataAccessor.this.tableEventDispatcher.handleUpdatedRow(rowIndex, elements, previousElements, modifiedIndices);
                }
            }
        }, (Lock[])new Lock[]{this.tableLock.writeLock()});
    }

    public void setRowTitle(final int rowIndex, final String rowTitle) {
        OperationUtils.executeWithLocks((OperationWithResult)new OperationWithResult<Void>(){

            public Void execute() {
                String rowTitlePrevious = TableDataAccessor.this.tableMetaData.setRowTitle(rowIndex, rowTitle);
                TableDataAccessor.this.tableEventDispatcher.handleModifiedRowTitle(rowIndex, rowTitle, rowTitlePrevious);
                return null;
            }
        }, (Lock[])new Lock[]{this.tableLock.writeLock()});
    }

    public void setRowTitles(final Iterable<String> rowTitleIterable) {
        OperationUtils.executeWithLocks((OperationWithResult)new OperationWithResult<Void>(){

            public Void execute() {
                String[] rowTitles = (String[])ArrayUtils.valueOf((Iterable)rowTitleIterable, String.class);
                String[] rowTitlesPrevious = TableDataAccessor.this.tableMetaData.setRowTitles(rowTitles);
                TableDataAccessor.this.tableEventDispatcher.handleModifiedRowTitles(rowTitles, rowTitlesPrevious);
                return null;
            }
        }, (Lock[])new Lock[]{this.tableLock.writeLock()});
    }

    public void setTableName(final String tableName) {
        OperationUtils.executeWithLocks((OperationWithResult)new OperationWithResult<Void>(){

            public Void execute() {
                String tableNamePrevious = TableDataAccessor.this.tableMetaData.setTableName(tableName);
                TableDataAccessor.this.tableEventDispatcher.handleModifiedTableName(tableName, tableNamePrevious);
                return null;
            }
        }, (Lock[])new Lock[]{this.tableLock.writeLock()});
    }

    public class ModificationValidator {
        private long modificationCounterAtCreationTime;

        public ModificationValidator() {
            this.modificationCounterAtCreationTime = TableDataAccessor.this.modificationCounter.get();
        }

        public boolean hasBeenModified() {
            return this.modificationCounterAtCreationTime != TableDataAccessor.this.modificationCounter.get();
        }

        public void validateForNoModification() throws ConcurrentModificationException {
            if (this.hasBeenModified()) {
                throw new ConcurrentModificationException("Table data has been modified");
            }
        }
    }
}

