/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.BitSet;

class TableDataCore<E>
implements Serializable {
    public static final int INITIAL_DEFAULT_COLUMN_SIZE = 4;
    public static final int INITIAL_DEFAULT_ROW_SIZE = 16;
    private static final long serialVersionUID = 5131972948341159104L;
    private BitSet activeColumnBitSet;
    private BitSet activeRowBitSet;
    private int columnSize;
    private final int initialColumnSize;
    private final int initialRowSize;
    private E[][] matrix;
    private int[] nativeColumnIndices;
    private int[] nativeRowIndices;
    private int rowSize;
    private final Class<E> type;

    TableDataCore(Class<? extends E> type) {
        this.type = type;
        this.initialRowSize = 16;
        this.initialColumnSize = 4;
        this.initialize(type, this.initialRowSize, this.initialColumnSize);
    }

    TableDataCore(Class<? extends E> type, int initialRowSize, int initialColumnSize) {
        this.initialRowSize = initialRowSize;
        this.initialColumnSize = initialColumnSize;
        this.type = type;
        this.initialize(type, initialRowSize, initialColumnSize);
    }

    public int addColumn(E ... elements) {
        int columnIndex = this.columnSize;
        return this.addColumn(columnIndex, elements);
    }

    public int addColumn(int columnIndex, E ... elements) {
        int nativeColumnIndex;
        int ii;
        int retval = -1;
        int lastColumnIndex = this.columnSize;
        boolean isLastRow = columnIndex == lastColumnIndex;
        this.ensureColumnSize(lastColumnIndex + 1);
        this.ensureRowSize(elements.length);
        if (!isLastRow) {
            int nativeLastColumnIndex = this.determineNativeColumnIndex(lastColumnIndex);
            for (ii = this.nativeColumnIndices.length - 1; ii > columnIndex && ii > 0; --ii) {
                this.nativeColumnIndices[ii] = this.nativeColumnIndices[ii - 1];
            }
            this.nativeColumnIndices[columnIndex] = nativeLastColumnIndex;
        }
        if ((nativeColumnIndex = this.determineNativeColumnIndex(lastColumnIndex)) >= 0) {
            for (ii = 0; ii < elements.length; ++ii) {
                int nativeRowIndex = this.determineNativeRowIndex(ii);
                this.matrix[nativeRowIndex][nativeColumnIndex] = elements[ii];
            }
            retval = lastColumnIndex;
        }
        return retval;
    }

    public int addRow(E ... elements) {
        int rowIndex = this.rowSize;
        return this.addRow(rowIndex, elements);
    }

    public int addRow(int rowIndex, E ... elements) {
        int nativeRowIndex;
        int ii;
        boolean isLastRow;
        int retval = -1;
        int lastRowIndex = this.rowSize;
        boolean bl = isLastRow = rowIndex == lastRowIndex;
        if (elements == null) {
            elements = this.newArray(0);
        }
        this.ensureColumnSize(elements.length);
        this.ensureRowSize(this.rowSize + 1);
        if (!isLastRow) {
            int nativeLastRowIndex = this.determineNativeRowIndex(lastRowIndex);
            for (ii = this.nativeRowIndices.length - 1; ii > rowIndex && ii > 0; --ii) {
                this.nativeRowIndices[ii] = this.nativeRowIndices[ii - 1];
            }
            this.nativeRowIndices[rowIndex] = nativeLastRowIndex;
        }
        if ((nativeRowIndex = this.determineNativeRowIndex(rowIndex)) >= 0) {
            for (ii = 0; ii < elements.length; ++ii) {
                int nativeColumnIndex = this.determineNativeColumnIndex(ii);
                this.matrix[nativeRowIndex][nativeColumnIndex] = elements[ii];
            }
            retval = rowIndex;
        }
        return retval;
    }

    public void clear() {
        this.initialize(this.type, this.initialRowSize, this.initialColumnSize);
    }

    public int columnSize() {
        return this.columnSize;
    }

    private void compactColumnsIfNecessary(int columnMaxSize) {
        if (this.columnSize < columnMaxSize / 4) {
            if (this.columnSize > 0) {
                int lowerNativeColumnIndex = -1;
                int upperNativeColumnIndex = this.nativeColumnIndices.length - 1;
                while ((lowerNativeColumnIndex = this.activeColumnBitSet.nextClearBit(lowerNativeColumnIndex + 1)) < upperNativeColumnIndex) {
                    int ii;
                    while (upperNativeColumnIndex > lowerNativeColumnIndex && !this.activeColumnBitSet.get(upperNativeColumnIndex)) {
                        --upperNativeColumnIndex;
                    }
                    if (lowerNativeColumnIndex >= upperNativeColumnIndex) continue;
                    for (ii = 0; ii < this.nativeColumnIndices.length; ++ii) {
                        if (this.nativeColumnIndices[ii] != upperNativeColumnIndex) continue;
                        this.nativeColumnIndices[ii] = lowerNativeColumnIndex;
                        break;
                    }
                    this.activeColumnBitSet.clear(upperNativeColumnIndex);
                    this.activeColumnBitSet.set(lowerNativeColumnIndex);
                    for (ii = 0; ii < this.nativeRowIndices.length; ++ii) {
                        E element = this.matrix[ii][upperNativeColumnIndex];
                        this.matrix[ii][upperNativeColumnIndex] = this.matrix[ii][lowerNativeColumnIndex];
                        this.matrix[ii][lowerNativeColumnIndex] = element;
                    }
                }
            }
            int newColumnMaxSize = columnMaxSize / 2;
            this.nativeColumnIndices = Arrays.copyOf(this.nativeColumnIndices, newColumnMaxSize);
            this.activeColumnBitSet.clear(newColumnMaxSize, columnMaxSize - 1);
            for (int ii = 0; ii < this.nativeRowIndices.length; ++ii) {
                this.matrix[ii] = Arrays.copyOf(this.matrix[ii], newColumnMaxSize);
            }
        }
    }

    private void compactRowsIfNecessary(int rowMaxSize) {
        if (this.rowSize < rowMaxSize / 4) {
            if (this.rowSize > 0) {
                int lowerNativeRowIndex = -1;
                int upperNativeRowIndex = this.nativeRowIndices.length - 1;
                while ((lowerNativeRowIndex = this.activeRowBitSet.nextClearBit(lowerNativeRowIndex + 1)) < upperNativeRowIndex) {
                    while (upperNativeRowIndex > lowerNativeRowIndex && !this.activeRowBitSet.get(upperNativeRowIndex)) {
                        --upperNativeRowIndex;
                    }
                    if (lowerNativeRowIndex >= upperNativeRowIndex) continue;
                    for (int ii = 0; ii < this.nativeRowIndices.length; ++ii) {
                        if (this.nativeRowIndices[ii] != upperNativeRowIndex) continue;
                        this.nativeRowIndices[ii] = lowerNativeRowIndex;
                        break;
                    }
                    this.activeRowBitSet.clear(upperNativeRowIndex);
                    this.activeRowBitSet.set(lowerNativeRowIndex);
                    E[] upperRow = this.matrix[upperNativeRowIndex];
                    this.matrix[upperNativeRowIndex] = this.matrix[lowerNativeRowIndex];
                    this.matrix[lowerNativeRowIndex] = upperRow;
                }
            }
            int newRowMaxSize = rowMaxSize / 2;
            this.nativeRowIndices = Arrays.copyOf(this.nativeRowIndices, newRowMaxSize);
            this.activeRowBitSet.clear(newRowMaxSize, rowMaxSize - 1);
            this.matrix = (Object[][])Arrays.copyOf(this.matrix, newRowMaxSize);
        }
    }

    private int determineNativeColumnIndex(int columnIndex) {
        return columnIndex < 0 || columnIndex >= this.columnSize ? -1 : this.nativeColumnIndices[columnIndex];
    }

    private int determineNativeRowIndex(int rowIndex) {
        return rowIndex < 0 || rowIndex >= this.rowSize ? -1 : this.nativeRowIndices[rowIndex];
    }

    private void ensureColumnSize(int columnSize) {
        int columnMaxSize;
        while (columnSize > (columnMaxSize = this.nativeColumnIndices.length)) {
            int newColumnMaxSize = columnMaxSize * 2;
            this.nativeColumnIndices = Arrays.copyOf(this.nativeColumnIndices, newColumnMaxSize);
            for (int iRowIndex = 0; iRowIndex < this.matrix.length; ++iRowIndex) {
                this.matrix[iRowIndex] = Arrays.copyOf(this.matrix[iRowIndex], newColumnMaxSize);
            }
        }
        for (int iColumnIndex = this.columnSize; iColumnIndex < columnSize; ++iColumnIndex) {
            int nativeColumnIndex;
            this.nativeColumnIndices[iColumnIndex] = nativeColumnIndex = this.activeColumnBitSet.nextClearBit(0);
            this.activeColumnBitSet.set(nativeColumnIndex);
            ++this.columnSize;
        }
    }

    private void ensureRowSize(int rowSize) {
        int rowMaxSize;
        while (rowSize > (rowMaxSize = this.nativeRowIndices.length)) {
            int newRowMaxSize = rowMaxSize * 2;
            this.nativeRowIndices = Arrays.copyOf(this.nativeRowIndices, newRowMaxSize);
            this.matrix = (Object[][])Arrays.copyOf(this.matrix, newRowMaxSize);
            for (int iRowIndex = rowMaxSize; iRowIndex < newRowMaxSize; ++iRowIndex) {
                this.matrix[iRowIndex] = this.newArray(this.nativeColumnIndices.length);
            }
        }
        for (int iRowIndex = this.rowSize; iRowIndex < rowSize; ++iRowIndex) {
            int nativeRowIndex;
            this.nativeRowIndices[iRowIndex] = nativeRowIndex = this.activeRowBitSet.nextClearBit(0);
            this.activeRowBitSet.set(nativeRowIndex);
            ++this.rowSize;
        }
    }

    public E[] getColumn(int columnIndex) {
        E[] retval = this.newArray(this.rowSize);
        for (int iRowIndex = 0; iRowIndex < this.rowSize; ++iRowIndex) {
            retval[iRowIndex] = this.getElement(iRowIndex, columnIndex);
        }
        return retval;
    }

    public E getElement(int rowIndex, int columnIndex) {
        E retval = null;
        int nativeRowIndex = this.determineNativeRowIndex(rowIndex);
        int nativeColumnIndex = this.determineNativeColumnIndex(columnIndex);
        if (nativeRowIndex >= 0 && nativeColumnIndex >= 0) {
            boolean activeRow = this.activeRowBitSet.get(nativeRowIndex);
            boolean activeColumn = this.activeColumnBitSet.get(nativeColumnIndex);
            if (activeRow && activeColumn) {
                retval = this.matrix[nativeRowIndex][nativeColumnIndex];
            }
        }
        return retval;
    }

    public E[] getRow(int rowIndex) {
        E[] retval = this.newArray(this.columnSize);
        for (int iColumnIndex = 0; iColumnIndex < this.columnSize; ++iColumnIndex) {
            retval[iColumnIndex] = this.getElement(rowIndex, iColumnIndex);
        }
        return retval;
    }

    private void initialize(Class<? extends E> type, int initialRowSize, int initialColumnSize) {
        this.matrix = (Object[][])Array.newInstance(type, initialRowSize, initialColumnSize);
        this.nativeColumnIndices = new int[initialColumnSize];
        this.nativeRowIndices = new int[initialRowSize];
        this.activeColumnBitSet = new BitSet(initialColumnSize);
        this.activeRowBitSet = new BitSet(initialRowSize);
        this.rowSize = 0;
        this.columnSize = 0;
    }

    private E[] newArray(int size) {
        return (Object[])Array.newInstance(this.type, size);
    }

    public E[] removeColumn(int columnIndex) {
        E[] retvals = null;
        int nativeColumnIndex = this.determineNativeColumnIndex(columnIndex);
        int columnMaxSize = this.nativeColumnIndices.length;
        if (nativeColumnIndex >= 0) {
            boolean isActiveColumn = this.activeColumnBitSet.get(nativeColumnIndex);
            if (isActiveColumn) {
                int ii;
                retvals = this.newArray(this.rowSize);
                for (ii = 0; ii < retvals.length; ++ii) {
                    int nativeRowIndex = this.determineNativeRowIndex(ii);
                    retvals[ii] = this.matrix[nativeRowIndex][nativeColumnIndex];
                }
                for (ii = 0; ii < this.nativeRowIndices.length; ++ii) {
                    this.matrix[ii][nativeColumnIndex] = null;
                }
            }
            this.activeColumnBitSet.clear(nativeColumnIndex);
            for (int iColumnIndex = columnIndex; iColumnIndex < columnMaxSize - 1; ++iColumnIndex) {
                this.nativeColumnIndices[iColumnIndex] = this.nativeColumnIndices[iColumnIndex + 1];
            }
            this.nativeColumnIndices[columnMaxSize - 1] = 0;
            --this.columnSize;
        }
        this.compactColumnsIfNecessary(columnMaxSize);
        return retvals;
    }

    public E[] removeRow(int rowIndex) {
        E[] retvals = null;
        int nativeRowIndex = this.determineNativeRowIndex(rowIndex);
        int rowMaxSize = this.nativeRowIndices.length;
        if (nativeRowIndex >= 0) {
            boolean activeRow = this.activeRowBitSet.get(nativeRowIndex);
            if (activeRow) {
                retvals = this.newArray(this.columnSize);
                for (int ii = 0; ii < retvals.length; ++ii) {
                    int nativeColumnIndex = this.determineNativeColumnIndex(ii);
                    retvals[ii] = this.matrix[nativeRowIndex][nativeColumnIndex];
                }
                Arrays.fill(this.matrix[nativeRowIndex], null);
            }
            this.activeRowBitSet.clear(nativeRowIndex);
            for (int iRowIndex = rowIndex; iRowIndex < rowMaxSize - 1; ++iRowIndex) {
                this.nativeRowIndices[iRowIndex] = this.nativeRowIndices[iRowIndex + 1];
            }
            this.nativeRowIndices[rowMaxSize - 1] = 0;
            --this.rowSize;
        }
        this.compactRowsIfNecessary(rowMaxSize);
        return retvals;
    }

    public int rowSize() {
        return this.rowSize;
    }

    public E set(E element, int rowIndex, int columnIndex) {
        E retval = null;
        this.ensureColumnSize(columnIndex + 1);
        this.ensureRowSize(rowIndex + 1);
        int nativeColumnIndex = this.determineNativeColumnIndex(columnIndex);
        int nativeRowIndex = this.determineNativeRowIndex(rowIndex);
        if (nativeColumnIndex >= 0 && nativeRowIndex >= 0) {
            retval = this.matrix[nativeRowIndex][nativeColumnIndex];
            this.matrix[nativeRowIndex][nativeColumnIndex] = element;
        }
        return retval;
    }

    public E[] setRow(int rowIndex, E ... elements) {
        E[] retval = null;
        while (this.rowSize <= rowIndex) {
            this.addRow(new Object[0]);
        }
        this.ensureColumnSize(elements != null ? elements.length : 0);
        this.ensureRowSize(this.rowSize);
        int nativeRowIndex = this.determineNativeRowIndex(rowIndex);
        if (nativeRowIndex >= 0) {
            retval = Arrays.copyOfRange(this.matrix[nativeRowIndex], 0, this.columnSize);
            this.matrix[nativeRowIndex] = this.newArray(this.nativeColumnIndices.length);
            if (elements != null) {
                for (int ii = 0; ii < elements.length; ++ii) {
                    this.matrix[nativeRowIndex][ii] = elements[ii];
                }
            }
        }
        return retval;
    }

    public int size() {
        return this.columnSize * this.rowSize;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TableDataCore [matrix=\n");
        for (Object[] objectArray : this.matrix) {
            builder.append(Arrays.deepToString(objectArray) + "\n");
        }
        builder.append(", \nnativeColumnIndices=");
        builder.append(Arrays.toString(this.nativeColumnIndices));
        builder.append(", \nnativeRowIndices=");
        builder.append(Arrays.toString(this.nativeRowIndices));
        builder.append(", \nactiveRowBitSet=");
        builder.append(this.activeRowBitSet);
        builder.append(", \nactiveColumnBitSet=");
        builder.append(this.activeColumnBitSet);
        builder.append(", \nrowSize=");
        builder.append(this.rowSize);
        builder.append(", columnSize=");
        builder.append(this.columnSize);
        builder.append(", type=");
        builder.append(this.type);
        builder.append("]");
        return builder.toString();
    }
}

