/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.events.exception.basic.ExceptionHandlerIgnoring;
import org.omnaest.utils.operation.special.OperationVoid;
import org.omnaest.utils.structure.element.ObjectUtils;
import org.omnaest.utils.table.TableEventHandler;

class TableEventDispatcher<E>
implements TableEventHandler<E>,
Serializable {
    private static final long serialVersionUID = -8336460926560156773L;
    private final transient List<WeakReference<TableEventHandler<E>>> tableEventHandlerReferenceList;
    private ExceptionHandler exceptionHandler = new ExceptionHandlerIgnoring();

    TableEventDispatcher() {
        this.tableEventHandlerReferenceList = new CopyOnWriteArrayList<WeakReference<TableEventHandler<E>>>();
    }

    public void add(TableEventHandler<E> tableEventHandler) {
        if (tableEventHandler != null) {
            this.tableEventHandlerReferenceList.add(new WeakReference<TableEventHandler<E>>(tableEventHandler));
        }
    }

    public void remove(TableEventHandler<E> tableEventHandler) {
        if (tableEventHandler != null) {
            for (WeakReference<TableEventHandler<E>> reference : this.tableEventHandlerReferenceList) {
                if (tableEventHandler != reference.get()) continue;
                this.tableEventHandlerReferenceList.remove(reference);
                break;
            }
        }
    }

    private void executeOnAllInstances(OperationVoid<TableEventHandler<E>> operation) {
        if (operation != null) {
            ArrayList<WeakReference<TableEventHandler<E>>> removableInstanceList = new ArrayList<WeakReference<TableEventHandler<E>>>();
            for (WeakReference<TableEventHandler<E>> reference : this.tableEventHandlerReferenceList) {
                if (reference == null) continue;
                TableEventHandler tableEventHandler = (TableEventHandler)reference.get();
                if (tableEventHandler == null) {
                    removableInstanceList.add(reference);
                    continue;
                }
                try {
                    operation.execute((Object)tableEventHandler);
                }
                catch (Exception e) {
                    this.exceptionHandler.handleException(e);
                }
            }
            this.tableEventHandlerReferenceList.removeAll(removableInstanceList);
        }
    }

    @Override
    public void handleAddedColumn(final int columnIndex, final E ... elements) {
        this.executeOnAllInstances(new OperationVoid<TableEventHandler<E>>(){

            public void execute(TableEventHandler<E> tableEventHandler) {
                tableEventHandler.handleAddedColumn(columnIndex, elements);
            }
        });
    }

    @Override
    public void handleAddedRow(final int rowIndex, final E ... elements) {
        this.executeOnAllInstances(new OperationVoid<TableEventHandler<E>>(){

            public void execute(TableEventHandler<E> tableEventHandler) {
                tableEventHandler.handleAddedRow(rowIndex, elements);
            }
        });
    }

    @Override
    public void handleClearTable() {
        this.executeOnAllInstances(new OperationVoid<TableEventHandler<E>>(){

            public void execute(TableEventHandler<E> tableEventHandler) {
                tableEventHandler.handleClearTable();
            }
        });
    }

    @Override
    public void handleRemovedColumn(final int columnIndex, final E[] previousElements, final String columnTitle) {
        this.executeOnAllInstances(new OperationVoid<TableEventHandler<E>>(){

            public void execute(TableEventHandler<E> tableEventHandler) {
                tableEventHandler.handleRemovedColumn(columnIndex, previousElements, columnTitle);
            }
        });
    }

    @Override
    public void handleRemovedRow(final int rowIndex, final E[] previousElements, final String rowTitle) {
        this.executeOnAllInstances(new OperationVoid<TableEventHandler<E>>(){

            public void execute(TableEventHandler<E> tableEventHandler) {
                tableEventHandler.handleRemovedRow(rowIndex, previousElements, rowTitle);
            }
        });
    }

    @Override
    public void handleUpdatedCell(final int rowIndex, final int columnIndex, final E element, final E previousElement) {
        this.executeOnAllInstances(new OperationVoid<TableEventHandler<E>>(){

            public void execute(TableEventHandler<E> tableEventHandler) {
                tableEventHandler.handleUpdatedCell(rowIndex, columnIndex, element, previousElement);
            }
        });
    }

    @Override
    public void handleUpdatedRow(final int rowIndex, final E[] elements, final E[] previousElements, final BitSet modifiedIndices) {
        this.executeOnAllInstances(new OperationVoid<TableEventHandler<E>>(){

            public void execute(TableEventHandler<E> tableEventHandler) {
                tableEventHandler.handleUpdatedRow(rowIndex, elements, previousElements, modifiedIndices);
            }
        });
    }

    private Object readResolve() throws ObjectStreamException {
        return new TableEventDispatcher<E>();
    }

    public TableEventDispatcher<E> setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = (ExceptionHandler)ObjectUtils.defaultIfNull((Object)exceptionHandler, (Object)new ExceptionHandlerIgnoring());
        return this;
    }

    @Override
    public void handleModifiedColumnTitle(final int columnIndex, final String columnTitle, final String columnTitlePrevious) {
        this.executeOnAllInstances(new OperationVoid<TableEventHandler<E>>(){

            public void execute(TableEventHandler<E> tableEventHandler) {
                tableEventHandler.handleModifiedColumnTitle(columnIndex, columnTitle, columnTitlePrevious);
            }
        });
    }

    @Override
    public void handleModifiedRowTitle(final int rowIndex, final String rowTitle, final String rowTitlePrevious) {
        this.executeOnAllInstances(new OperationVoid<TableEventHandler<E>>(){

            public void execute(TableEventHandler<E> tableEventHandler) {
                tableEventHandler.handleModifiedRowTitle(rowIndex, rowTitle, rowTitlePrevious);
            }
        });
    }

    @Override
    public void handleModifiedColumnTitles(final String[] columnTitles, final String[] columnTitlesPrevious) {
        this.executeOnAllInstances(new OperationVoid<TableEventHandler<E>>(){

            public void execute(TableEventHandler<E> tableEventHandler) {
                tableEventHandler.handleModifiedColumnTitles(columnTitles, columnTitlesPrevious);
            }
        });
    }

    @Override
    public void handleModifiedRowTitles(final String[] rowTitles, final String[] rowTitlesPrevious) {
        this.executeOnAllInstances(new OperationVoid<TableEventHandler<E>>(){

            public void execute(TableEventHandler<E> tableEventHandler) {
                tableEventHandler.handleModifiedRowTitles(rowTitles, rowTitlesPrevious);
            }
        });
    }

    @Override
    public void handleModifiedTableName(final String tableName, final String tableNamePrevious) {
        this.executeOnAllInstances(new OperationVoid<TableEventHandler<E>>(){

            public void execute(TableEventHandler<E> tableEventHandler) {
                tableEventHandler.handleModifiedTableName(tableName, tableNamePrevious);
            }
        });
    }
}

