/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.lang3.ObjectUtils;
import org.omnaest.utils.structure.collection.CollectionUtils;
import org.omnaest.utils.structure.collection.set.SetUtils;
import org.omnaest.utils.structure.element.KeyExtractor;
import org.omnaest.utils.structure.element.converter.ElementBidirectionalConverter;
import org.omnaest.utils.structure.element.converter.ElementBidirectionalConverterSerializable;
import org.omnaest.utils.structure.element.converter.ElementBidirectionalConverterSetToUnmodifiableSet;
import org.omnaest.utils.structure.element.factory.Factory;
import org.omnaest.utils.structure.element.factory.concrete.LinkedHashSetFactory;
import org.omnaest.utils.structure.map.MapUtils;
import org.omnaest.utils.table.Row;
import org.omnaest.utils.table.RowDataReader;
import org.omnaest.utils.table.Table;
import org.omnaest.utils.table.TableEventHandler;
import org.omnaest.utils.table.impl.rowdata.ElementsToRowDataReaderAdapter;
import org.omnaest.utils.table.impl.rowdata.RowToRowDataAccessorAdapter;

class TableIndexArbitraryImpl<K, E>
implements SortedMap<K, Set<Row<E>>>,
TableEventHandler<E>,
Serializable {
    private static final long serialVersionUID = -8584025610784755115L;
    private final SortedMap<K, Set<Row<E>>> keyToRowSetMap;
    private final KeyExtractor<K, RowDataReader<E>> keyExtractor;
    private final Table<E> table;

    TableIndexArbitraryImpl(Table<E> table, KeyExtractor<K, RowDataReader<E>> keyExtractor, Comparator<K> comparator) {
        this.table = table;
        this.keyExtractor = keyExtractor;
        this.keyToRowSetMap = MapUtils.initializedSortedMap(new ConcurrentSkipListMap(), (Factory)new LinkedHashSetFactory());
        this.rebuildIndexFully();
    }

    private void rebuildIndexFully() {
        this.keyToRowSetMap.clear();
        for (Row row : this.table.rows()) {
            K key = this.extractKey(row);
            ((Set)this.keyToRowSetMap.get(key)).add(row);
        }
    }

    private K extractKey(Row<E> row) {
        RowToRowDataAccessorAdapter<E> rowDataReader = new RowToRowDataAccessorAdapter<E>(row);
        Object key = this.keyExtractor.extractKey(rowDataReader);
        return (K)key;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.keyToRowSetMap.comparator();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyToRowSetMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.keyToRowSetMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, Set<Row<E>>>> entrySet() {
        return Collections.unmodifiableSet(SetUtils.adapter(this.keyToRowSetMap.entrySet(), (ElementBidirectionalConverter)new ElementBidirectionalConverterSerializable<Map.Entry<K, Set<Row<E>>>, Map.Entry<K, Set<Row<E>>>>(){
            private static final long serialVersionUID = 1170906776959603812L;

            public Map.Entry<K, Set<Row<E>>> convert(final Map.Entry<K, Set<Row<E>>> entry) {
                return new Map.Entry<K, Set<Row<E>>>(){

                    @Override
                    public K getKey() {
                        return entry.getKey();
                    }

                    @Override
                    public Set<Row<E>> getValue() {
                        return Collections.unmodifiableSet((Set)entry.getValue());
                    }

                    @Override
                    public Set<Row<E>> setValue(Set<Row<E>> value) {
                        throw new UnsupportedOperationException();
                    }

                    public String toString() {
                        return String.valueOf(this.getKey()) + "=" + String.valueOf(this.getValue());
                    }
                };
            }

            public Map.Entry<K, Set<Row<E>>> convertBackwards(Map.Entry<K, Set<Row<E>>> element) {
                throw new UnsupportedOperationException();
            }
        }));
    }

    @Override
    public boolean equals(Object o) {
        return this.keyToRowSetMap.equals(o);
    }

    @Override
    public K firstKey() {
        return this.keyToRowSetMap.firstKey();
    }

    @Override
    public Set<Row<E>> get(Object key) {
        return this.containsKey(key) ? Collections.unmodifiableSet((Set)this.keyToRowSetMap.get(key)) : null;
    }

    @Override
    public void handleAddedColumn(int columnIndex, E ... elements) {
        this.rebuildIndexFully();
    }

    @Override
    public void handleAddedRow(int rowIndex, E ... elements) {
        this.rebuildIndexFully();
    }

    @Override
    public void handleClearTable() {
        this.keyToRowSetMap.clear();
    }

    @Override
    public void handleRemovedColumn(int columnIndex, E[] previousElements, String columnTitle) {
        this.rebuildIndexFully();
    }

    @Override
    public void handleRemovedRow(int rowIndex, E[] previousElements, String rowTitle) {
        K key = this.extractKey(previousElements);
        boolean containsKey = this.keyToRowSetMap.containsKey(key);
        if (containsKey) {
            Set rowSet = (Set)this.keyToRowSetMap.get(key);
            for (Row row : rowSet) {
                if (!row.isDeleted() && row.index() != rowIndex) continue;
                rowSet.remove(row);
                break;
            }
            if (rowSet.isEmpty()) {
                this.keyToRowSetMap.remove(key);
            }
        }
    }

    private K extractKey(E[] previousElements) {
        ElementsToRowDataReaderAdapter<E> rowDataReader = new ElementsToRowDataReaderAdapter<E>(previousElements, this.table);
        Object key = this.keyExtractor.extractKey(rowDataReader);
        return (K)key;
    }

    @Override
    public void handleUpdatedCell(int rowIndex, int columnIndex, E element, E previousElement) {
        Row<E> row = this.table.row(rowIndex);
        E[] elements = row.getElements();
        E[] elementsPrevious = Arrays.copyOf(elements, elements.length);
        elementsPrevious[columnIndex] = previousElement;
        K keyPrevious = this.extractKey(elementsPrevious);
        K keyNew = this.extractKey(elements);
        this.updateForChangedRow(rowIndex, row, keyPrevious, keyNew);
    }

    @Override
    public void handleUpdatedRow(int rowIndex, E[] elements, E[] previousElements, BitSet modifiedIndices) {
        Row<E> row = this.table.row(rowIndex);
        K keyPrevious = this.extractKey(previousElements);
        K keyNew = this.extractKey(elements);
        this.updateForChangedRow(rowIndex, row, keyPrevious, keyNew);
    }

    private void updateForChangedRow(int rowIndex, Row<E> row, K keyPrevious, K keyNew) {
        if (!ObjectUtils.equals(keyNew, keyPrevious)) {
            Set rowSet;
            if (keyPrevious != null) {
                rowSet = (Set)this.keyToRowSetMap.get(keyPrevious);
                HashSet<Row> rowRemovableSet = new HashSet<Row>();
                for (Row iRow : rowSet) {
                    if (iRow.index() != rowIndex) continue;
                    rowRemovableSet.add(iRow);
                }
                rowSet.removeAll(rowRemovableSet);
                if (rowSet.isEmpty()) {
                    this.keyToRowSetMap.remove(keyPrevious);
                }
            }
            if (keyNew != null) {
                rowSet = (Set)this.keyToRowSetMap.get(keyNew);
                rowSet.add(row);
            }
        }
    }

    @Override
    public int hashCode() {
        return this.keyToRowSetMap.hashCode();
    }

    @Override
    public SortedMap<K, Set<Row<E>>> headMap(K toKey) {
        return Collections.unmodifiableSortedMap(MapUtils.adapter(this.keyToRowSetMap.headMap(toKey), (ElementBidirectionalConverter)new ElementBidirectionalConverterSetToUnmodifiableSet()));
    }

    @Override
    public boolean isEmpty() {
        return this.keyToRowSetMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.keyToRowSetMap.keySet());
    }

    @Override
    public K lastKey() {
        return this.keyToRowSetMap.lastKey();
    }

    @Override
    public Set<Row<E>> put(K key, Set<Row<E>> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends Set<Row<E>>> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Row<E>> remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.keyToRowSetMap.size();
    }

    @Override
    public SortedMap<K, Set<Row<E>>> subMap(K fromKey, K toKey) {
        return Collections.unmodifiableSortedMap(MapUtils.adapter(this.keyToRowSetMap.subMap(fromKey, toKey), (ElementBidirectionalConverter)new ElementBidirectionalConverterSetToUnmodifiableSet()));
    }

    @Override
    public SortedMap<K, Set<Row<E>>> tailMap(K fromKey) {
        return Collections.unmodifiableSortedMap(MapUtils.adapter(this.keyToRowSetMap.tailMap(fromKey), (ElementBidirectionalConverter)new ElementBidirectionalConverterSetToUnmodifiableSet()));
    }

    @Override
    public Collection<Set<Row<E>>> values() {
        return Collections.unmodifiableCollection(CollectionUtils.adapter(this.keyToRowSetMap.values(), (ElementBidirectionalConverter)new ElementBidirectionalConverterSetToUnmodifiableSet()));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(MapUtils.toString((Map)this));
        return builder.toString();
    }

    @Override
    public void handleModifiedColumnTitle(int columnIndex, String columnTitle, String columnTitlePrevious) {
    }

    @Override
    public void handleModifiedRowTitle(int rowIndex, String rowTitle, String rowTitlePrevious) {
    }

    @Override
    public void handleModifiedColumnTitles(String[] columnTitles, String[] columnTitlesPrevious) {
    }

    @Override
    public void handleModifiedRowTitles(String[] rowTitles, String[] rowTitlesPrevious) {
    }

    @Override
    public void handleModifiedTableName(String tableName, String tableNamePrevious) {
    }
}

