/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.omnaest.utils.structure.collection.CollectionUtils;
import org.omnaest.utils.structure.collection.set.SetUtils;
import org.omnaest.utils.structure.element.converter.ElementBidirectionalConverter;
import org.omnaest.utils.structure.element.converter.ElementBidirectionalConverterSerializable;
import org.omnaest.utils.structure.element.converter.ElementBidirectionalConverterSetToUnmodifiableSet;
import org.omnaest.utils.structure.element.factory.Factory;
import org.omnaest.utils.structure.element.factory.concrete.LinkedHashSetFactory;
import org.omnaest.utils.structure.map.MapUtils;
import org.omnaest.utils.table.Cell;
import org.omnaest.utils.table.Column;
import org.omnaest.utils.table.ImmutableCell;
import org.omnaest.utils.table.TableEventHandler;
import org.omnaest.utils.table.TableIndex;

class TableIndexColumnBasedImpl<E>
implements TableIndex<E, Cell<E>>,
SortedMap<E, Set<Cell<E>>>,
TableEventHandler<E>,
Serializable {
    private static final long serialVersionUID = 3723253328291423721L;
    private final Column<E> column;
    private final SortedMap<E, Set<Cell<E>>> elementToCellSetMap;

    TableIndexColumnBasedImpl(Column<E> column) {
        this.column = column;
        this.elementToCellSetMap = MapUtils.initializedSortedMap(new ConcurrentSkipListMap(), (Factory)new LinkedHashSetFactory());
        for (Cell cell : column.cells()) {
            Object element = cell.getElement();
            ((Set)this.elementToCellSetMap.get(element)).add(cell);
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.elementToCellSetMap.comparator();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.elementToCellSetMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.elementToCellSetMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<E, Set<Cell<E>>>> entrySet() {
        return Collections.unmodifiableSet(SetUtils.adapter(this.elementToCellSetMap.entrySet(), (ElementBidirectionalConverter)new ElementBidirectionalConverterSerializable<Map.Entry<E, Set<Cell<E>>>, Map.Entry<E, Set<Cell<E>>>>(){
            private static final long serialVersionUID = 1170906776959603812L;

            public Map.Entry<E, Set<Cell<E>>> convert(final Map.Entry<E, Set<Cell<E>>> entry) {
                return new Map.Entry<E, Set<Cell<E>>>(){

                    @Override
                    public E getKey() {
                        return entry.getKey();
                    }

                    @Override
                    public Set<Cell<E>> getValue() {
                        return Collections.unmodifiableSet((Set)entry.getValue());
                    }

                    @Override
                    public Set<Cell<E>> setValue(Set<Cell<E>> value) {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public Map.Entry<E, Set<Cell<E>>> convertBackwards(Map.Entry<E, Set<Cell<E>>> element) {
                throw new UnsupportedOperationException();
            }
        }));
    }

    @Override
    public boolean equals(Object o) {
        return this.elementToCellSetMap.equals(o);
    }

    @Override
    public E firstKey() {
        return this.elementToCellSetMap.firstKey();
    }

    @Override
    public Set<Cell<E>> get(Object key) {
        return this.containsKey(key) ? Collections.unmodifiableSet((Set)this.elementToCellSetMap.get(key)) : null;
    }

    @Override
    public void handleAddedColumn(int columnIndex, E ... elements) {
    }

    @Override
    public void handleAddedRow(int rowIndex, E ... elements) {
        Cell cell = this.column.cell(rowIndex);
        Object element = cell.getElement();
        ((Set)this.elementToCellSetMap.get(element)).add(cell);
    }

    @Override
    public void handleClearTable() {
        this.elementToCellSetMap.clear();
    }

    @Override
    public void handleRemovedColumn(int columnIndex, E[] previousElements, String columnTitle) {
        if (this.column.index() == columnIndex) {
            this.handleClearTable();
        }
    }

    @Override
    public void handleRemovedRow(int rowIndex, E[] previousElements, String rowTitle) {
        int columnIndex = this.column.index();
        Object element = previousElements.length > columnIndex ? previousElements[columnIndex] : null;
        Set cellSet = (Set)this.elementToCellSetMap.get(element);
        if (cellSet != null) {
            for (Cell cell : cellSet) {
                if (cell.rowIndex() != rowIndex) continue;
                cellSet.remove(cell);
                break;
            }
            if (cellSet.isEmpty()) {
                this.elementToCellSetMap.remove(element);
            }
        }
    }

    @Override
    public void handleUpdatedCell(int rowIndex, int columnIndex, E element, E previousElement) {
        if (columnIndex == this.column.index()) {
            Cell cell = this.column.cell(rowIndex);
            ImmutableCell.Position position = cell.getPosition();
            Set cellSet = (Set)this.elementToCellSetMap.get(previousElement);
            HashSet<Cell> cellRemovableSet = new HashSet<Cell>();
            for (Cell iCell : cellSet) {
                if (!iCell.isDeleted() && !iCell.isModified() && !position.equals(iCell.getPosition())) continue;
                cellRemovableSet.add(iCell);
            }
            cellSet.removeAll(cellRemovableSet);
            if (cellSet.isEmpty()) {
                this.elementToCellSetMap.remove(previousElement);
            }
            Set cellSet2 = (Set)this.elementToCellSetMap.get(element);
            cellSet2.add(cell);
        }
    }

    @Override
    public void handleUpdatedRow(int rowIndex, E[] elements, E[] previousElements, BitSet modifiedIndices) {
        int ii = 0;
        while (ii >= 0) {
            E element = elements[ii];
            E previousElement = previousElements[ii];
            int columnIndex = ii;
            this.handleUpdatedCell(rowIndex, columnIndex, element, previousElement);
            modifiedIndices.nextSetBit(ii + 1);
        }
    }

    @Override
    public int hashCode() {
        return this.elementToCellSetMap.hashCode();
    }

    @Override
    public SortedMap<E, Set<Cell<E>>> headMap(E toKey) {
        return Collections.unmodifiableSortedMap(MapUtils.adapter(this.elementToCellSetMap.headMap(toKey), (ElementBidirectionalConverter)new ElementBidirectionalConverterSetToUnmodifiableSet()));
    }

    @Override
    public int index() {
        return this.column.index();
    }

    @Override
    public boolean isEmpty() {
        return this.elementToCellSetMap.isEmpty();
    }

    @Override
    public Set<E> keySet() {
        return Collections.unmodifiableSet(this.elementToCellSetMap.keySet());
    }

    @Override
    public E lastKey() {
        return this.elementToCellSetMap.lastKey();
    }

    @Override
    public Set<Cell<E>> put(E key, Set<Cell<E>> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends E, ? extends Set<Cell<E>>> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Cell<E>> remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.elementToCellSetMap.size();
    }

    @Override
    public SortedMap<E, Set<Cell<E>>> subMap(E fromKey, E toKey) {
        return Collections.unmodifiableSortedMap(MapUtils.adapter(this.elementToCellSetMap.subMap(fromKey, toKey), (ElementBidirectionalConverter)new ElementBidirectionalConverterSetToUnmodifiableSet()));
    }

    @Override
    public SortedMap<E, Set<Cell<E>>> tailMap(E fromKey) {
        return Collections.unmodifiableSortedMap(MapUtils.adapter(this.elementToCellSetMap.tailMap(fromKey), (ElementBidirectionalConverter)new ElementBidirectionalConverterSetToUnmodifiableSet()));
    }

    @Override
    public Collection<Set<Cell<E>>> values() {
        return Collections.unmodifiableCollection(CollectionUtils.adapter(this.elementToCellSetMap.values(), (ElementBidirectionalConverter)new ElementBidirectionalConverterSetToUnmodifiableSet()));
    }

    @Override
    public void handleModifiedColumnTitle(int columnIndex, String columnTitle, String columnTitlePrevious) {
    }

    @Override
    public void handleModifiedRowTitle(int rowIndex, String rowTitle, String rowTitlePrevious) {
    }

    @Override
    public void handleModifiedColumnTitles(String[] columnTitles, String[] columnTitlesPrevious) {
    }

    @Override
    public void handleModifiedRowTitles(String[] rowTitles, String[] rowTitlesPrevious) {
    }

    @Override
    public void handleModifiedTableName(String tableName, String tableNamePrevious) {
    }
}

